/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

public abstract class MouseFocusObserver
implements DockRelocatorListener {
    private List<FocusVetoListener> vetos = new ArrayList<FocusVetoListener>();
    private DockController controller;

    public MouseFocusObserver(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        this.controller = dockController;
        controllerSetupCollection.add(new ControllerSetupListener(){

            public void done(DockController dockController) {
                dockController.getRelocator().addDockRelocatorListener(MouseFocusObserver.this);
            }
        });
    }

    public void kill() {
        this.getController().getRelocator().removeDockRelocatorListener(this);
    }

    public DockController getController() {
        return this.controller;
    }

    public void addVetoListener(FocusVetoListener focusVetoListener) {
        this.vetos.add(focusVetoListener);
    }

    public void removeVetoListener(FocusVetoListener focusVetoListener) {
        this.vetos.remove(focusVetoListener);
    }

    protected boolean fireVetoTitle(DockTitle dockTitle) {
        for (FocusVetoListener focusVetoListener : this.vetos.toArray(new FocusVetoListener[this.vetos.size()])) {
            if (!focusVetoListener.vetoFocus(this, dockTitle)) continue;
            return true;
        }
        return false;
    }

    protected boolean fireVetoDockable(Dockable dockable) {
        for (FocusVetoListener focusVetoListener : this.vetos.toArray(new FocusVetoListener[this.vetos.size()])) {
            if (!focusVetoListener.vetoFocus(this, dockable)) continue;
            return true;
        }
        return false;
    }

    protected void check(AWTEvent aWTEvent) {
        if (this.controller.getRelocator().isOnPut() || this.controller.isOnFocusing()) {
            return;
        }
        Object object = aWTEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            if (aWTEvent.getID() == 501) {
                if (component.isFocusable()) {
                    component.requestFocusInWindow();
                    this.check(component, false);
                } else {
                    this.check(component, true);
                }
            } else {
                this.check(component);
            }
        }
    }

    protected boolean interact(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        return n == 501 || n == 507;
    }

    protected void check(Component component) {
        this.check(component, true);
    }

    protected void check(Component component, boolean bl) {
        Dockable dockable = this.getDockable(component);
        if (dockable != null) {
            Dockable dockable2 = this.controller.getFocusedDockable();
            boolean bl2 = true;
            if (dockable2 != null) {
                boolean bl3 = bl2 = !DockUtilities.isAncestor(dockable, dockable2);
            }
            if (bl2) {
                this.controller.setFocusedDockable(dockable, false, bl);
            }
        }
    }

    public void init(DockController dockController, Dockable dockable) {
    }

    public void cancel(DockController dockController, Dockable dockable) {
    }

    public void drag(DockController dockController, Dockable dockable, DockStation dockStation) {
    }

    public void drop(final DockController dockController, final Dockable dockable, DockStation dockStation) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                dockController.setFocusedDockable(dockable, true);
            }
        });
    }

    protected Dockable getDockable(Component component) {
        DockElementRepresentative dockElementRepresentative = this.controller.searchElement(component);
        if (dockElementRepresentative == null) {
            return null;
        }
        Dockable dockable = dockElementRepresentative.getElement().asDockable();
        if (dockable == null) {
            return null;
        }
        if (dockElementRepresentative instanceof DockTitle ? this.fireVetoTitle((DockTitle)dockElementRepresentative) : this.fireVetoDockable(dockable)) {
            return null;
        }
        return dockable;
    }
}

