/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.DirectRemoteRelocator;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDockRelocator
extends DockRelocator {
    private boolean onMove = false;
    private boolean onPut = false;
    private DockStation dragStation;
    private ImageWindow movingImageWindow;
    private Point pressPointScreen;
    private Point pressPointLocal;
    private Point lastPoint;

    public DefaultDockRelocator(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        super(dockController);
        controllerSetupCollection.add(new ControllerSetupListener(){

            public void done(DockController dockController) {
                dockController.addRepresentativeListener(new Listener());
            }
        });
    }

    @Override
    public boolean isOnMove() {
        return this.onMove;
    }

    @Override
    public boolean isOnPut() {
        return this.onPut;
    }

    @Override
    public DirectRemoteRelocator createDirectRemote(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable);
    }

    @Override
    public RemoteRelocator createRemote(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePut(Dockable dockable, DockStation dockStation) {
        this.onPut = true;
        DockController dockController = this.getController();
        dockController.getRegister().setStalled(true);
        this.disableAllModes();
        try {
            if (dockStation == null) {
                throw new IllegalStateException("There is no station to put the dockable.");
            }
            DockStation dockStation2 = dockable.getDockParent();
            if (dockStation2 != dockStation || dockStation2 == null) {
                this.fireDrag(dockable, dockStation);
                if (dockStation2 != null) {
                    dockStation2.drag(dockable);
                }
                dockStation.drop();
                this.fireDrop(dockable, dockStation);
            } else {
                this.fireDrag(dockable, dockStation2);
                dockStation2.move();
                this.fireDrop(dockable, dockStation2);
            }
        }
        finally {
            this.onPut = false;
            dockController.getRegister().setStalled(false);
        }
    }

    protected DockStation preparePut(int n, int n2, int n3, int n4, Dockable dockable) {
        List<DockStation> list = this.listStationsOrdered(n, n2, dockable);
        for (int i = 0; i < 2; ++i) {
            boolean bl = i == 0;
            for (DockStation dockStation : list) {
                if (!(dockable.getDockParent() == dockStation ? dockStation.prepareMove(n, n2, n3, n4, bl, dockable) : dockStation.prepareDrop(n, n2, n3, n4, bl, dockable))) continue;
                return dockStation;
            }
        }
        return null;
    }

    protected List<DockStation> listStationsOrdered(int n, int n2, Dockable dockable) {
        LinkedList<DockStation> linkedList = new LinkedList<DockStation>();
        DockStation dockStation = dockable.asDockStation();
        DockController dockController = this.getController();
        for (DockStation dockStation2 : dockController.getRegister().listDockStations()) {
            DockStation dockStation3;
            int n3;
            Rectangle rectangle;
            if (dockStation != null && (DockUtilities.isAncestor(dockStation, dockStation2) || dockStation == dockStation2) || !dockStation2.isStationVisible() || (rectangle = dockStation2.getStationBounds()) != null && !rectangle.contains(n, n2)) continue;
            int n4 = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext() && (n3 = this.compare(dockStation3 = (DockStation)iterator.next(), dockStation2)) >= 0) {
                ++n4;
            }
            linkedList.add(n4, dockStation2);
        }
        return linkedList;
    }

    protected int compare(DockStation dockStation, DockStation dockStation2) {
        if (DockUtilities.isAncestor(dockStation, dockStation2)) {
            return -1;
        }
        if (DockUtilities.isAncestor(dockStation2, dockStation)) {
            return 1;
        }
        if (dockStation.canCompare(dockStation2)) {
            return dockStation.compare(dockStation2);
        }
        if (dockStation2.canCompare(dockStation)) {
            return -dockStation2.compare(dockStation);
        }
        Dockable dockable = dockStation.asDockable();
        Dockable dockable2 = dockStation2.asDockable();
        if (dockable != null && dockable2 != null) {
            Component component = dockable.getComponent();
            Component component2 = dockable2.getComponent();
            Window window = SwingUtilities.getWindowAncestor(component);
            Window window2 = SwingUtilities.getWindowAncestor(component2);
            if (window != null && window2 != null) {
                if (this.isParent(window, window2)) {
                    return -1;
                }
                if (this.isParent(window2, window)) {
                    return 1;
                }
            }
        }
        return 0;
    }

    private boolean isParent(Window window, Window window2) {
        for (Window window3 = window2.getOwner(); window3 != null; window3 = window3.getOwner()) {
            if (window3 != window) continue;
            return true;
        }
        return false;
    }

    protected void dragMousePressed(MouseEvent mouseEvent, DockTitle dockTitle, Dockable dockable) {
        if (dockable == null) {
            dockable = dockTitle.getDockable();
        }
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMousePressed(point.x, point.y, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx(), dockable);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            mouseEvent.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMousePressed(int n, int n2, int n3, int n4, int n5, Dockable dockable) {
        if (dockable.getDockParent() == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.lastPoint = new Point(n, n2);
        int n6 = 1024;
        int n7 = 6144;
        if ((n5 & (n6 | n7)) == n6) {
            this.titleDragCancel();
            this.onMove = false;
            this.pressPointScreen = new Point(n, n2);
            this.pressPointLocal = new Point(n3, n4);
            this.checkModes(n5);
            return RemoteRelocator.Reaction.CONTINUE;
        }
        if (this.pressPointScreen != null) {
            this.titleDragCancel();
            this.disableAllModes();
            this.fireCancel(dockable);
            return RemoteRelocator.Reaction.BREAK_CONSUMED;
        }
        return RemoteRelocator.Reaction.BREAK;
    }

    protected void dragMouseDragged(MouseEvent mouseEvent, DockTitle dockTitle, Dockable dockable) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseDragged(point.x, point.y, mouseEvent.getModifiersEx(), dockTitle, dockable, false);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            mouseEvent.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseDragged(int n, int n2, int n3, DockTitle dockTitle, Dockable dockable, boolean bl) {
        if (this.pressPointScreen == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.checkModes(n3);
        if (dockable == null) {
            dockable = dockTitle.getDockable();
        }
        Point point = new Point(n, n2);
        this.lastPoint = new Point(n, n2);
        if (!this.onMove) {
            if (!dockable.getDockParent().canDrag(dockable)) {
                this.titleDragCancel();
                this.disableAllModes();
                return RemoteRelocator.Reaction.BREAK_CONSUMED;
            }
            int n4 = Math.abs(n - this.pressPointScreen.x) + Math.abs(n2 - this.pressPointScreen.y);
            if (bl || n4 >= this.getDragDistance()) {
                if (this.movingImageWindow != null) {
                    this.movingImageWindow.close();
                    this.movingImageWindow = null;
                }
                this.movingImageWindow = this.getTitleWindow(dockable, dockTitle);
                if (this.movingImageWindow != null) {
                    this.updateTitleWindowPosition(point);
                    this.movingImageWindow.setVisible(true);
                }
                this.onMove = true;
                this.fireInit(dockable);
            }
        }
        if (this.onMove) {
            DockStation dockStation;
            if (this.movingImageWindow != null) {
                this.updateTitleWindowPosition(point);
            }
            if ((dockStation = this.preparePut(point.x, point.y, point.x - this.pressPointLocal.x, point.y - this.pressPointLocal.y, dockable)) != null) {
                dockStation.draw();
            }
            if (dockStation != this.dragStation) {
                if (this.dragStation != null) {
                    this.dragStation.forget();
                }
                this.dragStation = dockStation;
            }
        }
        return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
    }

    private void updateTitleWindowPosition(Point point) {
        int n = Math.min(25, this.movingImageWindow.getWidth());
        int n2 = Math.min(25, this.movingImageWindow.getHeight());
        int n3 = Math.min(n, n2) + 1;
        int n4 = Math.min(n, this.pressPointLocal.x);
        int n5 = Math.min(n2, this.pressPointLocal.y);
        this.movingImageWindow.setLocation(point.x - n4 + n3, point.y - n5 + n3);
    }

    protected void dragMouseReleased(MouseEvent mouseEvent, DockTitle dockTitle, Dockable dockable) {
        if (dockable == null) {
            dockable = dockTitle.getDockable();
        }
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseReleased(point.x, point.y, mouseEvent.getModifiersEx(), dockable);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            mouseEvent.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseReleased(int n, int n2, int n3, Dockable dockable) {
        boolean bl;
        this.checkModes(n3);
        int n4 = 7168;
        boolean bl2 = bl = !this.onMove || (n3 & n4) == 0;
        if (bl && this.onMove) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DefaultDockRelocator.this.onMove = false;
                }
            });
        }
        if (!this.onMove) {
            boolean bl3 = this.pressPointScreen != null;
            this.titleDragCancel();
            this.disableAllModes();
            if (bl) {
                this.fireCancel(dockable);
                if (bl3) {
                    return RemoteRelocator.Reaction.BREAK_CONSUMED;
                }
                return RemoteRelocator.Reaction.BREAK;
            }
            return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
        }
        boolean bl4 = false;
        if (bl) {
            if (this.pressPointScreen != null) {
                DockStation dockStation;
                DockStation dockStation2 = this.dragStation;
                if ((n != this.lastPoint.x || n2 != this.lastPoint.y) && (dockStation = this.preparePut(n, n2, n - this.pressPointLocal.x, n2 - this.pressPointLocal.y, dockable)) != dockStation2) {
                    if (dockStation2 != null) {
                        dockStation2.forget();
                    }
                    dockStation2 = dockStation;
                }
                if (dockStation2 != null) {
                    bl4 = true;
                    this.executePut(dockable, dockStation2);
                    dockStation2.forget();
                    this.dragStation = null;
                }
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
        if (bl) {
            this.disableAllModes();
            return bl4 ? RemoteRelocator.Reaction.BREAK_CONSUMED : RemoteRelocator.Reaction.BREAK;
        }
        return bl4 ? RemoteRelocator.Reaction.CONTINUE_CONSUMED : RemoteRelocator.Reaction.CONTINUE;
    }

    private void titleDragCancel() {
        if (!this.isOnPut()) {
            if (this.dragStation != null) {
                this.dragStation.forget();
                this.dragStation = null;
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
    }

    private ImageWindow getTitleWindow(Dockable dockable, DockTitle dockTitle) {
        DockController dockController = this.getController();
        DockableMovingImageFactory dockableMovingImageFactory = dockController.getTheme().getMovingImageFactory(dockController);
        MovingImage movingImage = dockTitle == null ? dockableMovingImageFactory.create(dockController, dockable) : dockableMovingImageFactory.create(dockController, dockTitle);
        if (movingImage == null) {
            return null;
        }
        Window window = dockTitle == null ? SwingUtilities.getWindowAncestor(dockable.getComponent()) : SwingUtilities.getWindowAncestor(dockTitle.getComponent());
        ImageWindow imageWindow = new ImageWindow(window, movingImage);
        imageWindow.pack();
        return imageWindow;
    }

    private class ImageWindow
    extends JWindow {
        private MovingImage image;

        public ImageWindow(Window window, MovingImage movingImage) {
            super(window);
            this.addComponentListener(new ComponentListener(){

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentResized(ComponentEvent componentEvent) {
                }

                public void componentShown(ComponentEvent componentEvent) {
                    if (ImageWindow.this != DefaultDockRelocator.this.movingImageWindow) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ImageWindow.this.close();
                            }
                        });
                    }
                }
            });
            Container container = this.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            this.setFocusableWindowState(false);
            try {
                this.setAlwaysOnTop(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            movingImage.bind();
            container.add(movingImage.getComponent());
            this.image = movingImage;
        }

        public void close() {
            this.dispose();
            if (this.image != null) {
                this.image.unbind();
                this.image = null;
            }
            this.getContentPane().removeAll();
        }
    }

    private class MouseRepresentativeListener
    extends MouseInputAdapter {
        private DockTitle title;
        private Dockable dockable;
        private DockElementRepresentative representative;

        public MouseRepresentativeListener(DockElementRepresentative dockElementRepresentative) {
            this.representative = dockElementRepresentative;
            if (dockElementRepresentative instanceof DockTitle) {
                this.title = (DockTitle)dockElementRepresentative;
            }
            this.dockable = dockElementRepresentative.getElement().asDockable();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMousePressed(mouseEvent, this.title, this.dockable);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseReleased(mouseEvent, this.title, this.dockable);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseDragged(mouseEvent, this.title, this.dockable);
        }
    }

    private class Listener
    implements DockControllerRepresentativeListener {
        private Map<DockElementRepresentative, MouseRepresentativeListener> listeners = new HashMap<DockElementRepresentative, MouseRepresentativeListener>();

        private Listener() {
        }

        public void representativeAdded(DockController dockController, DockElementRepresentative dockElementRepresentative) {
            if (dockElementRepresentative.getElement().asDockable() != null) {
                MouseRepresentativeListener mouseRepresentativeListener = new MouseRepresentativeListener(dockElementRepresentative);
                this.listeners.put(dockElementRepresentative, mouseRepresentativeListener);
                dockElementRepresentative.addMouseInputListener(mouseRepresentativeListener);
            }
        }

        public void representativeRemoved(DockController dockController, DockElementRepresentative dockElementRepresentative) {
            MouseRepresentativeListener mouseRepresentativeListener;
            if (dockElementRepresentative.getElement().asDockable() != null && (mouseRepresentativeListener = this.listeners.remove(dockElementRepresentative)) != null) {
                dockElementRepresentative.removeMouseInputListener(mouseRepresentativeListener);
            }
        }
    }

    private class DefaultRemoteRelocator
    implements RemoteRelocator,
    DirectRemoteRelocator {
        private Dockable dockable;

        public DefaultRemoteRelocator(Dockable dockable) {
            this.dockable = dockable;
        }

        public void cancel() {
            DefaultDockRelocator.this.titleDragCancel();
            DefaultDockRelocator.this.onMove = false;
        }

        public void drag(int n, int n2, boolean bl) {
            DefaultDockRelocator.this.dragMouseDragged(n, n2, 1024, null, this.dockable, bl);
        }

        public RemoteRelocator.Reaction drag(int n, int n2, int n3) {
            return DefaultDockRelocator.this.dragMouseDragged(n, n2, n3, null, this.dockable, false);
        }

        public void drop(int n, int n2) {
            this.drop(n, n2, 0);
        }

        public RemoteRelocator.Reaction drop(int n, int n2, int n3) {
            return DefaultDockRelocator.this.dragMouseReleased(n, n2, n3, this.dockable);
        }

        public void init(int n, int n2, int n3, int n4) {
            this.init(n, n2, n3, n4, 1024);
        }

        public RemoteRelocator.Reaction init(int n, int n2, int n3, int n4, int n5) {
            return DefaultDockRelocator.this.dragMousePressed(n, n2, n3, n4, n5, this.dockable);
        }
    }
}

