/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockAdapter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ActionBinder
extends DockAdapter {
    private Map<Dockable, SourceObserver> observers = new HashMap<Dockable, SourceObserver>();

    public void dockableRegistered(DockController dockController, Dockable dockable) {
        this.observers.put(dockable, new SourceObserver(dockable));
    }

    public void dockableUnregistered(DockController dockController, Dockable dockable) {
        this.observers.remove(dockable).destroy();
    }

    private static class SourceObserver
    implements DockActionSourceListener {
        private List<DockAction> actions = new LinkedList<DockAction>();
        private Dockable dockable;

        public SourceObserver(Dockable dockable) {
            this.dockable = dockable;
            DockActionSource dockActionSource = dockable.getGlobalActionOffers();
            this.actionsAdded(dockActionSource, 0, dockActionSource.getDockActionCount() - 1);
            dockActionSource.addDockActionSourceListener(this);
        }

        public void destroy() {
            DockActionSource dockActionSource = this.dockable.getGlobalActionOffers();
            dockActionSource.removeDockActionSourceListener(this);
            this.actionsRemoved(dockActionSource, 0, dockActionSource.getDockActionCount() - 1);
        }

        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                DockAction dockAction = dockActionSource.getDockAction(i);
                this.actions.add(i, dockAction);
                dockAction.bind(this.dockable);
            }
        }

        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n2; i >= n; --i) {
                DockAction dockAction = this.actions.remove(i);
                dockAction.unbind(this.dockable);
            }
        }
    }
}

