/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.extension.gui.dock.preference.editor.KeyStrokeEditor;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.actions.AbstractStandardDockAction;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.KeyboardListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class SimpleDockAction
extends AbstractStandardDockAction {
    private Icon icon;
    private Icon disabledIcon;
    private String text;
    private String tooltip;
    private boolean enabled = true;
    private KeyStroke accelerator;
    private Map<Dockable, DockableKeyForwarder> forwarders = new HashMap<Dockable, DockableKeyForwarder>();

    protected void bound(Dockable dockable) {
        super.bound(dockable);
        DockableKeyForwarder dockableKeyForwarder = new DockableKeyForwarder(dockable);
        this.forwarders.put(dockable, dockableKeyForwarder);
    }

    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        DockableKeyForwarder dockableKeyForwarder = this.forwarders.remove(dockable);
        dockableKeyForwarder.destroy();
    }

    public Icon getIcon(Dockable dockable) {
        return this.icon;
    }

    public String getText(Dockable dockable) {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.fireActionTextChanged(this.getBoundDockables());
    }

    public String getTooltipText(Dockable dockable) {
        return this.getTooltipText();
    }

    public String getTooltipText() {
        if (this.accelerator == null) {
            return this.tooltip;
        }
        String string = KeyStrokeEditor.toString(this.accelerator, true);
        if (this.tooltip == null) {
            return string;
        }
        return this.tooltip + " (" + string + ")";
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    public boolean isEnabled(Dockable dockable) {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.fireActionEnabledChanged(this.getBoundDockables());
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.fireActionIconChanged(this.getBoundDockables());
    }

    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    public Icon getDisabledIcon(Dockable dockable) {
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        this.disabledIcon = icon;
        this.fireActionDisabledIconChanged(this.getBoundDockables());
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.accelerator = keyStroke;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    protected boolean trigger(KeyEvent keyEvent, Dockable dockable) {
        return this.trigger(dockable);
    }

    private class DockableKeyForwarder
    implements KeyboardListener,
    DockHierarchyListener {
        private Dockable dockable;

        public DockableKeyForwarder(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockHierarchyListener(this);
            if (dockable.getController() != null) {
                dockable.getController().getKeyboardController().addListener(this);
            }
        }

        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            if (dockHierarchyEvent.getController() != null) {
                dockHierarchyEvent.getController().getKeyboardController().removeListener(this);
            }
            if (this.dockable.getController() != null) {
                this.dockable.getController().getKeyboardController().addListener(this);
            }
        }

        public void destroy() {
            if (this.dockable.getController() != null) {
                this.dockable.getController().getKeyboardController().removeListener(this);
            }
            this.dockable.removeDockHierarchyListener(this);
        }

        private boolean forward(DockElement dockElement, KeyEvent keyEvent) {
            if (SimpleDockAction.this.accelerator != null && SimpleDockAction.this.accelerator.equals(KeyStroke.getKeyStrokeForEvent(keyEvent))) {
                return SimpleDockAction.this.trigger(keyEvent, this.dockable);
            }
            return false;
        }

        public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
            return this.forward(dockElement, keyEvent);
        }

        public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
            return this.forward(dockElement, keyEvent);
        }

        public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
            return this.forward(dockElement, keyEvent);
        }

        public DockElement getTreeLocation() {
            return this.dockable;
        }
    }
}

