/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDockActionSource
extends AbstractDockActionSource {
    private List<DockActionSource> sources = new ArrayList<DockActionSource>();
    private List<SeparatorSource> separators = new ArrayList<SeparatorSource>();
    private Listener listener = new Listener();
    private boolean separateSources = false;
    private LocationHint hint;

    public MultiDockActionSource(DockActionSource ... dockActionSourceArray) {
        this(LocationHint.UNKNOWN, dockActionSourceArray);
    }

    public MultiDockActionSource(LocationHint locationHint, DockActionSource ... dockActionSourceArray) {
        for (DockActionSource dockActionSource : dockActionSourceArray) {
            this.sources.add(dockActionSource);
        }
        this.setHint(locationHint);
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private Iterator<DockActionSource> sourceIterator;
            private Iterator<DockAction> actionIterator;
            {
                this.sourceIterator = MultiDockActionSource.this.sources.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.actionIterator == null) {
                    if (this.sourceIterator.hasNext()) {
                        this.actionIterator = this.sourceIterator.next().iterator();
                    } else {
                        return false;
                    }
                }
                while (true) {
                    if (this.actionIterator.hasNext()) {
                        return true;
                    }
                    if (!this.sourceIterator.hasNext()) break;
                    this.actionIterator = this.sourceIterator.next().iterator();
                }
                return false;
            }

            @Override
            public DockAction next() {
                this.hasNext();
                return this.actionIterator.next();
            }

            @Override
            public void remove() {
                this.hasNext();
                this.actionIterator.remove();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        boolean bl = this.listeners.isEmpty();
        super.addDockActionSourceListener(dockActionSourceListener);
        if (bl && !this.listeners.isEmpty()) {
            for (DockActionSource dockActionSource : this.sources) {
                dockActionSource.addDockActionSourceListener(this.listener);
            }
            this.updateSeparators();
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        boolean bl = this.listeners.isEmpty();
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (!bl && this.listeners.isEmpty()) {
            for (DockActionSource dockActionSource : this.sources) {
                dockActionSource.removeDockActionSourceListener(this.listener);
            }
        }
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    public void setHint(LocationHint locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException("Hint must not be null");
        }
        this.hint = locationHint;
    }

    public void addSeparator() {
        this.add(SeparatorAction.SEPARATOR);
    }

    public boolean isSeparateSources() {
        return this.separateSources;
    }

    public void setSeparateSources(boolean bl) {
        if (this.separateSources != bl) {
            this.separateSources = bl;
            this.updateSeparators();
        }
    }

    public void add(DockActionSource dockActionSource) {
        SeparatorSource separatorSource = new SeparatorSource(dockActionSource);
        this.sources.add(dockActionSource);
        this.sources.add(separatorSource);
        this.separators.add(separatorSource);
        if (!this.listeners.isEmpty()) {
            dockActionSource.addDockActionSourceListener(this.listener);
            separatorSource.addDockActionSourceListener(this.listener);
        }
        int n = this.getDockActionCountUntil(this.sources.size() - 1, false);
        int n2 = dockActionSource.getDockActionCount();
        if (n2 > 0) {
            this.fireAdded(n, n + n2 - 1);
        }
        this.updateSeparators();
    }

    public void add(DockAction ... dockActionArray) {
        this.add(new DefaultDockActionSource(dockActionArray));
    }

    @Override
    public int getDockActionCount() {
        return this.getDockActionCountUntil(this.sources.size(), true);
    }

    protected int getSource(DockAction dockAction) {
        int n = this.sources.size();
        for (int i = 0; i < n; ++i) {
            DockActionSource dockActionSource = this.sources.get(i);
            int n2 = dockActionSource.getDockActionCount();
            for (int j = 0; j < n2; ++j) {
                if (dockActionSource.getDockAction(j) != dockAction) continue;
                return i;
            }
        }
        return -1;
    }

    protected int getDockActionCountUntil(int n, boolean bl) {
        if (bl && this.listeners.isEmpty()) {
            this.updateSeparators();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.sources.get(i).getDockActionCount();
        }
        return n2;
    }

    @Override
    public DockAction getDockAction(int n) {
        if (this.listeners.isEmpty()) {
            this.updateSeparators();
        }
        int n2 = 0;
        int n3 = this.sources.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.sources.get(i).getDockActionCount();
            if (n2 <= n && n < n2 + n4) {
                return this.sources.get(i).getDockAction(n - n2);
            }
            n2 += n4;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private void updateSeparators() {
        int n = this.separators.size();
        int n2 = 0;
        for (SeparatorSource separatorSource : this.separators) {
            separatorSource.update(++n2 == n);
        }
    }

    private class SeparatorSource
    extends DefaultDockActionSource {
        private DockActionSource predecessor;

        public SeparatorSource(DockActionSource dockActionSource) {
            super(new DockAction[0]);
            this.predecessor = dockActionSource;
        }

        public void update(boolean bl) {
            if (!MultiDockActionSource.this.separateSources || bl) {
                this.remove(SeparatorAction.SEPARATOR);
            } else if (this.predecessor.getDockActionCount() > 0 && this.getDockActionCount() == 0) {
                this.add(SeparatorAction.SEPARATOR);
            }
        }
    }

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = MultiDockActionSource.this.getDockActionCountUntil(MultiDockActionSource.this.sources.indexOf(dockActionSource), false);
            MultiDockActionSource.this.fireAdded(n + n3, n2 + n3);
            MultiDockActionSource.this.updateSeparators();
        }

        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3 = MultiDockActionSource.this.getDockActionCountUntil(MultiDockActionSource.this.sources.indexOf(dockActionSource), false);
            MultiDockActionSource.this.fireRemoved(n + n3, n2 + n3);
            MultiDockActionSource.this.updateSeparators();
        }
    }
}

