/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class ActionPopup
extends MouseInputAdapter {
    private boolean suppressable;
    private JPopupMenu menu;

    public ActionPopup(boolean bl) {
        this.suppressable = bl;
    }

    public boolean isSuppressable() {
        return this.suppressable;
    }

    public void setSuppressable(boolean bl) {
        this.suppressable = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup(mouseEvent);
        }
    }

    protected abstract boolean isEnabled();

    protected abstract Dockable getDockable();

    protected abstract DockActionSource getSource();

    protected void popup(MouseEvent mouseEvent) {
        boolean bl;
        if (this.isMenuOpen()) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this.isEnabled() && (bl = this.popup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY()))) {
            mouseEvent.consume();
        }
    }

    protected Point getPopupLocation(Component component, Point point) {
        return point;
    }

    public boolean popup(Component component, int n, int n2) {
        JPopupMenu jPopupMenu;
        Point point = this.getPopupLocation(component, new Point(n, n2));
        if (point == null) {
            return false;
        }
        Dockable dockable = this.getDockable();
        if (dockable.getController() == null) {
            return false;
        }
        if (dockable.getController().getRelocator().isOnMove()) {
            return false;
        }
        DockActionSource dockActionSource = this.getSource();
        if (dockActionSource.getDockActionCount() == 0) {
            return false;
        }
        if (this.isSuppressable() && dockable.getController().getPopupSuppressor().suppress(dockable, dockActionSource)) {
            return false;
        }
        this.menu = jPopupMenu = new JPopupMenu();
        final MenuMenuHandler menuMenuHandler = new MenuMenuHandler(dockActionSource, dockable, this.menu);
        menuMenuHandler.bind();
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                menuMenuHandler.unbind();
                if (jPopupMenu == ActionPopup.this.menu) {
                    ActionPopup.this.menu = null;
                }
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.menu.show(component, point.x, point.y);
        return true;
    }

    public boolean isMenuOpen() {
        return this.menu != null;
    }
}

