/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.stack.DefaultStackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.support.DisplayerFactoryWrapper;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackDockStation
extends AbstractDockableStation {
    public static final String TITLE_ID = "stack";
    public static final PropertyKey<StackDockComponentFactory> COMPONENT_FACTORY = new PropertyKey("stack dock component factory");
    private List<DockableDisplayer> dockables = new ArrayList<DockableDisplayer>();
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private DockableVisibilityManager visibility;
    private StationPaintWrapper paint = new StationPaintWrapper();
    private DisplayerFactoryWrapper displayerFactory = new DisplayerFactoryWrapper();
    private DisplayerCollection displayers;
    private Dockable dropping;
    private boolean draw = false;
    private Insert insert;
    private Background background;
    private JComponent panel;
    private StackDockComponent stackComponent;
    private PropertyValue<StackDockComponentFactory> stackComponentFactory;
    private DockTitleVersion title;
    private Listener listener = new Listener();
    private VisibleListener visibleListener;

    public StackDockStation() {
        this(null);
    }

    public StackDockStation(DockTheme dockTheme) {
        super(dockTheme);
        this.init();
    }

    protected StackDockStation(DockTheme dockTheme, boolean bl) {
        super(dockTheme);
        if (bl) {
            this.init();
        }
    }

    protected void init() {
        this.visibleListener = new VisibleListener();
        this.visibility = new DockableVisibilityManager(this.listeners);
        this.displayers = new DisplayerCollection(this, this.displayerFactory);
        this.background = this.createBackground();
        this.panel = this.background.getContentPane();
        this.stackComponentFactory = new PropertyValue<StackDockComponentFactory>(COMPONENT_FACTORY){

            @Override
            protected void valueChanged(StackDockComponentFactory stackDockComponentFactory, StackDockComponentFactory stackDockComponentFactory2) {
                if (stackDockComponentFactory2 == null) {
                    StackDockStation.this.setStackComponent(StackDockStation.this.createStackDockComponent());
                } else {
                    StackDockStation.this.setStackComponent(stackDockComponentFactory2.create(StackDockStation.this));
                }
            }
        };
        this.stackComponent = this.createStackDockComponent();
        this.stackComponent.addChangeListener(this.visibleListener);
    }

    protected Background createBackground() {
        return new Background();
    }

    protected StackDockComponent createStackDockComponent() {
        return new DefaultStackDockComponent();
    }

    public void setStackComponent(StackDockComponent stackDockComponent) {
        if (stackDockComponent == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        if (stackDockComponent != this.stackComponent) {
            Object object;
            int n = -1;
            if (this.stackComponent != null) {
                this.stackComponent.setController(null);
                object = this.stackComponent.getComponent();
                for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                    ((Component)object).removeMouseListener(mouseInputListener);
                    ((Component)object).removeMouseMotionListener(mouseInputListener);
                }
                n = this.stackComponent.getSelectedIndex();
                this.stackComponent.removeChangeListener(this.visibleListener);
                this.stackComponent.removeAll();
            }
            this.stackComponent = stackDockComponent;
            if (this.getDockableCount() < 2) {
                stackDockComponent.addChangeListener(this.visibleListener);
            } else {
                this.panel.removeAll();
                for (DockableDisplayer dockableDisplayer : this.dockables) {
                    int n2 = stackDockComponent.getTabCount();
                    Dockable dockable = dockableDisplayer.getDockable();
                    stackDockComponent.insertTab(dockable.getTitleText(), dockable.getTitleIcon(), dockableDisplayer.getComponent(), dockable, n2);
                    stackDockComponent.setTooltipAt(n2, dockable.getTitleToolTip());
                }
                this.panel.add(stackDockComponent.getComponent());
                if (n >= 0 && n < stackDockComponent.getTabCount()) {
                    stackDockComponent.setSelectedIndex(n);
                }
                stackDockComponent.addChangeListener(this.visibleListener);
            }
            object = stackDockComponent.getComponent();
            stackDockComponent.setController(this.getController());
            for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                ((Component)object).addMouseListener(mouseInputListener);
                ((Component)object).addMouseMotionListener(mouseInputListener);
            }
            this.updateConfigurableDisplayerHints();
        }
    }

    public StackDockComponent getStackComponent() {
        return this.stackComponent;
    }

    public void setStackComponentFactory(StackDockComponentFactory stackDockComponentFactory) {
        this.stackComponentFactory.setValue(stackDockComponentFactory);
    }

    public StackDockComponentFactory getStackComponentFactory() {
        return this.stackComponentFactory.getOwnValue();
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new StackDockStationFactory());
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        DockStation dockStation2 = this.getDockParent();
        if (dockStation2 != null) {
            dockStation2.removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
        this.visibility.fire();
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            DockTitle dockTitle;
            for (DockableDisplayer dockableDisplayer : this.dockables) {
                dockTitle = dockableDisplayer.getTitle();
                if (dockTitle == null) continue;
                dockableDisplayer.getDockable().unbind(dockTitle);
                dockableDisplayer.setTitle(null);
            }
            this.stackComponentFactory.setProperties(dockController);
            super.setController(dockController);
            this.stackComponent.setController(dockController);
            this.title = dockController != null ? dockController.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE) : null;
            this.displayers.setController(dockController);
            for (DockableDisplayer dockableDisplayer : this.dockables) {
                if (this.title == null) continue;
                dockTitle = dockableDisplayer.getDockable().getDockTitle(this.title);
                dockableDisplayer.setTitle(dockTitle);
                if (dockTitle == null) continue;
                dockableDisplayer.getDockable().bind(dockTitle);
            }
        }
    }

    public StationPaintWrapper getPaint() {
        return this.paint;
    }

    public DisplayerFactoryWrapper getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    @Override
    public boolean isStationVisible() {
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isVisible(this);
        }
        return this.panel.isDisplayable();
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (this.dockables.size() == 1 || this.indexOf(dockable) == this.stackComponent.getSelectedIndex());
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.dockables.get(n).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable) {
        return new StackDockProperty(this.indexOf(dockable));
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.dockables.size() == 0) {
            return null;
        }
        if (this.dockables.size() == 1) {
            return this.dockables.get(0).getDockable();
        }
        int n = this.stackComponent.getSelectedIndex();
        if (n >= 0) {
            return this.dockables.get(n).getDockable();
        }
        return null;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable dockable2 = this.getFrontDockable();
        if (this.dockables.size() > 1 && dockable != null) {
            this.stackComponent.setSelectedIndex(this.indexOf(dockable));
        }
        if (dockable2 != dockable) {
            this.listeners.fireDockableSelected(dockable2, dockable);
        }
    }

    public int indexOf(Dockable dockable) {
        int n = this.dockables.size();
        for (int i = 0; i < n; ++i) {
            if (this.dockables.get(i).getDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean prepareDrop(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        DockStation dockStation = this.getDockParent();
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.panel);
        if (dockStation != null && bl && dockStation.isInOverrideZone(n, n2, this, dockable)) {
            DockTitle dockTitle;
            if (this.dockables.size() > 1) {
                if (this.setInsert(this.exactTabIndexAt(point.x, point.y), dockable)) {
                    return true;
                }
            } else if (this.dockables.size() == 1 && (dockTitle = this.dockables.get(0).getTitle()) != null) {
                Component component = dockTitle.getComponent();
                Point point2 = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point2, component);
                if (component.getBounds().contains(point2)) {
                    return this.setInsert(new Insert(0, true), dockable);
                }
            }
            return false;
        }
        return this.setInsert(this.tabIndexAt(point.x, point.y), dockable);
    }

    @Override
    public void drop() {
        this.listeners.fireDockableAdding(this.dropping);
        this.add(this.dropping, this.insert.tab + (this.insert.right ? 1 : 0), false);
        this.listeners.fireDockableAdded(this.dropping);
    }

    @Override
    public void drop(Dockable dockable) {
        this.listeners.fireDockableAdding(dockable);
        this.add(dockable, this.dockables.size(), false);
        this.listeners.fireDockableAdded(dockable);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof StackDockProperty) {
            return this.drop(dockable, (StackDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, StackDockProperty stackDockProperty) {
        DockStation dockStation;
        DockUtilities.ensureTreeValidity(this, dockable);
        int n = stackDockProperty.getIndex();
        if (this.dockables.size() == 0) {
            if (this.accept(dockable) && dockable.accept(this)) {
                this.drop(dockable);
                return true;
            }
            return false;
        }
        n = Math.min(n, this.dockables.size());
        DockableProperty dockableProperty = stackDockProperty.getSuccessor();
        if (n < this.dockables.size() && dockableProperty != null && (dockStation = this.dockables.get(n).getDockable().asDockStation()) != null && dockStation.drop(dockable, dockableProperty)) {
            return true;
        }
        if (this.accept(dockable) && dockable.accept(this)) {
            this.add(dockable, n);
            return true;
        }
        return false;
    }

    @Override
    public boolean prepareMove(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        DockStation dockStation = this.getDockParent();
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.panel);
        if (dockStation != null && bl && dockStation.isInOverrideZone(n, n2, this, dockable)) {
            return this.dockables.size() > 1 && this.setInsert(this.exactTabIndexAt(point.x, point.y), dockable);
        }
        return this.setInsert(this.tabIndexAt(point.x, point.y), dockable);
    }

    private boolean setInsert(Insert insert, Dockable dockable) {
        if (insert != null && this.accept(dockable) && dockable.accept(this) && this.getController().getAcceptance().accept(this, dockable)) {
            this.insert = insert;
            this.dropping = dockable;
        } else {
            this.insert = null;
            this.dropping = null;
        }
        return this.insert != null;
    }

    @Override
    public void move() {
        int n = this.indexOf(this.dropping);
        if (n >= 0) {
            int n2 = this.insert.tab + (this.insert.right ? 1 : 0);
            if (n < n2) {
                --n2;
            }
            this.remove(n, false);
            this.add(this.dropping, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof StackDockProperty) {
            int n = this.indexOf(dockable);
            if (n < 0) {
                throw new IllegalArgumentException("dockable not child of this station");
            }
            int n2 = ((StackDockProperty)dockableProperty).getIndex();
            if ((n2 = Math.min(n2, this.getDockableCount())) != n) {
                DockController dockController = this.getController();
                if (dockController == null) {
                    this.remove(n, false);
                    if (n2 > n) {
                        --n2;
                    }
                    this.add(dockable, n2);
                } else {
                    try {
                        dockController.getRegister().setStalled(true);
                        this.remove(n, false);
                        if (n2 > n) {
                            --n2;
                        }
                        this.add(dockable, n2);
                    }
                    finally {
                        dockController.getRegister().setStalled(false);
                    }
                }
            }
        }
    }

    protected Insert tabIndexAt(int n, int n2) {
        if (this.dockables.size() == 0) {
            return new Insert(0, false);
        }
        if (this.dockables.size() == 1) {
            return new Insert(1, false);
        }
        Insert insert = this.exactTabIndexAt(n, n2);
        if (insert == null) {
            insert = new Insert(this.dockables.size() - 1, true);
        }
        return insert;
    }

    protected Insert exactTabIndexAt(int n, int n2) {
        Point point = SwingUtilities.convertPoint(this.panel, n, n2, this.stackComponent.getComponent());
        int n3 = this.dockables.size();
        for (int i = 0; i < n3; ++i) {
            Rectangle rectangle = this.stackComponent.getBoundsAt(i);
            if (rectangle == null || !rectangle.contains(point)) continue;
            return new Insert(i, rectangle.x + rectangle.width / 2 < point.x);
        }
        return null;
    }

    @Override
    public void draw() {
        this.draw = true;
        this.panel.repaint();
    }

    @Override
    public void forget() {
        this.draw = false;
        this.insert = null;
        this.dropping = null;
        this.panel.repaint();
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int n, int n2, D d, Dockable dockable) {
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isInOverrideZone(n, n2, d, dockable);
        }
        return false;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("The dockable is not part of this station.");
        }
        this.listeners.fireDockableRemoving(dockable);
        this.remove(n, false);
        this.listeners.fireDockableRemoved(dockable);
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        DockController dockController = this.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            int n = this.indexOf(dockable);
            this.remove(n);
            this.add(dockable2, n);
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public void add(Dockable dockable, int n) {
        this.add(dockable, n, true);
    }

    protected void add(Dockable dockable, int n, boolean bl) {
        DockUtilities.ensureTreeValidity(this, dockable);
        if (bl) {
            this.listeners.fireDockableAdding(dockable);
        }
        dockable.setDockParent(this);
        DockTitle dockTitle = null;
        if (this.title != null && (dockTitle = dockable.getDockTitle(this.title)) != null) {
            dockable.bind(dockTitle);
        }
        DockableDisplayer dockableDisplayer = this.getDisplayers().fetch(dockable, dockTitle);
        if (this.dockables.size() == 0) {
            this.dockables.add(dockableDisplayer);
            this.panel.add(dockableDisplayer.getComponent());
        } else {
            if (this.dockables.size() == 1) {
                this.panel.removeAll();
                DockableDisplayer dockableDisplayer2 = this.dockables.get(0);
                this.stackComponent.addTab(dockableDisplayer2.getDockable().getTitleText(), dockableDisplayer2.getDockable().getTitleIcon(), dockableDisplayer2.getComponent(), dockableDisplayer2.getDockable());
                this.stackComponent.setTooltipAt(0, dockableDisplayer2.getDockable().getTitleToolTip());
                this.panel.add(this.stackComponent.getComponent());
            }
            this.dockables.add(n, dockableDisplayer);
            this.stackComponent.insertTab(dockable.getTitleText(), dockable.getTitleIcon(), dockableDisplayer.getComponent(), dockable, n);
            this.stackComponent.setTooltipAt(n, dockable.getTitleToolTip());
            this.stackComponent.setSelectedIndex(n);
        }
        dockable.addDockableListener(this.listener);
        this.panel.validate();
        this.panel.repaint();
        if (bl) {
            this.listeners.fireDockableAdded(dockable);
        }
    }

    public void remove(int n) {
        this.remove(n, true);
    }

    private void remove(int n, boolean bl) {
        Dockable dockable;
        if (n < 0 || n >= this.dockables.size()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        Dockable dockable2 = this.getFrontDockable();
        DockableDisplayer dockableDisplayer = this.dockables.get(n);
        Dockable dockable3 = dockableDisplayer.getDockable();
        DockTitle dockTitle = dockableDisplayer.getTitle();
        if (bl) {
            this.listeners.fireDockableRemoving(dockable3);
        }
        this.getDisplayers().release(dockableDisplayer);
        if (dockTitle != null) {
            dockable3.unbind(dockTitle);
            dockableDisplayer.setTitle(null);
        }
        if (this.dockables.size() == 1) {
            this.panel.remove(this.dockables.get(0).getComponent());
            this.dockables.clear();
        } else if (this.dockables.size() == 2) {
            this.panel.remove(this.stackComponent.getComponent());
            this.stackComponent.removeAll();
            this.dockables.remove(n);
            this.panel.add(this.dockables.get(0).getComponent());
        } else {
            this.stackComponent.remove(n);
            this.dockables.remove(n);
        }
        dockable3.removeDockableListener(this.listener);
        this.panel.validate();
        this.panel.repaint();
        dockable3.setDockParent(null);
        if (bl) {
            this.listeners.fireDockableRemoved(dockable3);
        }
        if (dockable2 != (dockable = this.getFrontDockable())) {
            this.listeners.fireDockableSelected(dockable2, dockable);
        }
    }

    @Override
    public Component getComponent() {
        return this.background;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        super.configureDisplayerHints(dockableDisplayerHints);
        this.updateConfigurableDisplayerHints();
    }

    protected void updateConfigurableDisplayerHints() {
        DockableDisplayerHints dockableDisplayerHints = this.getConfigurableDisplayerHints();
        if (dockableDisplayerHints != null) {
            dockableDisplayerHints.setShowBorderHint(!this.getStackComponent().hasBorder());
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.panel.addMouseListener(mouseInputListener);
        this.panel.addMouseMotionListener(mouseInputListener);
        this.mouseInputListeners.add(mouseInputListener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().addMouseListener(mouseInputListener);
            this.stackComponent.getComponent().addMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.panel.removeMouseListener(mouseInputListener);
        this.panel.removeMouseMotionListener(mouseInputListener);
        this.mouseInputListeners.remove(mouseInputListener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().removeMouseListener(mouseInputListener);
            this.stackComponent.getComponent().removeMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public String getFactoryID() {
        return "StackDockStationFactory";
    }

    protected void insertionLine(Rectangle rectangle, Rectangle rectangle2, Point point, Point point2, boolean bl) {
        if (rectangle != null && rectangle2 != null) {
            int n;
            int n2 = Math.max(rectangle.y, rectangle2.y);
            int n3 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
            if (n3 > n2 && (double)(n = n3 - n2) >= 0.8 * (double)rectangle.height && (double)n >= 0.8 * (double)rectangle2.height) {
                point.x = (rectangle.x + rectangle.width + rectangle2.x) / 2;
                point.y = n2;
                point2.x = point.x;
                point2.y = n3;
                return;
            }
        }
        if (bl) {
            point.x = rectangle.x + rectangle.width;
            point.y = rectangle.y;
            point2.x = point.x;
            point2.y = point.y + rectangle.height;
        } else {
            point.x = rectangle2.x;
            point.y = rectangle2.y;
            point2.x = point.x;
            point2.y = point.y + rectangle2.height;
        }
    }

    private static class Insert {
        public int tab;
        public boolean right;

        public Insert(int n, boolean bl) {
            this.tab = n;
            this.right = bl;
        }
    }

    protected class Background
    extends OverpaintablePanel {
        public Background() {
            this.getContentPane().setLayout(new GridLayout(1, 1));
        }

        protected void paintOverlay(Graphics graphics) {
            Serializable serializable;
            Cloneable cloneable;
            Rectangle rectangle;
            StationPaintWrapper stationPaintWrapper = StackDockStation.this.getPaint();
            if (StackDockStation.this.draw && StackDockStation.this.dockables.size() > 1 && StackDockStation.this.insert != null) {
                rectangle = null;
                if (((StackDockStation)StackDockStation.this).insert.tab >= 0 && ((StackDockStation)StackDockStation.this).insert.tab < StackDockStation.this.stackComponent.getTabCount()) {
                    rectangle = StackDockStation.this.stackComponent.getBoundsAt(((StackDockStation)StackDockStation.this).insert.tab);
                }
                if (rectangle != null) {
                    cloneable = new Point();
                    serializable = new Point();
                    if (((StackDockStation)StackDockStation.this).insert.right) {
                        StackDockStation.this.insertionLine(rectangle, ((StackDockStation)StackDockStation.this).insert.tab + 1 < StackDockStation.this.stackComponent.getTabCount() ? StackDockStation.this.stackComponent.getBoundsAt(((StackDockStation)StackDockStation.this).insert.tab + 1) : null, (Point)cloneable, (Point)serializable, true);
                    } else {
                        StackDockStation.this.insertionLine(((StackDockStation)StackDockStation.this).insert.tab > 0 ? StackDockStation.this.stackComponent.getBoundsAt(((StackDockStation)StackDockStation.this).insert.tab - 1) : null, rectangle, (Point)cloneable, (Point)serializable, false);
                    }
                    stationPaintWrapper.drawInsertionLine(graphics, StackDockStation.this, ((Point)cloneable).x, ((Point)cloneable).y, ((Point)serializable).x, ((Point)serializable).y);
                }
            }
            if (StackDockStation.this.draw) {
                rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                if (StackDockStation.this.getDockableCount() < 2) {
                    cloneable = rectangle;
                } else {
                    serializable = ((DockableDisplayer)StackDockStation.this.dockables.get(StackDockStation.this.stackComponent.getSelectedIndex())).getComponent();
                    Point point = new Point(0, 0);
                    point = SwingUtilities.convertPoint((Component)serializable, point, this);
                    cloneable = new Rectangle(point.x, point.y, ((Component)serializable).getWidth(), ((Component)serializable).getHeight());
                }
                stationPaintWrapper.drawInsertion(graphics, StackDockStation.this, rectangle, (Rectangle)cloneable);
            }
        }
    }

    private class Listener
    implements DockableListener {
        private Listener() {
        }

        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleTextChanged(Dockable dockable, String string, String string2) {
            if (StackDockStation.this.dockables.size() > 1) {
                int n = StackDockStation.this.indexOf(dockable);
                StackDockStation.this.stackComponent.setTitleAt(n, string2);
            }
        }

        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            if (StackDockStation.this.dockables.size() > 1) {
                int n = StackDockStation.this.indexOf(dockable);
                StackDockStation.this.stackComponent.setTooltipAt(n, string2);
            }
        }

        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            if (StackDockStation.this.dockables.size() > 1) {
                int n = StackDockStation.this.indexOf(dockable);
                StackDockStation.this.stackComponent.setIconAt(n, icon2);
            }
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            DockableDisplayer dockableDisplayer;
            int n = StackDockStation.this.indexOf(dockable);
            if (n >= 0 && (dockableDisplayer = (DockableDisplayer)StackDockStation.this.dockables.get(n)).getTitle() == dockTitle) {
                DockUtilities.exchangeTitle(dockableDisplayer, StackDockStation.this.title);
            }
        }
    }

    private class VisibleListener
    extends DockStationAdapter
    implements ChangeListener {
        private VisibleListener() {
        }

        public void dockableVisibiltySet(DockStation dockStation, Dockable dockable, boolean bl) {
            StackDockStation.this.visibility.fire();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Dockable dockable;
            DockController dockController = StackDockStation.this.getController();
            if (dockController != null && (dockable = StackDockStation.this.getFrontDockable()) != null) {
                dockController.setFocusedDockable(dockable, false);
            }
            StackDockStation.this.visibility.fire();
        }
    }
}

