/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.AbstractDockStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.DefaultScreenDockWindowFactory;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationFactory;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowFactory;
import bibliothek.gui.dock.station.support.CombinerWrapper;
import bibliothek.gui.dock.station.support.DisplayerFactoryWrapper;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenDockStation
extends AbstractDockStation {
    public static final String TITLE_ID = "screen dock";
    public static final PropertyKey<BoundaryRestriction> BOUNDARY_RESTRICTION = new PropertyKey<BoundaryRestriction>("ScreenDockStation.boundary_restriction", new ConstantPropertyFactory<BoundaryRestriction>(BoundaryRestriction.FREE), true);
    public static final PropertyKey<ScreenDockWindowFactory> WINDOW_FACTORY = new PropertyKey<DefaultScreenDockWindowFactory>("ScreenDockStation.window_factory", new ConstantPropertyFactory<DefaultScreenDockWindowFactory>(new DefaultScreenDockWindowFactory()), true);
    private boolean showing = false;
    private List<ScreenDockWindow> dockables = new ArrayList<ScreenDockWindow>();
    private DockTitleVersion version;
    private CombinerWrapper combiner = new CombinerWrapper();
    private DropInfo dropInfo;
    private WindowProvider owner;
    private StationPaintWrapper stationPaint = new StationPaintWrapper();
    private DisplayerFactoryWrapper displayerFactory = new DisplayerFactoryWrapper();
    private DisplayerCollection displayers;
    private ScreenDockWindow frontWindow;
    private DockableVisibilityManager visibility;
    private PropertyValue<BoundaryRestriction> restriction = new PropertyValue<BoundaryRestriction>(BOUNDARY_RESTRICTION){

        @Override
        protected void valueChanged(BoundaryRestriction boundaryRestriction, BoundaryRestriction boundaryRestriction2) {
            ScreenDockStation.this.checkWindowBoundaries();
        }
    };
    private PropertyValue<ScreenDockWindowFactory> windowFactory = new PropertyValue<ScreenDockWindowFactory>(WINDOW_FACTORY){

        @Override
        protected void valueChanged(ScreenDockWindowFactory screenDockWindowFactory, ScreenDockWindowFactory screenDockWindowFactory2) {
        }
    };

    public ScreenDockStation(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.init(new DirectWindowProvider(window));
    }

    public ScreenDockStation(WindowProvider windowProvider) {
        if (windowProvider == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.init(windowProvider);
    }

    private void init(WindowProvider windowProvider) {
        this.visibility = new DockableVisibilityManager(this.listeners);
        this.owner = windowProvider;
        this.displayers = new DisplayerCollection(this, this.displayerFactory);
    }

    public DisplayerFactoryWrapper getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public CombinerWrapper getCombiner() {
        return this.combiner;
    }

    public StationPaintWrapper getPaint() {
        return this.stationPaint;
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new ScreenDockStationFactory(this.owner));
    }

    @Override
    public void setController(DockController dockController) {
        this.version = null;
        super.setController(dockController);
        this.displayers.setController(dockController);
        if (dockController != null) {
            this.version = dockController.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE);
        }
        this.restriction.setProperties(dockController);
        this.windowFactory.setProperties(dockController);
        for (ScreenDockWindow screenDockWindow : this.dockables) {
            screenDockWindow.setController(dockController);
        }
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public DefaultDockActionSource getIndirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.dockables.get(n).getDockable();
    }

    public int indexOf(Dockable dockable) {
        int n = this.dockables.size();
        for (int i = 0; i < n; ++i) {
            ScreenDockWindow screenDockWindow = this.dockables.get(i);
            if (screenDockWindow.getDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.frontWindow == null) {
            return null;
        }
        return this.frontWindow.getDockable();
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable dockable2;
        Dockable dockable3 = this.getFrontDockable();
        this.frontWindow = this.getWindow(dockable);
        if (this.frontWindow != null) {
            this.frontWindow.toFront();
        }
        if (dockable3 != (dockable2 = this.getFrontDockable())) {
            this.listeners.fireDockableSelected(dockable3, dockable2);
        }
    }

    @Override
    public boolean prepareDrop(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        return this.prepare(n, n2, n3, n4, dockable, true);
    }

    public boolean prepare(int n, int n2, int n3, int n4, Dockable dockable, boolean bl) {
        if (this.dropInfo == null) {
            this.dropInfo = new DropInfo();
        }
        ScreenDockWindow screenDockWindow = this.dropInfo.combine;
        this.dropInfo.x = n;
        this.dropInfo.y = n2;
        this.dropInfo.titleX = n3;
        this.dropInfo.titleY = n4;
        this.dropInfo.dockable = dockable;
        this.dropInfo.combine = this.searchCombineDockable(n, n2, dockable);
        if (this.dropInfo.combine != null && this.dropInfo.combine.getDockable() == dockable) {
            this.dropInfo.combine = null;
        }
        if (this.dropInfo.combine != screenDockWindow) {
            if (screenDockWindow != null) {
                screenDockWindow.setPaintCombining(false);
            }
            if (this.dropInfo.combine != null) {
                this.dropInfo.combine.setPaintCombining(true);
            }
        }
        this.checkDropInfo();
        return this.dropInfo != null;
    }

    private void checkDropInfo() {
        if (this.dropInfo != null) {
            if (this.dropInfo.combine != null) {
                if (!(this.accept(this.dropInfo.dockable) && this.dropInfo.dockable.accept(this, this.dropInfo.combine.getDockable()) && this.dropInfo.combine.getDockable().accept(this, this.dropInfo.dockable) && this.getController().getAcceptance().accept(this, this.dropInfo.combine.getDockable(), this.dropInfo.dockable))) {
                    this.dropInfo = null;
                }
            } else if (!(this.accept(this.dropInfo.dockable) && this.dropInfo.dockable.accept(this) && this.getController().getAcceptance().accept(this, this.dropInfo.dockable))) {
                this.dropInfo = null;
            }
        }
    }

    protected ScreenDockWindow searchCombineDockable(int n, int n2, Dockable dockable) {
        MultiDockAcceptance multiDockAcceptance = this.getController() == null ? null : this.getController().getAcceptance();
        for (ScreenDockWindow screenDockWindow : this.dockables) {
            if (!screenDockWindow.inCombineArea(n, n2)) continue;
            Dockable dockable2 = screenDockWindow.getDockable();
            if (multiDockAcceptance != null && !multiDockAcceptance.accept(this, dockable2, dockable) || !dockable.accept(this, dockable2) || !dockable2.accept(this, dockable)) continue;
            return screenDockWindow;
        }
        return null;
    }

    @Override
    public void drop() {
        if (this.dropInfo.combine != null) {
            this.combine(this.dropInfo.combine.getDockable(), this.dropInfo.dockable);
        } else {
            Component component = this.dropInfo.dockable.getComponent();
            Rectangle rectangle = new Rectangle(this.dropInfo.titleX, this.dropInfo.titleY, component.getWidth(), component.getHeight());
            this.addDockable(this.dropInfo.dockable, rectangle, false);
        }
    }

    @Override
    public void drop(Dockable dockable) {
        Window window = this.getOwner();
        int n = 30;
        int n2 = 30;
        if (window != null) {
            n += window.getX();
            n2 += window.getY();
        }
        Dimension dimension = dockable.getComponent().getPreferredSize();
        Rectangle rectangle = new Rectangle(n, n2, Math.max(dimension.width, 100), Math.max(dimension.height, 100));
        this.addDockable(dockable, rectangle);
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable) {
        ScreenDockWindow screenDockWindow = this.getWindow(dockable);
        Rectangle rectangle = screenDockWindow.getWindowBounds();
        return new ScreenDockProperty(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public ScreenDockWindow getWindow(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n < 0) {
            return null;
        }
        return this.dockables.get(n);
    }

    public ScreenDockWindow getWindow(int n) {
        return this.dockables.get(n);
    }

    @Override
    public boolean prepareMove(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        return this.prepare(n, n2, n3, n4, dockable, false);
    }

    @Override
    public void move() {
        if (this.dropInfo.combine != null) {
            this.combine(this.dropInfo.combine.getDockable(), this.dropInfo.dockable);
        } else {
            ScreenDockWindow screenDockWindow = this.getWindow(this.dropInfo.dockable);
            Point point = screenDockWindow.getOffsetMove();
            if (point == null) {
                point = new Point(0, 0);
            }
            Rectangle rectangle = screenDockWindow.getWindowBounds();
            rectangle = new Rectangle(this.dropInfo.titleX - point.x, this.dropInfo.titleY - point.y, rectangle.width, rectangle.height);
            screenDockWindow.setWindowBounds(rectangle);
        }
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof ScreenDockProperty) {
            ScreenDockWindow screenDockWindow = this.getWindow(dockable);
            if (screenDockWindow == null) {
                throw new IllegalArgumentException("dockable not child of this station");
            }
            ScreenDockProperty screenDockProperty = (ScreenDockProperty)dockableProperty;
            screenDockWindow.setWindowBounds(new Rectangle(screenDockProperty.getX(), screenDockProperty.getY(), screenDockProperty.getWidth(), screenDockProperty.getHeight()));
        }
    }

    @Override
    public void draw() {
        if (this.dropInfo == null) {
            this.dropInfo = new DropInfo();
        }
        this.dropInfo.draw = true;
        if (this.dropInfo.combine != null) {
            this.dropInfo.combine.setPaintCombining(true);
        }
    }

    @Override
    public void forget() {
        if (this.dropInfo != null) {
            this.dropInfo.draw = false;
            if (this.dropInfo.combine != null) {
                this.dropInfo.combine.setPaintCombining(false);
            }
            this.dropInfo = null;
        }
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int n, int n2, D d, Dockable dockable) {
        return this.searchCombineDockable(n, n2, dockable) != null;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        this.removeDockable(dockable);
    }

    public void addDockable(Dockable dockable, Rectangle rectangle) {
        this.addDockable(dockable, rectangle, true);
    }

    public void addDockable(Dockable dockable, Rectangle rectangle, boolean bl) {
        Cloneable cloneable;
        DockUtilities.ensureTreeValidity(this, dockable);
        if (rectangle == null) {
            throw new IllegalArgumentException("Bounds must not be null");
        }
        this.listeners.fireDockableAdding(dockable);
        ScreenDockWindow screenDockWindow = this.createWindow();
        this.register(screenDockWindow);
        screenDockWindow.setDockable(dockable);
        rectangle = new Rectangle(rectangle);
        if (!bl) {
            screenDockWindow.validate();
            cloneable = screenDockWindow.getDockableInsets();
            if (cloneable != null) {
                rectangle.x -= cloneable.left;
                rectangle.y -= cloneable.top;
                rectangle.width += cloneable.left + cloneable.right;
                rectangle.height += cloneable.top + cloneable.bottom;
            }
        }
        screenDockWindow.setWindowBounds(rectangle);
        screenDockWindow.validate();
        if (!bl) {
            screenDockWindow.validate();
            cloneable = screenDockWindow.getOffsetDrop();
            if (cloneable != null) {
                Rectangle rectangle2 = screenDockWindow.getWindowBounds();
                rectangle2 = new Rectangle(rectangle2.x + ((Point)cloneable).x, rectangle2.y + ((Point)cloneable).y, rectangle2.width, rectangle2.height);
                screenDockWindow.setWindowBounds(rectangle2);
            }
        }
        if (this.isShowing()) {
            screenDockWindow.setVisible(true);
        }
        dockable.setDockParent(this);
        this.listeners.fireDockableAdded(dockable);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof ScreenDockProperty) {
            return this.drop(dockable, (ScreenDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, ScreenDockProperty screenDockProperty) {
        return this.drop(dockable, screenDockProperty, true);
    }

    public boolean drop(Dockable dockable, ScreenDockProperty screenDockProperty, boolean bl) {
        Object object;
        DockUtilities.ensureTreeValidity(this, dockable);
        ScreenDockWindow object2 = null;
        double d = 0.0;
        int n = screenDockProperty.getX();
        int n2 = screenDockProperty.getY();
        int n3 = screenDockProperty.getWidth();
        int n4 = screenDockProperty.getHeight();
        double d2 = n3 * n4;
        for (ScreenDockWindow object3 : this.dockables) {
            double d3;
            double d4;
            double d5;
            object = object3.getWindowBounds();
            double dockable2 = ((Rectangle)object).width * ((Rectangle)object).height;
            object = SwingUtilities.computeIntersection(n, n2, n3, n4, (Rectangle)object);
            if (((Rectangle)object).width == 0 || ((Rectangle)object).height == 0 || !((d5 = (d4 = (double)(((Rectangle)object).width * ((Rectangle)object).height)) / (d3 = Math.max(d2, dockable2))) > d)) continue;
            d = d3;
            object2 = object3;
        }
        boolean bl2 = false;
        if (d > 0.75) {
            Dockable dockable2;
            DockStation dockStation;
            DockableProperty bl3 = screenDockProperty.getSuccessor();
            object = object2.getDockable();
            if (bl3 != null && (dockStation = object.asDockStation()) != null) {
                bl2 = dockStation.drop(dockable, bl3);
            }
            if (!bl2 && (dockable2 = object2.getDockable()).accept(this, dockable) && dockable.accept(this, dockable2)) {
                this.combine(dockable2, dockable);
                bl2 = true;
            }
        }
        if (!bl2) {
            boolean bl3;
            boolean bl4 = bl3 = this.accept(dockable) && dockable.accept(this);
            if (bl3) {
                this.addDockable(dockable, new Rectangle(n, n2, n3, n4), bl);
                bl2 = true;
            }
        }
        return bl2;
    }

    public void combine(Dockable dockable, Dockable dockable2) {
        ScreenDockWindow screenDockWindow = this.getWindow(dockable);
        if (screenDockWindow == null) {
            throw new IllegalArgumentException("lower is not child of this station");
        }
        this.removeDockable(dockable2);
        this.listeners.fireDockableRemoving(dockable);
        screenDockWindow.setDockable(null);
        dockable.setDockParent(null);
        this.listeners.fireDockableRemoved(dockable);
        Dockable dockable3 = this.combiner.combine(dockable, dockable2, this);
        this.listeners.fireDockableAdding(dockable3);
        dockable3.setDockParent(this);
        screenDockWindow.setDockable(dockable3);
        this.listeners.fireDockableAdded(dockable3);
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        ScreenDockWindow screenDockWindow = this.getWindow(dockable);
        this.listeners.fireDockableRemoving(dockable);
        screenDockWindow.setDockable(null);
        dockable.setDockParent(null);
        this.listeners.fireDockableRemoved(dockable);
        this.listeners.fireDockableAdding(dockable2);
        dockable2.setDockParent(this);
        screenDockWindow.setDockable(dockable2);
        this.listeners.fireDockableAdded(dockable2);
    }

    public void removeDockable(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n >= 0) {
            this.removeDockable(n);
        }
    }

    public void removeDockable(int n) {
        ScreenDockWindow screenDockWindow = this.dockables.get(n);
        Dockable dockable = screenDockWindow.getDockable();
        this.listeners.fireDockableRemoving(dockable);
        this.dockables.remove(n);
        screenDockWindow.setVisible(false);
        screenDockWindow.setDockable(null);
        this.deregister(screenDockWindow);
        dockable.setDockParent(null);
        this.listeners.fireDockableRemoved(dockable);
    }

    protected void register(ScreenDockWindow screenDockWindow) {
        this.dockables.add(screenDockWindow);
        screenDockWindow.setController(this.getController());
    }

    protected void deregister(ScreenDockWindow screenDockWindow) {
        if (this.frontWindow == screenDockWindow) {
            this.frontWindow = null;
        }
        this.dockables.remove(screenDockWindow);
        screenDockWindow.setController(null);
        screenDockWindow.destroy();
    }

    protected ScreenDockWindow createWindow() {
        return this.getWindowFactory().createWindow(this);
    }

    public Window getOwner() {
        return this.owner.searchWindow();
    }

    public WindowProvider getProvider() {
        return this.owner;
    }

    public ScreenDockWindowFactory getWindowFactory() {
        return this.windowFactory.getValue();
    }

    protected PropertyValue<ScreenDockWindowFactory> getWindowFactoryProperty() {
        return this.windowFactory;
    }

    public void setWindowFactory(ScreenDockWindowFactory screenDockWindowFactory) {
        this.windowFactory.setValue(screenDockWindowFactory);
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean bl) {
        if (this.showing != bl) {
            this.showing = bl;
            for (ScreenDockWindow screenDockWindow : this.dockables) {
                screenDockWindow.setVisible(bl);
            }
            this.visibility.fire();
        }
    }

    @Override
    public Rectangle getStationBounds() {
        return null;
    }

    @Override
    public Dockable asDockable() {
        return null;
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return TITLE_ID;
    }

    @Override
    public boolean canCompare(DockStation dockStation) {
        return true;
    }

    @Override
    public int compare(DockStation dockStation) {
        return -1;
    }

    public DockTitleVersion getTitleVersion() {
        return this.version;
    }

    public DockTitle createDockTitle(Dockable dockable) {
        if (this.version == null) {
            return null;
        }
        return dockable.getDockTitle(this.version);
    }

    public BoundaryRestriction getBoundaryRestriction() {
        return this.restriction.getValue();
    }

    public void setBoundaryRestriction(BoundaryRestriction boundaryRestriction) {
        this.restriction.setValue(boundaryRestriction);
    }

    public void checkWindowBoundaries() {
        for (ScreenDockWindow screenDockWindow : this.dockables) {
            screenDockWindow.checkWindowBounds();
        }
    }

    private static class DropInfo {
        public Dockable dockable;
        public int x;
        public int y;
        public int titleX;
        public int titleY;
        public ScreenDockWindow combine;
        public boolean draw;

        private DropInfo() {
        }
    }
}

