/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.control.MouseFocusObserver;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.FlapDockListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.DefaultFlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapDockHoldToggle;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.support.CombinerWrapper;
import bibliothek.gui.dock.station.support.DisplayerFactoryWrapper;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import bibliothek.gui.dock.themes.basic.BasicButtonTitleFactory;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlapDockStation
extends AbstractDockableStation {
    public static final String WINDOW_TITLE_ID = "flap window";
    public static final String BUTTON_TITLE_ID = "flap button";
    public static final PropertyKey<FlapLayoutManager> LAYOUT_MANAGER = new PropertyKey<FlapLayoutManager>("flap dock station layout manager", new DynamicPropertyFactory<FlapLayoutManager>(){

        @Override
        public FlapLayoutManager getDefault(PropertyKey<FlapLayoutManager> propertyKey, DockProperties dockProperties) {
            return new DefaultFlapLayoutManager();
        }
    }, true);
    public static final PropertyKey<ButtonContent> BUTTON_CONTENT = new PropertyKey<ButtonContent>("flap dock station button content", new ConstantPropertyFactory<ButtonContent>(ButtonContent.THEME_DEPENDENT), true);
    private PropertyValue<FlapLayoutManager> layoutManager = new PropertyValue<FlapLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(FlapLayoutManager flapLayoutManager, FlapLayoutManager flapLayoutManager2) {
            if (flapLayoutManager != null) {
                flapLayoutManager.uninstall(FlapDockStation.this);
            }
            if (flapLayoutManager2 != null) {
                flapLayoutManager2.install(FlapDockStation.this);
            }
        }
    };
    private PropertyValue<ButtonContent> buttonContent = new PropertyValue<ButtonContent>(BUTTON_CONTENT){

        @Override
        protected void valueChanged(ButtonContent buttonContent, ButtonContent buttonContent2) {
            if (buttonContent != buttonContent2) {
                FlapDockStation.this.recreateTitles();
            }
        }
    };
    private Direction direction = Direction.SOUTH;
    private boolean autoDirection = true;
    private FlapWindow window;
    private int windowBorder = 3;
    private int windowMinSize = 25;
    private int defaultWindowSize = 400;
    private Dockable oldFrontDockable;
    private List<Dockable> dockables = new ArrayList<Dockable>();
    private Listener dockableListener = new Listener();
    private Map<Dockable, DockTitle> buttonTitles = new HashMap<Dockable, DockTitle>();
    private Map<DockTitle, ButtonListener> buttonListeners = new HashMap<DockTitle, ButtonListener>();
    private ButtonPane buttonPane;
    private DockTitleVersion buttonVersion;
    private DockTitleVersion titleVersion;
    private StationPaintWrapper paint = new StationPaintWrapper();
    private CombinerWrapper combiner = new CombinerWrapper();
    private DisplayerFactoryWrapper displayerFactory = new DisplayerFactoryWrapper();
    private DisplayerCollection displayers;
    private FlapDropInfo dropInfo;
    private ControllerListener controllerListener = new ControllerListener();
    private boolean smallButtons = true;
    private ListeningDockAction holdAction;
    private VisibleListener visibleListener = new VisibleListener();
    private List<FlapDockListener> flapDockListeners = new ArrayList<FlapDockListener>();
    private DockableVisibilityManager visibility;

    public FlapDockStation() {
        this.init();
    }

    protected FlapDockStation(boolean bl) {
        if (bl) {
            this.init();
        }
    }

    protected void init() {
        this.visibility = new DockableVisibilityManager(this.listeners);
        this.buttonPane = this.createButtonPane(this.buttonTitles);
        this.setDirection(Direction.SOUTH);
        this.displayers = new DisplayerCollection(this, this.displayerFactory);
        this.buttonPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.buttonPane.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.holdAction = this.createHoldAction();
    }

    protected ButtonPane createButtonPane(Map<Dockable, DockTitle> map) {
        return new ButtonPane(this, map);
    }

    protected ListeningDockAction createHoldAction() {
        return new FlapDockHoldToggle(this);
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        if (this.getDockParent() != null) {
            this.getDockParent().removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            Object object;
            boolean bl;
            boolean bl2 = bl = this.getController() != null;
            if (bl) {
                this.getController().removeDockableFocusListener(this.controllerListener);
                this.getController().getFocusObserver().removeVetoListener(this.controllerListener);
                this.oldFrontDockable = this.getFrontDockable();
                this.setFrontDockable(null);
                for (Dockable object22 : this.dockables) {
                    object = this.buttonTitles.get(object22);
                    if (object == null) continue;
                    this.unbind(object22, (DockTitle)object);
                }
                this.titleVersion = null;
                this.buttonVersion = null;
            }
            super.setController(dockController);
            this.displayers.setController(dockController);
            FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
            this.layoutManager.setProperties(dockController);
            FlapLayoutManager flapLayoutManager2 = this.layoutManager.getValue();
            if (flapLayoutManager == flapLayoutManager2) {
                if (dockController == null) {
                    if (flapLayoutManager != null) {
                        flapLayoutManager.uninstall(this);
                    }
                } else if (flapLayoutManager2 != null) {
                    flapLayoutManager2.install(this);
                }
            }
            this.buttonContent.setProperties(dockController);
            if (this.holdAction != null) {
                this.holdAction.setController(dockController);
            }
            if (dockController != null) {
                DockElementRepresentative dockElementRepresentative;
                this.titleVersion = dockController.getDockTitleManager().getVersion(WINDOW_TITLE_ID, ControllerTitleFactory.INSTANCE);
                this.buttonVersion = dockController.getDockTitleManager().getVersion(BUTTON_TITLE_ID, BasicButtonTitleFactory.FACTORY);
                object = this.dockables.iterator();
                while (object.hasNext()) {
                    dockElementRepresentative = (Dockable)object.next();
                    DockTitle dockTitle = dockElementRepresentative.getDockTitle(this.buttonVersion);
                    if (dockTitle == null) continue;
                    this.bind((Dockable)dockElementRepresentative, dockTitle);
                }
                if (this.window != null && (object = this.window.getDockable()) != null) {
                    dockElementRepresentative = object.getDockTitle(this.titleVersion);
                    if (dockElementRepresentative != null) {
                        object.bind((DockTitle)dockElementRepresentative);
                    }
                    this.window.setDockTitle((DockTitle)dockElementRepresentative);
                }
                dockController.addDockableFocusListener(this.controllerListener);
                dockController.getFocusObserver().addVetoListener(this.controllerListener);
                if (this.isStationVisible()) {
                    this.setFrontDockable(this.oldFrontDockable);
                }
            }
            this.buttonPane.resetTitles();
        }
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new FlapDockStationFactory());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new IllegalArgumentException();
        }
        this.direction = direction;
        DockTitle.Orientation orientation = this.orientation(direction);
        for (DockTitle dockTitle : this.buttonTitles.values()) {
            dockTitle.setOrientation(orientation);
        }
        this.buttonPane.resetTitles();
        this.updateWindowBounds();
        this.buttonPane.revalidate();
    }

    protected DockTitle.Orientation orientation(Direction direction) {
        switch (direction) {
            case NORTH: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case SOUTH: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case EAST: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case WEST: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    protected void updateWindowBounds() {
        if (this.window != null) {
            this.window.updateBounds();
        }
    }

    public DisplayerFactoryWrapper getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public CombinerWrapper getCombiner() {
        return this.combiner;
    }

    public StationPaintWrapper getPaint() {
        return this.paint;
    }

    public Rectangle getExpansionBounds() {
        Component component = this.getComponent();
        return new Rectangle(0, 0, component.getWidth(), component.getHeight());
    }

    public boolean isAutoDirection() {
        return this.autoDirection;
    }

    public void setAutoDirection(boolean bl) {
        this.autoDirection = bl;
        if (bl) {
            this.selfSetDirection();
        }
    }

    public void selfSetDirection() {
        Component component = this.getComponent();
        Point point = new Point(component.getWidth() / 2, component.getHeight() / 2);
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Direction direction = component.getWidth() > component.getHeight() ? (point.y < dimension.height / 2 ? Direction.SOUTH : Direction.NORTH) : (point.x < dimension.width / 2 ? Direction.EAST : Direction.WEST);
        if (direction != this.direction) {
            this.setDirection(direction);
        } else {
            this.updateWindowBounds();
        }
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.window == null) {
            return null;
        }
        return this.window.getDockable();
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        DockTitle[] dockTitleArray;
        Dockable dockable2 = this.getFrontDockable();
        if (dockable2 == dockable) {
            return;
        }
        if (dockable == null) {
            if (this.window != null) {
                this.window.setDockable(null);
            }
        } else {
            dockTitleArray = SwingUtilities.getWindowAncestor(this.getComponent());
            if (this.window == null || this.window.getOwner() != dockTitleArray) {
                FlapWindow flapWindow;
                if (this.window != null) {
                    this.window.setDockable(null);
                }
                if ((flapWindow = this.createFlapWindow((Window)dockTitleArray, this.buttonPane)) != null) {
                    this.setFlapWindow(flapWindow);
                }
            }
            if (this.window != null && dockTitleArray != null) {
                this.window.setDockable(dockable);
                if (dockTitleArray.isVisible()) {
                    this.window.setVisible(true);
                }
                this.updateWindowBounds();
            }
        }
        if (dockable2 != null && this.getController() != null) {
            dockTitleArray = dockable2.listBoundTitles();
            boolean bl = this.getController().isFocused(dockable2);
            for (DockTitle dockTitle : dockTitleArray) {
                this.changed(dockable2, dockTitle, bl);
            }
        }
        if (this.window != null) {
            if (this.window.getDockable() == null) {
                this.window.setVisible(false);
            } else {
                this.window.repaint();
            }
        }
        this.visibility.fire();
        this.listeners.fireDockableSelected(dockable2, dockable);
    }

    protected FlapWindow createFlapWindow(Window window, ButtonPane buttonPane) {
        if (window instanceof Dialog) {
            return new FlapWindow(this, buttonPane, (Dialog)window);
        }
        if (window instanceof Frame) {
            return new FlapWindow(this, buttonPane, (Frame)window);
        }
        return null;
    }

    public boolean isHold(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager == null) {
            return false;
        }
        return flapLayoutManager.isHold(this, dockable);
    }

    public void setHold(Dockable dockable, boolean bl) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            boolean bl2 = flapLayoutManager.isHold(this, dockable);
            flapLayoutManager.setHold(this, dockable, bl);
            bl = flapLayoutManager.isHold(this, dockable);
            if (bl2 != bl) {
                this.updateHold(dockable);
            }
        }
    }

    public void updateHold(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            boolean bl = flapLayoutManager.isHold(this, dockable);
            this.fireHoldChanged(dockable, bl);
            if (!bl && this.getController() != null && this.getFrontDockable() == dockable && !this.getController().isFocused(dockable)) {
                this.setFrontDockable(null);
            }
        }
    }

    public boolean isSmallButtons() {
        return this.smallButtons;
    }

    public void setSmallButtons(boolean bl) {
        this.smallButtons = bl;
    }

    public DockTitleVersion getTitleVersion() {
        return this.titleVersion;
    }

    public DockTitleVersion getButtonVersion() {
        return this.buttonVersion;
    }

    public int getWindowBorder() {
        return this.windowBorder;
    }

    public void setWindowBorder(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Border must not be less than 0");
        }
        this.windowBorder = n;
        this.updateWindowBounds();
    }

    public int getWindowMinSize() {
        return this.windowMinSize;
    }

    public void setWindowMinSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Min size must not be smaller than 0");
        }
        this.windowMinSize = n;
        this.updateWindowBounds();
    }

    public int getWindowSize(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager == null) {
            return 0;
        }
        return flapLayoutManager.getSize(this, dockable);
    }

    public void setWindowSize(Dockable dockable, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Size must at least be 0");
        }
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            flapLayoutManager.setSize(this, dockable, n);
            this.updateWindowSize(dockable);
        }
    }

    public void updateWindowSize(Dockable dockable) {
        if (this.getFrontDockable() == dockable) {
            this.updateWindowBounds();
        }
    }

    public void setDefaultWindowSize(int n) {
        this.defaultWindowSize = n;
    }

    public int getDefaultWindowSize() {
        return this.defaultWindowSize;
    }

    public void setFlapLayoutManager(FlapLayoutManager flapLayoutManager) {
        this.layoutManager.setValue(flapLayoutManager);
    }

    public FlapLayoutManager getFlapLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public void addFlapDockStationListener(FlapDockListener flapDockListener) {
        this.flapDockListeners.add(flapDockListener);
    }

    public void removeFlapDockStationListener(FlapDockListener flapDockListener) {
        this.flapDockListeners.remove(flapDockListener);
    }

    protected void fireHoldChanged(Dockable dockable, boolean bl) {
        for (FlapDockListener flapDockListener : this.flapDockListeners.toArray(new FlapDockListener[this.flapDockListeners.size()])) {
            flapDockListener.holdChanged(this, dockable, bl);
        }
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.holdAction == null) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.LITTLE_LEFT), new DockAction[0]);
        defaultDockActionSource.add(this.holdAction);
        return defaultDockActionSource;
    }

    @Override
    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        DockTitleEvent dockTitleEvent = new DockTitleEvent(this, dockable, bl);
        dockTitleEvent.setPreferred(dockable == this.getFrontDockable());
        dockTitle.changed(dockTitleEvent);
    }

    @Override
    public Rectangle getStationBounds() {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getComponent().getWidth(), this.getComponent().getHeight());
        if (this.window != null && this.window.isVisible()) {
            rectangle = SwingUtilities.computeUnion(this.window.getX(), this.window.getY(), this.window.getWidth(), this.window.getHeight(), rectangle);
        }
        return rectangle;
    }

    private void setDropInfo(FlapDropInfo flapDropInfo) {
        this.dropInfo = flapDropInfo;
        if (this.window != null) {
            this.window.setDropInfo(flapDropInfo);
        }
        if (this.buttonPane != null) {
            this.buttonPane.setDropInfo(flapDropInfo);
        }
    }

    private void setFlapWindow(FlapWindow flapWindow) {
        if (this.window != null) {
            this.window.dispose();
        }
        this.window = flapWindow;
        if (flapWindow != null) {
            flapWindow.setDropInfo(this.dropInfo);
        }
    }

    public boolean isFlapWindow(FlapWindow flapWindow) {
        return this.window == flapWindow;
    }

    @Override
    public boolean prepareDrop(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        Object object;
        Object object2;
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.buttonPane);
        boolean bl2 = this.buttonPane.titleContains(point.x, point.y);
        boolean bl3 = false;
        MultiDockAcceptance multiDockAcceptance = this.getController().getAcceptance();
        if (!bl2 && this.window != null && this.window.isVisible() && (object2 = this.window.getDockTitle()) != null) {
            object = object2.getComponent();
            Point point2 = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point2, (Component)object);
            Dockable dockable2 = this.window.getDockable();
            boolean bl4 = bl3 = ((Component)object).contains(point2) && dockable.accept(this, dockable2) && dockable2.accept(this, dockable) && multiDockAcceptance.accept(this, dockable2, dockable);
        }
        if (!bl2 && !bl3 && (object2 = this.getDockParent()) != null && bl && object2.isInOverrideZone(n, n2, this, dockable)) {
            return false;
        }
        if (this.window != null && this.window.isVisible() && !bl3) {
            object2 = new Point(n, n2);
            SwingUtilities.convertPointFromScreen((Point)object2, this.window);
            object = this.window.getDockable();
            boolean bl5 = bl3 = this.window.contains((Point)object2) && dockable.accept(this, (Dockable)object) && object.accept(this, dockable) && multiDockAcceptance.accept(this, (Dockable)object, dockable);
        }
        if (bl3 && dockable == this.getFrontDockable()) {
            return false;
        }
        object2 = null;
        if (bl3) {
            object2 = new FlapDropInfo(dockable);
            ((FlapDropInfo)object2).setCombine(this.getFrontDockable());
        } else if (dockable.accept(this) && this.accept(dockable) && multiDockAcceptance.accept(this, dockable)) {
            object2 = new FlapDropInfo(dockable);
            ((FlapDropInfo)object2).setIndex(this.buttonPane.indexAt(point.x, point.y));
        }
        this.setDropInfo((FlapDropInfo)object2);
        return object2 != null;
    }

    @Override
    public void drop() {
        if (this.dropInfo.getCombine() != null) {
            this.combine(this.dropInfo.getCombine(), this.dropInfo.getDockable());
        } else {
            this.add(this.dropInfo.getDockable(), this.dropInfo.getIndex());
        }
    }

    @Override
    public void drop(Dockable dockable) {
        this.add(dockable);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            return this.drop(dockable, (FlapDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, FlapDockProperty flapDockProperty) {
        DockStation dockStation;
        DockUtilities.ensureTreeValidity(this, dockable);
        int n = flapDockProperty.getIndex();
        if (n >= this.getDockableCount() && this.accept(dockable) && dockable.accept(this)) {
            this.add(dockable);
            this.setHold(dockable, flapDockProperty.isHolding());
            int n2 = flapDockProperty.getSize();
            if (n2 >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, n2);
            }
            return true;
        }
        DockableProperty dockableProperty = flapDockProperty.getSuccessor();
        if (dockableProperty != null && (dockStation = this.getDockable(n).asDockStation()) != null && dockStation.drop(dockable, dockableProperty)) {
            return true;
        }
        if (dockable.accept(this) && this.accept(dockable)) {
            this.add(dockable, n);
            this.setHold(dockable, flapDockProperty.isHolding());
            int n3 = flapDockProperty.getSize();
            if (n3 >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, n3);
            }
            return true;
        }
        return false;
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable) {
        int n = this.indexOf(dockable);
        boolean bl = this.isHold(dockable);
        int n2 = this.getWindowSize(dockable);
        return new FlapDockProperty(n, bl, n2);
    }

    @Override
    public boolean prepareMove(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        return this.prepareDrop(n, n2, n3, n4, bl, dockable);
    }

    @Override
    public void move() {
        if (this.dropInfo.getCombine() != null) {
            this.remove(this.dropInfo.getDockable());
            this.combine(this.dropInfo.getCombine(), this.dropInfo.getDockable());
        } else {
            int n = this.indexOf(this.dropInfo.getDockable());
            this.dockables.remove(n);
            if (n < this.dropInfo.getIndex()) {
                this.dropInfo.setIndex(this.dropInfo.getIndex() - 1);
            }
            this.dockables.add(this.dropInfo.getIndex(), this.dropInfo.getDockable());
            this.buttonPane.resetTitles();
        }
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            int n = this.indexOf(dockable);
            if (n < 0) {
                throw new IllegalArgumentException("dockable is not child of this station");
            }
            int n2 = ((FlapDockProperty)dockableProperty).getIndex();
            if ((n2 = Math.min(n2, this.dockables.size())) != n) {
                this.dockables.remove(n);
                this.dockables.add(n2, dockable);
                this.buttonPane.resetTitles();
            }
        }
    }

    @Override
    public void draw() {
        if (this.dropInfo != null) {
            this.dropInfo.setDraw(true);
        }
        this.buttonPane.repaint();
        if (this.window != null) {
            this.window.repaint();
        }
    }

    @Override
    public void forget() {
        this.setDropInfo(null);
        this.buttonPane.repaint();
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int n, int n2, D d, Dockable dockable) {
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.buttonPane);
        if (this.buttonPane.contains(point) && this.accept(dockable) && dockable.accept(this)) {
            return true;
        }
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isInOverrideZone(n, n2, d, dockable);
        }
        return false;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        this.remove(dockable);
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public Component getComponent() {
        return this.buttonPane;
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.dockables.get(n);
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && this.getFrontDockable() == dockable;
    }

    protected void recreateTitles() {
        HashMap<Dockable, DockTitle> hashMap = new HashMap<Dockable, DockTitle>(this.buttonTitles);
        for (Map.Entry object : hashMap.entrySet()) {
            if (object.getValue() == null) continue;
            this.unbind((Dockable)object.getKey(), (DockTitle)object.getValue());
        }
        if (this.buttonVersion != null) {
            for (Dockable dockable : this.dockables) {
                DockTitle dockTitle = dockable.getDockTitle(this.buttonVersion);
                if (dockTitle == null) continue;
                this.bind(dockable, dockTitle);
            }
        }
        this.buttonPane.resetTitles();
    }

    public void remove(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        Dockable dockable = this.getDockable(n);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        if (this.oldFrontDockable == dockable) {
            this.oldFrontDockable = null;
        }
        this.listeners.fireDockableRemoving(dockable);
        dockable.setDockParent(null);
        this.dockables.remove(n);
        DockTitle dockTitle = this.buttonTitles.get(dockable);
        if (dockTitle != null) {
            this.unbind(dockable, dockTitle);
        }
        dockable.removeDockableListener(this.dockableListener);
        this.buttonPane.resetTitles();
        this.listeners.fireDockableRemoved(dockable);
    }

    public void add(Dockable dockable) {
        this.add(dockable, this.getDockableCount());
    }

    public void add(Dockable dockable, int n) {
        DockUtilities.ensureTreeValidity(this, dockable);
        this.listeners.fireDockableAdding(dockable);
        this.dockables.add(n, dockable);
        dockable.setDockParent(this);
        if (this.buttonVersion != null) {
            DockTitle dockTitle = dockable.getDockTitle(this.buttonVersion);
            if (dockTitle != null) {
                this.bind(dockable, dockTitle);
            }
            this.buttonPane.resetTitles();
        }
        dockable.addDockableListener(this.dockableListener);
        this.listeners.fireDockableAdded(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean combine(Dockable dockable, Dockable dockable2) {
        DockController dockController = this.getController();
        try {
            int n;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            if ((n = this.indexOf(dockable)) < 0) {
                throw new IllegalArgumentException("Child must be a child of this station");
            }
            if (dockable2.getDockParent() != null) {
                dockable2.getDockParent().drag(dockable2);
            }
            boolean bl = this.isHold(dockable);
            this.remove(n);
            int n2 = this.indexOf(dockable2);
            if (n2 >= 0) {
                this.remove(n2);
                if (n2 < n) {
                    --n;
                }
            }
            n = Math.min(n, this.getDockableCount());
            Dockable dockable3 = this.combiner.combine(dockable, dockable2, this);
            this.add(dockable3, n);
            this.setHold(dockable3, bl);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        DockController dockController = this.getController();
        try {
            int n;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            if ((n = this.indexOf(dockable)) < 0) {
                throw new IllegalArgumentException("Child must be a child of this station");
            }
            boolean bl = this.isHold(dockable);
            boolean bl2 = this.getFrontDockable() == dockable;
            this.remove(n);
            this.add(dockable2, n);
            this.setHold(dockable2, bl);
            if (bl2) {
                this.setFrontDockable(dockable2);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public int indexOf(Dockable dockable) {
        return this.dockables.indexOf(dockable);
    }

    protected void bind(Dockable dockable, DockTitle dockTitle) {
        this.buttonTitles.put(dockable, dockTitle);
        ButtonListener buttonListener = new ButtonListener(dockable);
        dockTitle.addMouseInputListener(buttonListener);
        this.buttonListeners.put(dockTitle, buttonListener);
        dockTitle.setOrientation(this.orientation(this.direction));
        dockable.bind(dockTitle);
    }

    protected void unbind(Dockable dockable, DockTitle dockTitle) {
        ButtonListener buttonListener = this.buttonListeners.remove(dockTitle);
        dockTitle.removeMouseInputListener(buttonListener);
        this.buttonTitles.remove(dockable);
        dockable.unbind(dockTitle);
    }

    private class ButtonListener
    extends MouseInputAdapter {
        private Dockable dockable;

        public ButtonListener(Dockable dockable) {
            this.dockable = dockable;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dockable.getDockParent() == FlapDockStation.this && mouseEvent.getButton() == 1 && (mouseEvent.getModifiersEx() & 0x1C00) == 0) {
                DockTitle dockTitle = (DockTitle)FlapDockStation.this.buttonTitles.get(this.dockable);
                if (FlapDockStation.this.getFrontDockable() == this.dockable && dockTitle.isActive()) {
                    FlapDockStation.this.getController().setFocusedDockable(FlapDockStation.this, true);
                    FlapDockStation.this.setFrontDockable(null);
                } else {
                    FlapDockStation.this.getController().setFocusedDockable(this.dockable, true);
                }
            }
        }
    }

    private class ControllerListener
    implements FocusVetoListener,
    DockableFocusListener {
        private ControllerListener() {
        }

        public boolean vetoFocus(MouseFocusObserver mouseFocusObserver, Dockable dockable) {
            return false;
        }

        public boolean vetoFocus(MouseFocusObserver mouseFocusObserver, DockTitle dockTitle) {
            return FlapDockStation.this.buttonTitles.containsValue(dockTitle);
        }

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            Dockable dockable = FlapDockStation.this.getFrontDockable();
            if (FlapDockStation.this.isStationVisible()) {
                if (dockable == null || dockable != null && FlapDockStation.this.isHold(dockable)) {
                    return;
                }
                DockController dockController = dockableFocusEvent.getController();
                Dockable dockable2 = dockableFocusEvent.getNewFocusOwner();
                if (dockController.isFocused(FlapDockStation.this)) {
                    return;
                }
                if (dockable2 == null || !DockUtilities.isAncestor(FlapDockStation.this, dockable2)) {
                    FlapDockStation.this.setFrontDockable(null);
                }
            }
        }
    }

    private class Listener
    extends DockableAdapter {
        private Listener() {
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            if (FlapDockStation.this.buttonTitles.get(dockable) == dockTitle) {
                boolean bl = true;
                if (dockTitle != null) {
                    FlapDockStation.this.unbind(dockable, dockTitle);
                    dockTitle = null;
                    bl = true;
                }
                if (FlapDockStation.this.buttonVersion != null && (dockTitle = dockable.getDockTitle(FlapDockStation.this.buttonVersion)) != null) {
                    FlapDockStation.this.bind(dockable, dockTitle);
                    bl = true;
                }
                if (bl) {
                    FlapDockStation.this.buttonTitles.put(dockable, dockTitle);
                    FlapDockStation.this.buttonPane.resetTitles();
                }
            }
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private boolean visible = false;

        private VisibleListener() {
        }

        public void dockableVisibiltySet(DockStation dockStation, Dockable dockable, boolean bl) {
            if (bl != this.visible && dockable == FlapDockStation.this) {
                this.visible = bl;
                if (bl) {
                    if (FlapDockStation.this.oldFrontDockable != null) {
                        FlapDockStation.this.setFrontDockable(FlapDockStation.this.oldFrontDockable);
                    }
                } else {
                    FlapDockStation.this.oldFrontDockable = FlapDockStation.this.getFrontDockable();
                    FlapDockStation.this.setFrontDockable(null);
                    if (!FlapDockStation.this.isHold(FlapDockStation.this.oldFrontDockable)) {
                        FlapDockStation.this.oldFrontDockable = null;
                    }
                }
                FlapDockStation.this.visibility.fire();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonContent {
        THEME_DEPENDENT,
        ICON_ONLY,
        TEXT_ONLY,
        ICON_AND_TEXT_ONLY,
        ICON_THEN_TEXT_ONLY,
        TEXT_THEN_ICON_ONLY,
        ICON_ACTIONS,
        TEXT_ACTIONS,
        ICON_AND_TEXT_ACTIONS,
        ICON_THEN_TEXT_ACTIONS,
        TEXT_THEN_ICON_ACTIONS;


        public boolean showActions(boolean bl) {
            switch (this) {
                case ICON_AND_TEXT_ONLY: 
                case ICON_ONLY: 
                case ICON_THEN_TEXT_ONLY: 
                case TEXT_ONLY: 
                case TEXT_THEN_ICON_ONLY: {
                    return false;
                }
                case ICON_ACTIONS: 
                case ICON_AND_TEXT_ACTIONS: 
                case ICON_THEN_TEXT_ACTIONS: 
                case TEXT_ACTIONS: 
                case TEXT_THEN_ICON_ACTIONS: {
                    return true;
                }
            }
            return bl;
        }

        public boolean showIcon(boolean bl, boolean bl2) {
            switch (this) {
                case ICON_AND_TEXT_ONLY: 
                case ICON_ONLY: 
                case ICON_THEN_TEXT_ONLY: 
                case ICON_ACTIONS: 
                case ICON_AND_TEXT_ACTIONS: 
                case ICON_THEN_TEXT_ACTIONS: {
                    return true;
                }
                case TEXT_ONLY: 
                case TEXT_ACTIONS: {
                    return false;
                }
                case TEXT_THEN_ICON_ONLY: 
                case TEXT_THEN_ICON_ACTIONS: {
                    return !bl;
                }
            }
            return bl2;
        }

        public boolean showText(boolean bl, boolean bl2) {
            switch (this) {
                case ICON_AND_TEXT_ONLY: 
                case TEXT_ONLY: 
                case TEXT_THEN_ICON_ONLY: 
                case ICON_AND_TEXT_ACTIONS: 
                case TEXT_ACTIONS: 
                case TEXT_THEN_ICON_ACTIONS: {
                    return true;
                }
                case ICON_ONLY: 
                case ICON_ACTIONS: {
                    return false;
                }
                case ICON_THEN_TEXT_ONLY: 
                case ICON_THEN_TEXT_ACTIONS: {
                    return !bl;
                }
            }
            return bl2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NORTH,
        WEST,
        SOUTH,
        EAST;

    }
}

