/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.extension.gui.dock.theme.SmoothTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.control.SingleParentRemover;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.gui.dock.themes.basic.BasicCombiner;
import bibliothek.gui.dock.themes.basic.BasicDisplayerFactory;
import bibliothek.gui.dock.themes.basic.BasicStationPaint;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.laf.DefaultLookAndFeelColors;
import bibliothek.gui.dock.util.laf.LookAndFeelColors;
import bibliothek.gui.dock.util.laf.LookAndFeelColorsListener;
import bibliothek.gui.dock.util.laf.Nimbus6u10;
import bibliothek.gui.dock.util.laf.Windows;
import bibliothek.gui.dock.util.local.LocaleListener;
import bibliothek.util.container.Tuple;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockUI {
    private static DockUI ui;
    private ResourceBundle bundle;
    private Locale locale = Locale.getDefault();
    private Map<String, Icon> icons;
    private List<ThemeFactory> themes = new ArrayList<ThemeFactory>();
    private List<Tuple<String, LookAndFeelColors>> lookAndFeelColors = new ArrayList<Tuple<String, LookAndFeelColors>>();
    private LookAndFeelColors lookAndFeelColor;
    private List<LookAndFeelColorsListener> colorsListeners = new ArrayList<LookAndFeelColorsListener>();
    private List<LocaleListener> localeListeners = new ArrayList<LocaleListener>();
    private LookAndFeelColorsListener colorsListener = new LookAndFeelColorsListener(){

        public void colorChanged(String string) {
            for (LookAndFeelColorsListener lookAndFeelColorsListener : DockUI.this.colorsListeners.toArray(new LookAndFeelColorsListener[DockUI.this.colorsListeners.size()])) {
                lookAndFeelColorsListener.colorChanged(string);
            }
        }

        public void colorsChanged() {
            for (LookAndFeelColorsListener lookAndFeelColorsListener : DockUI.this.colorsListeners.toArray(new LookAndFeelColorsListener[DockUI.this.colorsListeners.size()])) {
                lookAndFeelColorsListener.colorsChanged();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DockUI getDefaultDockUI() {
        if (ui != null) return ui;
        Class<DockUI> clazz = DockUI.class;
        synchronized (DockUI.class) {
            if (ui != null) return ui;
            ui = new DockUI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ui;
        }
    }

    protected DockUI() {
        this.icons = DockUtilities.loadIcons("data/icons.ini", null, DockUI.class.getClassLoader());
        this.icons.put("ButtonPanel.overflow.menu", new Icon(){

            public int getIconHeight() {
                return 7;
            }

            public int getIconWidth() {
                return 9;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics = graphics.create();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(component.getForeground());
                graphics.fillPolygon(new int[]{n + 1, n + 8, n + 4}, new int[]{n2 + 1, n2 + 1, n2 + 6}, 3);
                graphics.dispose();
            }
        });
        this.setBundle(Locale.getDefault());
        this.registerThemes();
        this.registerColors();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                    DockUI.this.updateUI();
                }
            }
        });
    }

    protected void updateUI() {
        this.updateLookAndFeelColors();
    }

    private void registerThemes() {
        this.registerTheme(BasicTheme.class, null);
        this.registerTheme(FlatTheme.class, null);
        this.registerTheme(SmoothTheme.class, null);
        this.registerTheme(BubbleTheme.class, null);
        this.registerTheme(EclipseTheme.class, null);
        this.registerTheme(NoStackTheme.getFactory(BasicTheme.class, null, this));
        this.registerTheme(NoStackTheme.getFactory(FlatTheme.class, null, this));
        this.registerTheme(NoStackTheme.getFactory(SmoothTheme.class, null, this));
        this.registerTheme(NoStackTheme.getFactory(BubbleTheme.class, null, this));
    }

    private void registerColors() {
        this.registerColors(".+", new DefaultLookAndFeelColors());
        this.registerColors("com\\.sun\\.java\\.swing\\.plaf\\.nimbus\\.NimbusLookAndFeel", new Nimbus6u10());
        this.registerColors("com\\.sun\\.java\\.swing\\.plaf\\.windows\\.WindowsLookAndFeel", new Windows());
    }

    public ThemeFactory getDefaultTheme() {
        return this.themes.get(0);
    }

    public ThemeFactory[] getThemes() {
        return this.themes.toArray(new ThemeFactory[this.themes.size()]);
    }

    public <T extends DockTheme> void registerTheme(Class<T> clazz, ResourceBundle resourceBundle) {
        this.registerTheme(new ThemePropertyFactory<T>(clazz, resourceBundle, this));
    }

    public void registerTheme(ThemeFactory themeFactory) {
        if (themeFactory == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        this.themes.add(themeFactory);
    }

    public void unregisterTheme(ThemeFactory themeFactory) {
        this.themes.remove(themeFactory);
    }

    public void registerColors(String string, LookAndFeelColors lookAndFeelColors) {
        if (string == null) {
            throw new IllegalArgumentException("lookAndFeelClassNameRegex must not be null");
        }
        if (lookAndFeelColors == null) {
            throw new IllegalArgumentException("colors must not be null");
        }
        this.lookAndFeelColors.add(new Tuple<String, LookAndFeelColors>(string, lookAndFeelColors));
        this.updateLookAndFeelColors();
    }

    public void addLookAndFeelColorsListener(LookAndFeelColorsListener lookAndFeelColorsListener) {
        if (lookAndFeelColorsListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.colorsListeners.add(lookAndFeelColorsListener);
    }

    public void removeLookAndFeelColorsListener(LookAndFeelColorsListener lookAndFeelColorsListener) {
        this.colorsListeners.remove(lookAndFeelColorsListener);
    }

    protected void updateLookAndFeelColors() {
        LookAndFeelColors lookAndFeelColors = this.selectBestMatchingColors();
        if (lookAndFeelColors != this.lookAndFeelColor) {
            if (this.lookAndFeelColor != null) {
                this.lookAndFeelColor.unbind();
                this.lookAndFeelColor.removeListener(this.colorsListener);
            }
            this.lookAndFeelColor = lookAndFeelColors;
            if (lookAndFeelColors != null) {
                lookAndFeelColors.bind();
                this.lookAndFeelColor.addListener(this.colorsListener);
            }
        }
    }

    protected LookAndFeelColors selectBestMatchingColors() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        for (int i = this.lookAndFeelColors.size() - 1; i >= 0; --i) {
            if (!string.matches((String)this.lookAndFeelColors.get(i).getA())) continue;
            return this.lookAndFeelColors.get(i).getB();
        }
        return null;
    }

    public LookAndFeelColors getColors() {
        return this.lookAndFeelColor;
    }

    public static Color getColor(String string) {
        return DockUI.getDefaultDockUI().getColors().getColor(string);
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public String getString(String string) {
        return this.getBundle().getString(string);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null");
        }
        this.setBundle(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addLocaleListener(LocaleListener localeListener) {
        this.localeListeners.add(localeListener);
    }

    public void removeLocaleListener(LocaleListener localeListener) {
        this.localeListeners.remove(localeListener);
    }

    private LocaleListener[] localeListeners() {
        return this.localeListeners.toArray(new LocaleListener[this.localeListeners.size()]);
    }

    public void setBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
        for (LocaleListener localeListener : this.localeListeners()) {
            localeListener.bundleChanged(this);
        }
    }

    @Deprecated
    public void setBundle(Locale locale) {
        this.locale = locale;
        this.setBundle(ResourceBundle.getBundle("data.locale.text", locale, this.getClass().getClassLoader()));
        for (LocaleListener localeListener : this.localeListeners()) {
            localeListener.localeChanged(this);
        }
    }

    public Icon getIcon(String string) {
        return this.icons.get(string);
    }

    public void setIcon(String string, Icon icon) {
        this.icons.put(string, icon);
    }

    public void fillIcons(IconManager iconManager) {
        for (Map.Entry<String, Icon> entry : this.icons.entrySet()) {
            iconManager.setIcon(entry.getKey(), Priority.DEFAULT, entry.getValue());
        }
    }

    public static StationPaint getPaint(StationPaint stationPaint, DockStation dockStation) {
        if (stationPaint != null) {
            return stationPaint;
        }
        DockTheme dockTheme = dockStation.getTheme();
        if (dockTheme == null) {
            return new BasicStationPaint();
        }
        return dockTheme.getPaint(dockStation);
    }

    public static DisplayerFactory getDisplayerFactory(DisplayerFactory displayerFactory, DockStation dockStation) {
        if (displayerFactory != null) {
            return displayerFactory;
        }
        DockTheme dockTheme = dockStation.getTheme();
        if (dockTheme == null) {
            return new BasicDisplayerFactory();
        }
        return dockTheme.getDisplayFactory(dockStation);
    }

    public static Combiner getCombiner(Combiner combiner, DockStation dockStation) {
        if (combiner != null) {
            return combiner;
        }
        DockTheme dockTheme = dockStation.getTheme();
        if (dockTheme == null) {
            return new BasicCombiner();
        }
        return dockTheme.getCombiner(dockStation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <D extends DockStation, L> void updateTheme(D d, DockFactory<D, L> dockFactory) throws IOException {
        Object object;
        HashMap<Integer, Dockable> hashMap = new HashMap<Integer, Dockable>();
        HashMap<Dockable, Integer> hashMap2 = new HashMap<Dockable, Integer>();
        int n = d.getDockableCount();
        for (int i = 0; i < n; ++i) {
            object = d.getDockable(i);
            hashMap.put(i, (Dockable)object);
            hashMap2.put((Dockable)object, i);
        }
        Object l = dockFactory.getLayout(d, hashMap2);
        DockController dockController = d.getController();
        object = null;
        if (dockController != null) {
            object = dockController.getSingleParentRemover();
            dockController.setSingleParentRemover(null);
        }
        try {
            for (int i = d.getDockableCount() - 1; i >= 0; --i) {
                d.drag(d.getDockable(i));
            }
            dockFactory.setLayout(d, l, hashMap);
        }
        finally {
            if (dockController != null && object != null) {
                dockController.setSingleParentRemover((SingleParentRemover)object);
            }
        }
    }
}

