/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockAction;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.dockable.DefaultDockableFactory;
import bibliothek.gui.dock.event.DockAdapter;
import bibliothek.gui.dock.event.DockFrontendListener;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.event.VetoableDockFrontendListener;
import bibliothek.gui.dock.frontend.FrontendEntry;
import bibliothek.gui.dock.frontend.MissingDockableStrategy;
import bibliothek.gui.dock.frontend.RegisteringDockFactory;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.frontend.VetoManager;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.security.SecureFlapDockStationFactory;
import bibliothek.gui.dock.security.SecureScreenDockStationFactory;
import bibliothek.gui.dock.security.SecureSplitDockStationFactory;
import bibliothek.gui.dock.security.SecureStackDockStationFactory;
import bibliothek.gui.dock.station.flap.FlapDockPropertyFactory;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.screen.ScreenDockPropertyFactory;
import bibliothek.gui.dock.station.screen.ScreenDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockPropertyFactory;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.NullWindowProvider;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockFrontend {
    public static final PropertyKey<KeyStroke> HIDE_ACCELERATOR = new PropertyKey("frontend hide accelerator");
    protected static final String DOCKABLE_KEY_PREFIX = "dockable";
    protected static final String ROOT_KEY_PREFIX = "root";
    private DockController controller;
    private Hider hider;
    private Map<String, DockInfo> dockables = new HashMap<String, DockInfo>();
    private Set<String> empty = new HashSet<String>();
    private DockStation defaultStation;
    private Map<String, RootInfo> roots = new HashMap<String, RootInfo>();
    private Set<DockFactory<? extends DockElement, ?>> dockFactories = new HashSet();
    private Set<DockFactory<? extends Dockable, ?>> backupDockFactories = new HashSet();
    private Set<AdjacentDockFactory<?>> adjacentDockFactories = new HashSet();
    private Set<DockablePropertyFactory> propertyFactories = new HashSet<DockablePropertyFactory>();
    private String currentSetting;
    private Map<String, Setting> settings = new HashMap<String, Setting>();
    private List<DockFrontendListener> listeners = new ArrayList<DockFrontendListener>();
    private VetoManager veto;
    private DockSituationIgnore ignoreForEntry;
    private DockSituationIgnore ignoreForFinal;
    private MissingDockableStrategy missingDockable = MissingDockableStrategy.DISCARD_ALL;
    private boolean showHideAction = true;
    private boolean defaultEntryLayout = true;
    private boolean defaultHideable = false;
    private int onAutoFire = 0;
    private Setting lastAppliedFullSetting = null;
    private Setting lastAppliedEntrySetting = null;

    public DockFrontend() {
        this(new DockController(), new NullWindowProvider());
    }

    public DockFrontend(Window window) {
        this(new DockController(), window == null ? new NullWindowProvider() : new DirectWindowProvider(window));
    }

    public DockFrontend(WindowProvider windowProvider) {
        this(new DockController(), windowProvider);
    }

    public DockFrontend(DockController dockController) {
        this(dockController, new NullWindowProvider());
    }

    public DockFrontend(DockController dockController, Window window) {
        this(dockController, window == null ? new NullWindowProvider() : new DirectWindowProvider(window));
    }

    public DockFrontend(DockController dockController, WindowProvider windowProvider) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
        dockController.setRootWindowProvider(windowProvider);
        this.veto = new VetoManager(this);
        this.hider = this.createHider();
        dockController.addActionGuard(this.hider);
        this.registerFactory(new DefaultDockableFactory());
        this.registerFactory(new SplitDockStationFactory());
        this.registerFactory(new SecureSplitDockStationFactory());
        this.registerFactory(new StackDockStationFactory());
        this.registerFactory(new SecureStackDockStationFactory());
        this.registerFactory(new FlapDockStationFactory());
        this.registerFactory(new SecureFlapDockStationFactory());
        this.registerFactory(new ScreenDockStationFactory(dockController.getRootWindowProvider()));
        this.registerFactory(new SecureScreenDockStationFactory(dockController.getRootWindowProvider()));
        this.registerFactory(new SplitDockPropertyFactory());
        this.registerFactory(new StackDockPropertyFactory());
        this.registerFactory(new FlapDockPropertyFactory());
        this.registerFactory(new ScreenDockPropertyFactory());
        dockController.getRegister().addDockRegisterListener(new DockAdapter(){

            public void dockableRegistered(DockController dockController, Dockable dockable) {
                if (DockFrontend.this.onAutoFire == 0) {
                    DockFrontend.this.fireShown(dockable);
                }
            }

            public void dockableUnregistered(DockController dockController, Dockable dockable) {
                if (DockFrontend.this.onAutoFire == 0) {
                    DockFrontend.this.fireHidden(dockable);
                }
            }
        });
    }

    public DockController getController() {
        return this.controller;
    }

    public void setOwner(WindowProvider windowProvider) {
        this.controller.setRootWindowProvider(windowProvider);
    }

    public WindowProvider getOwner() {
        return this.controller.getRootWindowProvider();
    }

    public void kill() {
        this.controller.kill();
    }

    @Deprecated
    public Collection<Dockable> getDockables() {
        return this.listDockables();
    }

    public void addFrontendListener(DockFrontendListener dockFrontendListener) {
        this.listeners.add(dockFrontendListener);
    }

    public void removeFrontendListener(DockFrontendListener dockFrontendListener) {
        this.listeners.remove(dockFrontendListener);
    }

    public void addVetoableListener(VetoableDockFrontendListener vetoableDockFrontendListener) {
        this.veto.addVetoableListener(vetoableDockFrontendListener);
    }

    public void removeVetoableListener(VetoableDockFrontendListener vetoableDockFrontendListener) {
        this.veto.removeVetoableListener(vetoableDockFrontendListener);
    }

    public void registerFactory(DockFactory<? extends DockElement, ?> dockFactory) {
        if (dockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.dockFactories.add(dockFactory);
        this.fillMissing(dockFactory);
    }

    public void registerFactory(DockFactory<? extends Dockable, ?> dockFactory, boolean bl) {
        if (dockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.dockFactories.add(dockFactory);
        if (bl) {
            this.backupDockFactories.add(dockFactory);
        }
        this.fillMissing(dockFactory);
    }

    public void registerBackupFactory(DockFactory<? extends Dockable, ?> dockFactory) {
        if (dockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.backupDockFactories.add(dockFactory);
        this.fillMissing(dockFactory);
    }

    public void registerAdjacentFactory(AdjacentDockFactory<?> adjacentDockFactory) {
        if (adjacentDockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.adjacentDockFactories.add(adjacentDockFactory);
    }

    public void unregisterFactory(DockFactory<? extends DockElement, ?> dockFactory) {
        this.dockFactories.remove(dockFactory);
    }

    public void unregisterBackupFactory(DockFactory<? extends DockElement, ?> dockFactory) {
        this.backupDockFactories.remove(dockFactory);
    }

    public void unregisterAdjacentFactory(AdjacentDockFactory<?> adjacentDockFactory) {
        this.adjacentDockFactories.remove(adjacentDockFactory);
    }

    public void registerFactory(DockablePropertyFactory dockablePropertyFactory) {
        if (dockablePropertyFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.propertyFactories.add(dockablePropertyFactory);
    }

    public void addDockable(String string, Dockable dockable) {
        this.add(dockable, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public void add(Dockable dockable, String string) {
        if (dockable == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        DockInfo dockInfo = this.dockables.get(string);
        if (dockInfo != null) {
            if (dockInfo.getDockable() != null) throw new IllegalArgumentException("There is already a dockable registered with name " + string);
            dockInfo.setDockable(dockable);
            dockInfo.updateHideAction();
        } else {
            dockInfo = new DockInfo(dockable, string);
            this.dockables.put(string, dockInfo);
        }
        DockLayoutComposition dockLayoutComposition = dockInfo.getLayout();
        if (dockLayoutComposition != null) {
            try {
                DockSituation dockSituation = this.createSituation(false);
                dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition);
                dockSituation.convert(dockLayoutComposition);
                dockInfo.setLayout(null);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot read old layout information", iOException);
            }
        }
        this.fireAdded(dockable);
    }

    public void setMissingDockableStrategy(MissingDockableStrategy missingDockableStrategy) {
        this.missingDockable = missingDockableStrategy == null ? MissingDockableStrategy.DISCARD_ALL : missingDockableStrategy;
    }

    public MissingDockableStrategy getMissingDockable() {
        return this.missingDockable;
    }

    public Map<String, Dockable> getNamedDockables() {
        HashMap<String, Dockable> hashMap = new HashMap<String, Dockable>();
        for (Map.Entry<String, DockInfo> entry : this.dockables.entrySet()) {
            if (entry.getValue().getDockable() == null) continue;
            hashMap.put(entry.getKey(), entry.getValue().getDockable());
        }
        return hashMap;
    }

    public Dockable getDockable(String string) {
        DockInfo dockInfo = this.getInfo(string);
        return dockInfo == null ? null : dockInfo.dockable;
    }

    public String getNameOf(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable is null");
        }
        for (Map.Entry<String, DockInfo> entry : this.dockables.entrySet()) {
            if (entry.getValue().dockable != dockable) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addRoot(String string, DockStation dockStation) {
        this.addRoot(dockStation, string);
    }

    @Deprecated
    public void addRoot(DockStation dockStation, String string) {
        if (dockStation == null) {
            throw new IllegalArgumentException("Stations must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (this.roots.containsKey(string)) {
            throw new IllegalArgumentException("There is already a station registered with name " + string);
        }
        this.controller.getRegister().add(dockStation);
        this.roots.put(string, new RootInfo(dockStation, string));
    }

    public DockStation getRoot(String string) {
        RootInfo rootInfo = this.roots.get(string);
        if (rootInfo == null) {
            return null;
        }
        return rootInfo.getStation();
    }

    public DockStation[] getRoots() {
        DockStation[] dockStationArray = new DockStation[this.roots.size()];
        int n = 0;
        for (RootInfo rootInfo : this.roots.values()) {
            dockStationArray[n++] = rootInfo.station;
        }
        return dockStationArray;
    }

    public void addRepresentative(DockElementRepresentative dockElementRepresentative) {
        this.controller.addRepresentative(dockElementRepresentative);
    }

    public void removeRepresentative(DockElementRepresentative dockElementRepresentative) {
        this.controller.removeRepresentative(dockElementRepresentative);
    }

    public void setDefaultStation(DockStation dockStation) {
        if (dockStation != null && this.getRoot(dockStation) == null) {
            throw new IllegalArgumentException("The default station must be registered as root");
        }
        this.defaultStation = dockStation;
    }

    public DockStation getDefaultStation() {
        if (this.defaultStation != null) {
            return this.defaultStation;
        }
        Iterator<RootInfo> iterator = this.roots.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getStation();
        }
        return null;
    }

    public void remove(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo != null) {
            boolean bl = dockInfo.isHideable();
            dockInfo.setHideable(false);
            if (this.empty.contains(dockInfo.getKey())) {
                this.fireRemoved(dockable);
                dockInfo.setDockable(null);
                dockInfo.setHideable(bl);
            } else {
                this.dockables.remove(dockInfo.getKey());
                this.fireRemoved(dockable);
            }
        }
    }

    public void addEmpty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.empty.add(string);
        if (!this.dockables.containsKey(string)) {
            this.dockables.put(string, new DockInfo(null, string));
        }
    }

    public void removeEmpty(String string) {
        this.empty.remove(string);
        DockInfo dockInfo = this.getInfo(string);
        if (dockInfo != null && dockInfo.getDockable() == null) {
            this.dockables.remove(string);
        }
    }

    public String[] listEmpty(boolean bl) {
        if (bl) {
            return this.empty.toArray(new String[this.empty.size()]);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.empty) {
            DockInfo dockInfo = this.getInfo(string);
            if (dockInfo.getDockable() != null) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void removeRoot(DockStation dockStation) {
        RootInfo rootInfo = this.getRoot(dockStation);
        if (rootInfo != null) {
            if (this.defaultStation == rootInfo.getStation()) {
                this.defaultStation = null;
            }
            this.roots.remove(rootInfo.getName());
            this.controller.getRegister().remove(dockStation);
        }
    }

    public boolean hasLocation(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            return false;
        }
        if (this.isShown(dockable)) {
            return true;
        }
        return dockInfo.root != null && dockInfo.location != null;
    }

    public void setIgnoreForEntry(DockSituationIgnore dockSituationIgnore) {
        this.ignoreForEntry = dockSituationIgnore;
    }

    public DockSituationIgnore getIgnoreForEntry() {
        return this.ignoreForEntry;
    }

    public void setIgnoreForFinal(DockSituationIgnore dockSituationIgnore) {
        this.ignoreForFinal = dockSituationIgnore;
    }

    public DockSituationIgnore getIgnoreForFinal() {
        return this.ignoreForFinal;
    }

    public DockProperties getDockProperties() {
        return this.controller.getProperties();
    }

    public Setting getLastAppliedFullSetting() {
        return this.lastAppliedFullSetting;
    }

    public Setting getLastAppliedEntrySetting() {
        return this.lastAppliedEntrySetting;
    }

    public Set<String> getSettings() {
        Set<String> set = this.settings.keySet();
        return Collections.unmodifiableSet(set);
    }

    public String getCurrentSetting() {
        return this.currentSetting;
    }

    public void setCurrentSetting(String string) {
        if (string == null) {
            throw new IllegalArgumentException("the name of a setting must not be null");
        }
        if (this.settings.containsKey(string)) {
            this.load(string);
        } else {
            this.save(string);
        }
    }

    public boolean isHidden(Dockable dockable) {
        return dockable.getController() == null;
    }

    public boolean isShown(Dockable dockable) {
        return dockable.getController() != null;
    }

    public void setDefaultHideable(boolean bl) {
        this.defaultHideable = bl;
    }

    public boolean isDefaultHideable() {
        return this.defaultHideable;
    }

    public boolean isHideable(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("Dockable not registered");
        }
        return dockInfo.isHideable();
    }

    public void setHideable(Dockable dockable, boolean bl) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("Dockable not registered");
        }
        if (dockInfo.isHideable() != bl) {
            dockInfo.setHideable(bl);
            this.fireHideable(dockable, bl);
        }
    }

    public void setShowHideAction(boolean bl) {
        if (this.showHideAction != bl) {
            this.showHideAction = bl;
            for (DockInfo dockInfo : this.dockables.values()) {
                dockInfo.updateHideAction();
            }
        }
    }

    public boolean isShowHideAction() {
        return this.showHideAction;
    }

    public void setDefaultEntryLayout(boolean bl) {
        this.defaultEntryLayout = bl;
    }

    public boolean isDefaultEntryLayout() {
        return this.defaultEntryLayout;
    }

    public void setEntryLayout(Dockable dockable, boolean bl) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        dockInfo.setEntryLayout(bl);
    }

    public void setEntryLayout(String string, boolean bl) {
        DockInfo dockInfo = this.getInfo(string);
        if (dockInfo == null) {
            throw new IllegalArgumentException("no entry present for: " + string);
        }
        dockInfo.setEntryLayout(bl);
    }

    public boolean isEntryLayout(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        return dockInfo.isEntryLayout();
    }

    public boolean isEntryLayout(String string) {
        DockInfo dockInfo = this.getInfo(string);
        if (dockInfo == null) {
            throw new IllegalArgumentException("no entry present for: " + string);
        }
        return dockInfo.isEntryLayout();
    }

    public void show(Dockable dockable) {
        this.show(dockable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Dockable dockable, boolean bl) {
        try {
            ++this.onAutoFire;
            if (this.isHidden(dockable) && this.veto.expectToShow(dockable, bl)) {
                DockInfo dockInfo = this.getInfo(dockable);
                if (dockInfo == null) {
                    DockStation dockStation = this.getDefaultStation();
                    if (dockStation == null) {
                        throw new IllegalStateException("Can't find the default station");
                    }
                    dockStation.drop(dockable);
                } else {
                    String string = dockInfo.getRoot();
                    DockableProperty dockableProperty = dockInfo.getLocation();
                    DockStation dockStation = string == null ? this.getDefaultStation() : this.getRoot(string);
                    if (dockStation == null && (dockStation = this.getDefaultStation()) == null) {
                        throw new IllegalStateException("Can't find the default station");
                    }
                    if (dockableProperty == null) {
                        this.getDefaultStation().drop(dockable);
                    } else if (!dockStation.drop(dockable, dockableProperty)) {
                        this.getDefaultStation().drop(dockable);
                    }
                }
                this.fireAllShown(dockable, null);
            }
        }
        finally {
            --this.onAutoFire;
        }
    }

    public void hide(Dockable dockable) {
        this.hide(dockable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(Dockable dockable, boolean bl) {
        try {
            ++this.onAutoFire;
            if (this.isShown(dockable) && (dockable.getDockParent() == null || this.veto.expectToHide(dockable, bl))) {
                DockInfo dockInfo = this.getInfo(dockable);
                if (dockInfo != null) {
                    dockInfo.updateLocation();
                }
                if (dockable.getDockParent() != null) {
                    dockable.getDockParent().drag(dockable);
                    this.fireAllHidden(dockable, null);
                }
            }
        }
        finally {
            --this.onAutoFire;
        }
    }

    public void save() {
        if (this.currentSetting == null) {
            throw new IllegalStateException("No setting loaded yet");
        }
        this.save(this.currentSetting);
    }

    public void save(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Setting setting = this.getSetting(true);
        this.settings.put(string, setting);
        this.currentSetting = string;
        this.fireSaved(string);
    }

    public void load(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Setting setting = this.settings.get(string);
        if (setting == null) {
            throw new IllegalArgumentException("Unknown setting \"" + string + "\"");
        }
        this.currentSetting = string;
        this.setSetting(setting, true);
        this.fireLoaded(string);
    }

    public Setting getSetting(boolean bl) {
        Object object;
        Setting setting = this.createSetting();
        DockSituation dockSituation = this.createSituation(bl);
        for (RootInfo object2 : this.roots.values()) {
            object = dockSituation.convert(object2.getStation());
            setting.putRoot(object2.getName(), (DockLayoutComposition)object);
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            object = dockInfo.getDockable();
            if (object != null && object.getController() != null) continue;
            DockLayoutComposition dockLayoutComposition = null;
            if (!bl || dockInfo.isEntryLayout()) {
                dockLayoutComposition = object != null ? dockSituation.convert((DockElement)object) : dockInfo.getLayout();
            }
            setting.addInvisible(dockInfo.getKey(), dockInfo.getRoot(), dockLayoutComposition, dockInfo.getLocation());
        }
        return setting;
    }

    /*
     * WARNING - void declaration
     */
    public void setSetting(Setting setting, boolean bl) {
        Set<Dockable> set = null;
        try {
            void var5_9;
            ++this.onAutoFire;
            this.controller.getRegister().setStalled(true);
            DockSituation dockSituation = this.createSituation(bl);
            DockSituationIgnore object = dockSituation.getIgnore();
            if (object == null) {
                DockSituationIgnore dockSituationIgnore = new DockSituationIgnore(){

                    public boolean ignoreChildren(DockStation dockStation) {
                        return false;
                    }

                    public boolean ignoreElement(DockElement dockElement) {
                        return false;
                    }
                };
            }
            if ((set = this.approveClosing(dockSituation, setting)) == null) {
                return;
            }
            if (bl) {
                this.lastAppliedEntrySetting = setting;
            } else {
                this.lastAppliedEntrySetting = null;
                this.lastAppliedFullSetting = setting;
            }
            this.clean((DockSituationIgnore)var5_9);
            this.applyLayout(dockSituation, setting, bl);
            this.applyInvisibleLayout(dockSituation, setting);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot set Setting", iOException);
        }
        catch (XException xException) {
            throw new IllegalArgumentException("Cannot set Setting", xException);
        }
        finally {
            --this.onAutoFire;
            this.controller.getRegister().setStalled(false);
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() == null || dockInfo.isHideable() || !this.isHidden(dockInfo.getDockable())) continue;
            this.show(dockInfo.getDockable());
        }
    }

    private Set<Dockable> approveClosing(DockSituation dockSituation, Setting setting) {
        HashSet<Dockable> hashSet = new HashSet<Dockable>();
        for (RootInfo object : this.roots.values()) {
            Set<Dockable> set;
            DockLayoutComposition dockLayoutComposition = setting.getRoot(object.getName());
            if (dockLayoutComposition == null || (set = this.estimateClosing(dockSituation, dockLayoutComposition)) == null) continue;
            hashSet.addAll(set);
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() == null || dockInfo.isHideable()) continue;
            hashSet.remove(dockInfo.getDockable());
        }
        if (!hashSet.isEmpty() && !this.veto.expectToHide(hashSet, true)) {
            return null;
        }
        return hashSet;
    }

    private void applyLayout(DockSituation dockSituation, Setting setting, boolean bl) throws IOException, XException {
        for (RootInfo rootInfo : this.roots.values()) {
            Object object;
            Object object2;
            DockLayoutComposition dockLayoutComposition = setting.getRoot(rootInfo.getName());
            if (dockLayoutComposition == null) continue;
            Map<String, DockableProperty> map = this.listEstimateLocations(dockSituation, dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition));
            if (map != null) {
                object2 = map.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry entry = (Map.Entry)object2.next();
                    String string = (String)entry.getKey();
                    object = this.getInfo(string);
                    if (object == null && this.missingDockable.shouldStoreShown(string)) {
                        this.addEmpty(string);
                        object = this.getInfo(string);
                    }
                    if (object == null) continue;
                    ((DockInfo)object).setLocation(rootInfo.getName(), (DockableProperty)entry.getValue());
                    ((DockInfo)object).setShown(true);
                }
            }
            if ((object2 = this.listLayouts(dockSituation, dockLayoutComposition)) != null) {
                for (Map.Entry entry : object2.entrySet()) {
                    object = (String)entry.getKey();
                    DockInfo dockInfo = this.getInfo((String)object);
                    if (dockInfo == null && this.missingDockable.shouldStoreShown((String)object)) {
                        this.addEmpty((String)object);
                        dockInfo = this.getInfo((String)object);
                    }
                    if (dockInfo == null) continue;
                    dockInfo.setShown(true);
                    if (bl && !dockInfo.isEntryLayout()) continue;
                    dockInfo.setLayout((DockLayoutComposition)entry.getValue());
                }
            }
            dockSituation.convert(dockLayoutComposition);
        }
    }

    private void applyInvisibleLayout(DockSituation dockSituation, Setting setting) throws IOException, XException {
        int n = setting.getInvisibleCount();
        for (int i = 0; i < n; ++i) {
            String string = setting.getInvisibleKey(i);
            DockInfo dockInfo = this.getInfo(string);
            if (dockInfo == null && this.missingDockable.shouldStoreHidden(string)) {
                this.addEmpty(string);
                dockInfo = this.getInfo(string);
            }
            if (dockInfo == null) continue;
            dockInfo.setShown(false);
            dockInfo.setLocation(setting.getInvisibleRoot(i), setting.getInvisibleLocation(i));
            DockLayoutComposition dockLayoutComposition = setting.getInvisibleLayout(i);
            if (dockLayoutComposition == null) continue;
            dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition);
            if (dockInfo.getDockable() != null) {
                dockSituation.convert(dockLayoutComposition);
                dockLayoutComposition = null;
            }
            dockInfo.setLayout(dockLayoutComposition);
        }
    }

    private void fillMissing() {
        DockSituation dockSituation = this.createSituation(false);
        for (Setting object2 : this.settings.values()) {
            object2.fillMissing(dockSituation);
        }
        if (this.lastAppliedFullSetting != null && !this.settings.containsValue(this.lastAppliedFullSetting)) {
            this.lastAppliedFullSetting.fillMissing(dockSituation);
        }
        if (this.lastAppliedEntrySetting != null && this.lastAppliedEntrySetting != this.lastAppliedFullSetting && !this.settings.containsValue(this.lastAppliedEntrySetting)) {
            this.lastAppliedEntrySetting.fillMissing(dockSituation);
        }
        List<FrontendEntry> list = this.listFrontendEntries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DockElement dockElement;
            Dockable dockable;
            FrontendEntry frontendEntry = (FrontendEntry)iterator.next();
            if (frontendEntry.getDockable() != null || frontendEntry.getLayout() == null || (dockable = (dockElement = dockSituation.convert(frontendEntry.getLayout())) == null ? null : dockElement.asDockable()) == null) continue;
            frontendEntry.setLayout(null);
            this.addDockable(frontendEntry.getKey(), dockable);
        }
    }

    private void fillMissing(DockFactory<?, ?> dockFactory) {
        this.fillMissing();
        Setting setting = this.getLastAppliedEntrySetting();
        boolean bl = true;
        if (setting == null) {
            setting = this.getLastAppliedFullSetting();
            bl = false;
        }
        if (setting == null) {
            return;
        }
        DockSituation dockSituation = this.createSituation(bl);
        String string = dockSituation.convertFactoryId(dockFactory);
        for (String string2 : this.roots.keySet()) {
            DockLayoutComposition dockLayoutComposition = setting.getRoot(string2);
            if (dockLayoutComposition == null) continue;
            this.estimateLocations(dockSituation, dockLayoutComposition);
            this.fillMissing(string2, dockLayoutComposition, dockFactory, string);
        }
    }

    private void fillMissing(String string, DockLayoutComposition dockLayoutComposition, DockFactory<?, ?> dockFactory, String string2) {
        RootInfo rootInfo;
        Dockable dockable;
        DockLayoutComposition dockLayoutComposition2;
        Object object;
        Object object2;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && dockLayoutInfo.getDataLayout().getFactoryID().equals(string2) && (object2 = dockLayoutInfo.getLocation()) != null && this.missingDockable.shouldCreate(object = dockFactory, dockLayoutInfo.getDataLayout().getData()) && (dockLayoutComposition2 = object.layout(dockLayoutInfo.getDataLayout().getData())) != null && (dockable = dockLayoutComposition2.asDockable()) != null && !(rootInfo = this.roots.get(string)).getStation().drop(dockable, (DockableProperty)object2)) {
            rootInfo.getStation().drop(dockable);
        }
        if ((object2 = dockLayoutComposition.getChildren()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                dockLayoutComposition2 = object.next();
                this.fillMissing(string, dockLayoutComposition2, dockFactory, string2);
            }
        }
    }

    protected Map<String, DockableProperty> listEstimateLocations(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            Map<String, DockableProperty> map = ((PredefinedDockSituation)dockSituation).listEstimatedLocations(dockLayoutComposition, true);
            HashMap<String, DockableProperty> hashMap = new HashMap<String, DockableProperty>();
            for (Map.Entry<String, DockableProperty> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string.startsWith(DOCKABLE_KEY_PREFIX)) {
                    hashMap.put(string.substring(DOCKABLE_KEY_PREFIX.length()), entry.getValue());
                    continue;
                }
                if (string.startsWith(ROOT_KEY_PREFIX)) {
                    hashMap.put(string.substring(ROOT_KEY_PREFIX.length()), entry.getValue());
                    continue;
                }
                hashMap.put(string, entry.getValue());
            }
            return hashMap;
        }
        return null;
    }

    protected void estimateLocations(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            ((PredefinedDockSituation)dockSituation).estimateLocations(dockLayoutComposition);
        }
    }

    protected Set<Dockable> estimateClosing(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            HashSet<Dockable> hashSet = new HashSet<Dockable>();
            for (Dockable dockable : this.controller.getRegister().listDockables()) {
                hashSet.add(dockable);
            }
            PredefinedDockSituation predefinedDockSituation = (PredefinedDockSituation)dockSituation;
            Set set = predefinedDockSituation.listVisible(hashSet, dockLayoutComposition);
            hashSet.removeAll(set);
            return hashSet;
        }
        return null;
    }

    protected Map<String, DockLayoutComposition> listLayouts(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            Map<String, DockLayoutComposition> map = ((PredefinedDockSituation)dockSituation).listLayouts(dockLayoutComposition, true);
            HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
            for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string.startsWith(DOCKABLE_KEY_PREFIX)) {
                    hashMap.put(string.substring(DOCKABLE_KEY_PREFIX.length()), entry.getValue());
                    continue;
                }
                if (string.startsWith(ROOT_KEY_PREFIX)) {
                    hashMap.put(string.substring(ROOT_KEY_PREFIX.length()), entry.getValue());
                    continue;
                }
                hashMap.put(string, entry.getValue());
            }
            return hashMap;
        }
        return null;
    }

    public Set<Dockable> listShownDockables() {
        HashSet<Dockable> hashSet = new HashSet<Dockable>();
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() == null || !this.isShown(dockInfo.getDockable())) continue;
            hashSet.add(dockInfo.getDockable());
        }
        return hashSet;
    }

    public List<Dockable> listDockables() {
        ArrayList<Dockable> arrayList = new ArrayList<Dockable>(this.dockables.size());
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() == null) continue;
            arrayList.add(dockInfo.getDockable());
        }
        return arrayList;
    }

    public List<FrontendEntry> listFrontendEntries() {
        return new ArrayList<FrontendEntry>(this.dockables.values());
    }

    public FrontendEntry getFrontendEntry(String string) {
        return this.dockables.get(string);
    }

    protected void clean(DockSituationIgnore dockSituationIgnore) {
        for (RootInfo rootInfo : this.roots.values()) {
            if (dockSituationIgnore.ignoreElement(rootInfo.getStation())) continue;
            this.clean(rootInfo.getStation(), dockSituationIgnore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(DockStation dockStation, DockSituationIgnore dockSituationIgnore) {
        try {
            this.controller.getRegister().setStalled(true);
            if (!dockSituationIgnore.ignoreChildren(dockStation)) {
                for (int i = dockStation.getDockableCount() - 1; i >= 0; --i) {
                    Dockable dockable = dockStation.getDockable(i);
                    if (dockSituationIgnore.ignoreElement(dockable)) continue;
                    DockStation dockStation2 = dockable.asDockStation();
                    if (dockStation2 != null) {
                        this.clean(dockStation2, dockSituationIgnore);
                    }
                    dockStation.drag(dockable);
                }
            }
        }
        finally {
            this.controller.getRegister().setStalled(false);
        }
    }

    public boolean delete(String string) {
        boolean bl;
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        boolean bl2 = bl = this.settings.remove(string) != null;
        if (bl) {
            if (string.equals(this.currentSetting)) {
                this.currentSetting = null;
            }
            this.fireDeleted(string);
        }
        return bl;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        if (this.currentSetting == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this.currentSetting);
        }
        dataOutputStream.writeInt(this.settings.size());
        for (Map.Entry<String, Setting> entry : this.settings.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            this.write(entry.getValue(), true, dataOutputStream);
        }
        this.write(this.getSetting(false), false, dataOutputStream);
    }

    protected void write(Setting setting, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        DockSituation dockSituation = this.createSituation(bl);
        PropertyTransformer propertyTransformer = this.createTransformer();
        setting.write(dockSituation, propertyTransformer, bl, dataOutputStream);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.currentSetting = dataInputStream.readBoolean() ? dataInputStream.readUTF() : null;
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            Setting setting = this.read(true, dataInputStream);
            this.settings.put(string, setting);
            this.fireRead(string);
        }
        this.setSetting(this.read(false, dataInputStream), false);
    }

    protected Setting read(boolean bl, DataInputStream dataInputStream) throws IOException {
        Setting setting = this.createSetting();
        DockSituation dockSituation = this.createSituation(bl);
        PropertyTransformer propertyTransformer = this.createTransformer();
        setting.read(dockSituation, propertyTransformer, bl, dataInputStream);
        return setting;
    }

    public void writeXML(XElement xElement) {
        XElement xElement2;
        if (!this.settings.isEmpty()) {
            xElement2 = xElement.addElement("settings");
            for (Map.Entry<String, Setting> entry : this.settings.entrySet()) {
                XElement xElement3 = xElement2.addElement("setting");
                xElement3.addString("name", entry.getKey());
                this.writeXML(entry.getValue(), true, xElement3);
            }
        }
        xElement2 = xElement.addElement("current");
        if (this.currentSetting != null) {
            xElement2.addString("name", this.currentSetting);
        }
        this.writeXML(this.getSetting(false), false, xElement2);
    }

    protected void writeXML(Setting setting, boolean bl, XElement xElement) {
        DockSituation dockSituation = this.createSituation(bl);
        PropertyTransformer propertyTransformer = this.createTransformer();
        setting.writeXML(dockSituation, propertyTransformer, bl, xElement);
    }

    public void readXML(XElement xElement) {
        Object object;
        XElement xElement2 = xElement.getElement("settings");
        if (xElement2 != null) {
            object = xElement2.getElements("setting");
            int n = ((XElement[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                String string = ((XElement)object2).getString("name");
                Setting setting = this.readXML(true, (XElement)object2);
                this.settings.put(string, setting);
                this.fireRead(string);
            }
        }
        if ((object = xElement.getElement("current")) != null) {
            XAttribute xAttribute = ((XElement)object).getAttribute("name");
            if (xAttribute != null) {
                this.currentSetting = xAttribute.getString();
            }
            this.setSetting(this.readXML(false, (XElement)object), false);
        }
    }

    protected Setting readXML(boolean bl, XElement xElement) {
        Setting setting = this.createSetting();
        DockSituation dockSituation = this.createSituation(bl);
        PropertyTransformer propertyTransformer = this.createTransformer();
        setting.readXML(dockSituation, propertyTransformer, bl, xElement);
        return setting;
    }

    protected DockSituation createSituation(boolean bl) {
        return this.createInternalSituation(bl);
    }

    protected final PredefinedDockSituation createInternalSituation(final boolean bl) {
        PredefinedDockSituation predefinedDockSituation = new PredefinedDockSituation(){

            protected boolean shouldLayout(DockElement dockElement) {
                DockInfo dockInfo;
                Dockable dockable;
                if (bl && (dockable = dockElement.asDockable()) != null && (dockInfo = DockFrontend.this.getInfo(dockable)) != null) {
                    dockInfo.isEntryLayout();
                }
                return true;
            }
        };
        for (DockInfo object : this.dockables.values()) {
            if (object.getDockable() == null) continue;
            predefinedDockSituation.put(DOCKABLE_KEY_PREFIX + object.getKey(), object.getDockable());
        }
        for (RootInfo rootInfo : this.roots.values()) {
            predefinedDockSituation.put(ROOT_KEY_PREFIX + rootInfo.getName(), rootInfo.getStation());
        }
        for (DockFactory dockFactory : this.dockFactories) {
            predefinedDockSituation.add(dockFactory);
        }
        for (DockFactory dockFactory : this.backupDockFactories) {
            predefinedDockSituation.addBackup(new RegisteringDockFactory(this, dockFactory));
        }
        for (AdjacentDockFactory adjacentDockFactory : this.adjacentDockFactories) {
            predefinedDockSituation.addAdjacent(adjacentDockFactory);
        }
        if (bl) {
            predefinedDockSituation.setIgnore(this.getIgnoreForEntry());
        } else {
            predefinedDockSituation.setIgnore(this.getIgnoreForFinal());
        }
        return predefinedDockSituation;
    }

    protected PropertyTransformer createTransformer() {
        PropertyTransformer propertyTransformer = new PropertyTransformer();
        for (DockablePropertyFactory dockablePropertyFactory : this.propertyFactories) {
            propertyTransformer.addFactory(dockablePropertyFactory);
        }
        return propertyTransformer;
    }

    protected Hider createHider() {
        return new Hider();
    }

    protected Setting createSetting() {
        return new Setting();
    }

    public Hider getHider() {
        return this.hider;
    }

    private DockInfo getInfo(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable is null");
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() != dockable) continue;
            return dockInfo;
        }
        return null;
    }

    private DockInfo getInfo(String string) {
        return this.dockables.get(string);
    }

    private RootInfo getRoot(DockStation dockStation) {
        for (RootInfo rootInfo : this.roots.values()) {
            if (rootInfo.getStation() != dockStation) continue;
            return rootInfo;
        }
        return null;
    }

    private RootInfo getRoot(Dockable dockable) {
        RootInfo rootInfo;
        DockStation dockStation = dockable.asDockStation();
        if (dockStation != null && (rootInfo = this.getRoot(dockStation)) != null) {
            return rootInfo;
        }
        dockStation = dockable.getDockParent();
        while (dockStation != null) {
            rootInfo = this.getRoot(dockStation);
            if (rootInfo != null) {
                return rootInfo;
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                return null;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    protected DockFrontendListener[] listeners() {
        return this.listeners.toArray(new DockFrontendListener[this.listeners.size()]);
    }

    protected void fireAllHidden(Dockable dockable, final Set<Dockable> set) {
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                if (set == null || set.add(dockable)) {
                    DockFrontend.this.fireHidden(dockable);
                    DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
                    if (dockInfo != null) {
                        dockInfo.setShown(false);
                    }
                }
            }
        });
    }

    protected void fireHidden(Dockable dockable) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.hidden(this, dockable);
        }
    }

    protected void fireAdded(Dockable dockable) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.added(this, dockable);
        }
    }

    protected void fireHideable(Dockable dockable, boolean bl) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.hideable(this, dockable, bl);
        }
    }

    protected void fireRemoved(Dockable dockable) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.removed(this, dockable);
        }
    }

    protected void fireAllShown(Dockable dockable, final Set<Dockable> set) {
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                if (set == null || set.add(dockable)) {
                    DockFrontend.this.fireShown(dockable);
                    DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
                    if (dockInfo != null) {
                        dockInfo.setShown(true);
                    }
                }
            }
        });
    }

    protected void fireShown(Dockable dockable) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.shown(this, dockable);
        }
    }

    protected void fireSaved(String string) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.saved(this, string);
        }
    }

    protected void fireLoaded(String string) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.loaded(this, string);
        }
    }

    protected void fireRead(String string) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.read(this, string);
        }
    }

    protected void fireDeleted(String string) {
        for (DockFrontendListener dockFrontendListener : this.listeners()) {
            dockFrontendListener.deleted(this, string);
        }
    }

    @EclipseTabDockAction
    public class Hider
    extends SimpleButtonAction
    implements ActionGuard,
    IconManagerListener {
        public Hider() {
            this.setText(DockUI.getDefaultDockUI().getString("close"));
            this.setTooltip(DockUI.getDefaultDockUI().getString("close.tooltip"));
            DockFrontend.this.controller.getIcons().add("close", this);
            this.setIcon(DockFrontend.this.controller.getIcons().getIcon("close"));
            PropertyValue<KeyStroke> propertyValue = new PropertyValue<KeyStroke>(HIDE_ACCELERATOR){

                @Override
                protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                    Hider.this.setAccelerator(keyStroke2);
                }
            };
            propertyValue.setProperties(DockFrontend.this.controller);
            this.setAccelerator((KeyStroke)propertyValue.getValue());
        }

        public void iconChanged(String string, Icon icon) {
            this.setIcon(icon);
        }

        public DockActionSource getSource(Dockable dockable) {
            DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
            if (dockInfo == null) {
                return new DefaultDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL), this);
            }
            return dockInfo.getSource();
        }

        public boolean react(Dockable dockable) {
            DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
            return dockInfo != null;
        }

        public void action(Dockable dockable) {
            DockFrontend.this.hide(dockable);
        }
    }

    private static class RootInfo {
        private DockStation station;
        private String name;

        public RootInfo(DockStation dockStation, String string) {
            this.name = string;
            this.station = dockStation;
        }

        public String getName() {
            return this.name;
        }

        public DockStation getStation() {
            return this.station;
        }
    }

    private class DockInfo
    implements FrontendEntry {
        private Dockable dockable;
        private String key;
        private boolean hideable;
        private DefaultDockActionSource source;
        private String root;
        private DockableProperty location;
        private boolean entryLayout;
        private DockLayoutComposition layout;
        private boolean hideActionVisible;
        private boolean shown = false;

        public DockInfo(Dockable dockable, String string) {
            this.dockable = dockable;
            this.key = string;
            this.entryLayout = DockFrontend.this.defaultEntryLayout;
            this.source = new DefaultDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL), new DockAction[0]);
            this.hideActionVisible = false;
            this.setHideable(DockFrontend.this.defaultHideable);
        }

        public void setShown(boolean bl) {
            this.shown = bl;
        }

        public boolean isShown() {
            return this.shown;
        }

        public boolean isEntryLayout() {
            return this.entryLayout;
        }

        public void setEntryLayout(boolean bl) {
            this.entryLayout = bl;
        }

        public boolean isHideable() {
            return this.hideable;
        }

        public void setHideable(boolean bl) {
            this.hideable = bl;
            this.updateHideAction();
        }

        public void updateHideAction() {
            boolean bl;
            boolean bl2 = bl = this.hideable && DockFrontend.this.showHideAction;
            if (bl != this.hideActionVisible) {
                this.hideActionVisible = bl;
                if (bl) {
                    this.source.add(DockFrontend.this.hider);
                } else {
                    this.source.remove(DockFrontend.this.hider);
                }
            }
        }

        public DefaultDockActionSource getSource() {
            return this.source;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public void setDockable(Dockable dockable) {
            this.dockable = dockable;
        }

        public String getKey() {
            return this.key;
        }

        public void updateLocation() {
            RootInfo rootInfo = DockFrontend.this.getRoot(this.dockable);
            if (rootInfo == null) {
                return;
            }
            if (rootInfo.getStation() == this.dockable) {
                if (this.dockable.getDockParent() != null) {
                    rootInfo = DockFrontend.this.getRoot(this.dockable.getDockParent());
                    if (rootInfo == null) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.root = rootInfo.getName();
            this.location = DockUtilities.getPropertyChain(rootInfo.getStation(), this.dockable);
        }

        public void setLocation(String string, DockableProperty dockableProperty) {
            this.root = string;
            this.location = dockableProperty;
        }

        public String getRoot() {
            return this.root;
        }

        public DockableProperty getLocation() {
            return this.location;
        }

        public void setLayout(DockLayoutComposition dockLayoutComposition) {
            this.layout = dockLayoutComposition;
        }

        public DockLayoutComposition getLayout() {
            return this.layout;
        }
    }
}

