/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.ActionOffer;
import bibliothek.gui.dock.action.ActionPopupSuppressor;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.control.ComponentHierarchyObserver;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.DefaultDockControllerFactory;
import bibliothek.gui.dock.control.DockControllerFactory;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.DockableSelector;
import bibliothek.gui.dock.control.DoubleClickController;
import bibliothek.gui.dock.control.KeyboardController;
import bibliothek.gui.dock.control.MouseFocusObserver;
import bibliothek.gui.dock.control.SingleParentRemover;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleBindingListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.DockableSelectionEvent;
import bibliothek.gui.dock.event.DockableSelectionListener;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleManager;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import bibliothek.gui.dock.util.WindowProviderWrapper;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.font.FontManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.FocusManager;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class DockController {
    private DockRegister register;
    private ComponentHierarchyObserver componentHierarchyObserver;
    private DockRelocator relocator;
    private DoubleClickController doubleClickController;
    private KeyboardController keyboardController;
    private DockableSelector dockableSelector;
    private Dockable focusedDockable = null;
    private List<DockableFocusListener> dockableFocusListeners = new ArrayList<DockableFocusListener>();
    private List<DockableSelectionListener> dockableSelectionListeners = new ArrayList<DockableSelectionListener>();
    private List<DockTitleBindingListener> dockTitleBindingListeners = new ArrayList<DockTitleBindingListener>();
    private List<UIListener> uiListeners = new ArrayList<UIListener>();
    private boolean onFocusing = false;
    private MouseFocusObserver focusObserver;
    private DockTitleObserver dockTitleObserver = new DockTitleObserver();
    private Map<DockTitle, Dockable> activeTitles = new HashMap<DockTitle, Dockable>();
    private DockTitleManager dockTitles = new DockTitleManager(this);
    private IconManager icons = new IconManager();
    private ColorManager colors = new ColorManager();
    private FontManager fonts = new FontManager();
    private List<ActionOffer> actionOffers = new ArrayList<ActionOffer>();
    private List<ActionGuard> guards = new ArrayList<ActionGuard>();
    private ActionOffer defaultActionOffer;
    private ActionViewConverter actionViewConverter;
    private MultiDockAcceptance acceptance = new MultiDockAcceptance();
    private ActionPopupSuppressor popupSuppressor = ActionPopupSuppressor.ALLOW_ALWAYS;
    private SingleParentRemover remover;
    private DockTheme theme;
    private DockProperties properties = new DockProperties();
    private DockControllerFactory factory;
    private Map<Component, DockElementRepresentative> componentToDockElements = new HashMap<Component, DockElementRepresentative>();
    private List<DockControllerRepresentativeListener> componentToDockElementsListeners = new ArrayList<DockControllerRepresentativeListener>();
    private WindowProviderWrapper rootWindowProvider;
    private Window rootWindow;
    private PropertyChangeListener lookAndFeelObserver = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                DockController.this.updateUI();
            }
        }
    };

    public DockController() {
        this(new DefaultDockControllerFactory());
    }

    public DockController(DockControllerFactory dockControllerFactory) {
        if (dockControllerFactory != null) {
            this.initiate(dockControllerFactory, null);
        }
    }

    protected final void initiate(DockControllerFactory dockControllerFactory, ControllerSetupCollection controllerSetupCollection) {
        if (this.factory != null) {
            throw new IllegalStateException("DockController already initialized");
        }
        if (dockControllerFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.rootWindowProvider = new WindowProviderWrapper();
        this.rootWindowProvider.addWindowProviderListener(new WindowProviderListener(){

            public void windowChanged(WindowProvider windowProvider, Window window) {
                Window window2 = DockController.this.rootWindow;
                DockController.this.rootWindow = window;
                DockController.this.rootWindowChanged(window2, window);
            }

            public void visibilityChanged(WindowProvider windowProvider, boolean bl) {
            }
        });
        final LinkedList linkedList = new LinkedList();
        if (controllerSetupCollection == null) {
            controllerSetupCollection = new ControllerSetupCollection(){

                public void add(ControllerSetupListener controllerSetupListener) {
                    if (controllerSetupListener == null) {
                        throw new NullPointerException("listener must not be null");
                    }
                    linkedList.add(controllerSetupListener);
                }
            };
        }
        this.factory = dockControllerFactory;
        this.register = dockControllerFactory.createRegister(this, controllerSetupCollection);
        DockRegisterListener dockRegisterListener = dockControllerFactory.createFocusController(this, controllerSetupCollection);
        if (dockRegisterListener != null) {
            this.register.addDockRegisterListener(dockRegisterListener);
        }
        dockControllerFactory.createPopupController(this, controllerSetupCollection);
        DockRegisterListener dockRegisterListener2 = dockControllerFactory.createActionBinder(this, controllerSetupCollection);
        if (dockRegisterListener2 != null) {
            this.register.addDockRegisterListener(dockRegisterListener2);
        }
        this.register.addDockRegisterListener(this.dockTitleObserver);
        this.addDockTitleBindingListener(this.dockTitleObserver);
        this.register.addDockRegisterListener(new DockableSelectionObserver());
        this.relocator = dockControllerFactory.createRelocator(this, controllerSetupCollection);
        this.defaultActionOffer = dockControllerFactory.createDefaultActionOffer(this, controllerSetupCollection);
        this.focusObserver = dockControllerFactory.createMouseFocusObserver(this, controllerSetupCollection);
        this.actionViewConverter = dockControllerFactory.createActionViewConverter(this, controllerSetupCollection);
        this.doubleClickController = dockControllerFactory.createDoubleClickController(this, controllerSetupCollection);
        this.keyboardController = dockControllerFactory.createKeyboardController(this, controllerSetupCollection);
        this.dockableSelector = dockControllerFactory.createDockableSelector(this, controllerSetupCollection);
        DockUI.getDefaultDockUI().fillIcons(this.icons);
        this.setTheme(DockUI.getDefaultDockUI().getDefaultTheme().create());
        this.relocator.addMode(DockRelocatorMode.SCREEN_ONLY);
        this.relocator.addMode(DockRelocatorMode.NO_COMBINATION);
        this.properties.set(SplitDockStation.MAXIMIZE_ACCELERATOR, KeyStroke.getKeyStroke(77, 128));
        this.properties.set(DockFrontend.HIDE_ACCELERATOR, KeyStroke.getKeyStroke(115, 128));
        this.properties.set(DockableSelector.INIT_SELECTION, KeyStroke.getKeyStroke(69, 192));
        this.setSingleParentRemover(dockControllerFactory.createSingleParentRemover(this, controllerSetupCollection));
        UIManager.addPropertyChangeListener(this.lookAndFeelObserver);
        for (ControllerSetupListener controllerSetupListener : linkedList) {
            controllerSetupListener.done(this);
        }
    }

    public void kill() {
        this.focusObserver.kill();
        this.register.kill();
        this.keyboardController.kill();
        this.theme.uninstall(this);
        UIManager.removePropertyChangeListener(this.lookAndFeelObserver);
        this.setRootWindowProvider(null);
    }

    public MouseFocusObserver getFocusObserver() {
        return this.focusObserver;
    }

    public DockRegister getRegister() {
        return this.register;
    }

    public ComponentHierarchyObserver getComponentHierarchyObserver() {
        if (this.componentHierarchyObserver == null) {
            this.componentHierarchyObserver = new ComponentHierarchyObserver(this);
            if (this.rootWindow != null) {
                this.componentHierarchyObserver.add(this.rootWindow);
            }
        }
        return this.componentHierarchyObserver;
    }

    public DockRelocator getRelocator() {
        return this.relocator;
    }

    public DoubleClickController getDoubleClickController() {
        return this.doubleClickController;
    }

    public KeyboardController getKeyboardController() {
        return this.keyboardController;
    }

    public ActionViewConverter getActionViewConverter() {
        return this.actionViewConverter;
    }

    public SingleParentRemover getSingleParentRemover() {
        return this.remover;
    }

    public void setSingleParentRemover(SingleParentRemover singleParentRemover) {
        if (this.remover != null) {
            this.remover.uninstall(this);
        }
        this.remover = singleParentRemover;
        if (this.remover != null) {
            this.remover.install(this);
            this.remover.testAll(this);
        }
    }

    public boolean freezeLayout() {
        DockRegister dockRegister = this.getRegister();
        boolean bl = dockRegister.isStalled();
        this.getRegister().setStalled(true);
        return bl;
    }

    public boolean isLayoutFrozen() {
        return this.getRegister().isStalled();
    }

    public boolean meltLayout() {
        if (!this.isLayoutFrozen()) {
            throw new IllegalStateException("the layout is not frozen");
        }
        DockRegister dockRegister = this.getRegister();
        dockRegister.setStalled(false);
        return dockRegister.isStalled();
    }

    public MultiDockAcceptance getAcceptance() {
        return this.acceptance;
    }

    public void addAcceptance(DockAcceptance dockAcceptance) {
        this.acceptance.add(dockAcceptance);
    }

    public void removeAcceptance(DockAcceptance dockAcceptance) {
        this.acceptance.remove(dockAcceptance);
    }

    public ActionPopupSuppressor getPopupSuppressor() {
        return this.popupSuppressor;
    }

    public void setPopupSuppressor(ActionPopupSuppressor actionPopupSuppressor) {
        if (actionPopupSuppressor == null) {
            throw new IllegalArgumentException("suppressor must not be null");
        }
        this.popupSuppressor = actionPopupSuppressor;
    }

    public ActionOffer getDefaultActionOffer() {
        return this.defaultActionOffer;
    }

    public void setDefaultActionOffer(ActionOffer actionOffer) {
        if (actionOffer == null) {
            throw new IllegalArgumentException();
        }
        this.defaultActionOffer = actionOffer;
    }

    public void addActionOffer(ActionOffer actionOffer) {
        if (actionOffer == null) {
            throw new IllegalArgumentException();
        }
        this.actionOffers.add(actionOffer);
    }

    public void removeActionOffer(ActionOffer actionOffer) {
        this.actionOffers.remove(actionOffer);
    }

    public ActionOffer getActionOffer(Dockable dockable) {
        for (ActionOffer actionOffer : this.actionOffers) {
            if (!actionOffer.interested(dockable)) continue;
            return actionOffer;
        }
        return this.getDefaultActionOffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTheme(DockTheme dockTheme) {
        if (dockTheme == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        if (this.theme != dockTheme) {
            for (UIListener uIListener : this.uiListeners()) {
                uIListener.themeWillChange(this, this.theme, dockTheme);
            }
            DockTheme dockTheme2 = this.theme;
            Dockable dockable = null;
            try {
                this.register.setStalled(true);
                dockable = this.getFocusedDockable();
                if (this.theme != null) {
                    this.theme.uninstall(this);
                }
                this.theme = dockTheme;
                dockTheme.install(this);
                for (DockStation dockStation : this.register.listDockStations()) {
                    if (dockStation.getController() != this) continue;
                    dockStation.updateTheme();
                }
            }
            finally {
                this.register.setStalled(false);
            }
            this.setFocusedDockable(dockable, true);
            for (UIListener uIListener : this.uiListeners()) {
                uIListener.themeChanged(this, dockTheme2, dockTheme);
            }
        }
    }

    public DockTheme getTheme() {
        return this.theme;
    }

    public DockProperties getProperties() {
        return this.properties;
    }

    public void addRepresentativeListener(DockControllerRepresentativeListener dockControllerRepresentativeListener) {
        if (dockControllerRepresentativeListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.componentToDockElementsListeners.add(dockControllerRepresentativeListener);
    }

    public void removeRepresentativeListener(DockControllerRepresentativeListener dockControllerRepresentativeListener) {
        this.componentToDockElementsListeners.remove(dockControllerRepresentativeListener);
    }

    public void addRepresentative(DockElementRepresentative dockElementRepresentative) {
        DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray = this.componentToDockElementsListeners.toArray(new DockControllerRepresentativeListener[this.componentToDockElementsListeners.size()]);
        DockElementRepresentative dockElementRepresentative2 = this.componentToDockElements.put(dockElementRepresentative.getComponent(), dockElementRepresentative);
        if (dockElementRepresentative2 != null) {
            for (DockControllerRepresentativeListener dockControllerRepresentativeListener : dockControllerRepresentativeListenerArray) {
                dockControllerRepresentativeListener.representativeRemoved(this, dockElementRepresentative2);
            }
        }
        if (dockElementRepresentative != null) {
            for (DockControllerRepresentativeListener dockControllerRepresentativeListener : dockControllerRepresentativeListenerArray) {
                dockControllerRepresentativeListener.representativeAdded(this, dockElementRepresentative);
            }
        }
    }

    public void removeRepresentative(DockElementRepresentative dockElementRepresentative) {
        if (this.componentToDockElements.remove(dockElementRepresentative.getComponent()) != null) {
            DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray;
            for (DockControllerRepresentativeListener dockControllerRepresentativeListener : dockControllerRepresentativeListenerArray = this.componentToDockElementsListeners.toArray(new DockControllerRepresentativeListener[this.componentToDockElementsListeners.size()])) {
                dockControllerRepresentativeListener.representativeRemoved(this, dockElementRepresentative);
            }
        }
    }

    public DockElementRepresentative searchElement(Component component) {
        while (component != null) {
            DockElementRepresentative dockElementRepresentative = this.componentToDockElements.get(component);
            if (dockElementRepresentative != null && dockElementRepresentative.getElement().getController() == this) {
                return dockElementRepresentative;
            }
            component = component.getParent();
        }
        return null;
    }

    public void add(DockStation dockStation) {
        this.register.add(dockStation);
    }

    public void remove(DockStation dockStation) {
        this.register.remove(dockStation);
    }

    public int getStationCount() {
        return this.register.getStationCount();
    }

    public DockStation getStation(int n) {
        return this.register.getStation(n);
    }

    public boolean isOnFocusing() {
        return this.onFocusing;
    }

    public void setAtLeastFocusedDockable(Dockable dockable) {
        if (this.focusedDockable == null) {
            this.setFocusedDockable(dockable, false);
        }
        if (!DockUtilities.isAncestor(dockable, this.focusedDockable)) {
            this.setFocusedDockable(dockable, false);
        }
    }

    public void setFocusedDockable(Dockable dockable, boolean bl) {
        this.setFocusedDockable(dockable, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusedDockable(Dockable dockable, boolean bl, boolean bl2) {
        if (this.onFocusing) {
            return;
        }
        try {
            this.onFocusing = true;
            if (bl || this.focusedDockable != dockable) {
                DockTitle[] dockTitleArray;
                Dockable dockable2 = this.focusedDockable;
                this.focusedDockable = dockable;
                for (Map.Entry<DockTitle, Dockable> object2 : this.activeTitles.entrySet()) {
                    dockTitleArray = object2.getValue().getDockParent();
                    if (dockTitleArray != null) {
                        dockTitleArray.changed(object2.getValue(), object2.getKey(), false);
                        continue;
                    }
                    object2.getKey().changed(new DockTitleEvent(object2.getValue(), false));
                }
                this.activeTitles.clear();
                Object object = dockable;
                while (object != null) {
                    DockStation dockStation = object.getDockParent();
                    if (dockStation != null) {
                        for (DockTitle dockTitle : dockTitleArray = object.listBoundTitles()) {
                            dockStation.changed((Dockable)object, dockTitle, true);
                            this.activeTitles.put(dockTitle, (Dockable)object);
                        }
                        dockStation.setFrontDockable((Dockable)object);
                        object = dockStation.asDockable();
                        continue;
                    }
                    object = null;
                }
                if (bl2) {
                    if (EventQueue.isDispatchThread()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DockController.this.ensureFocusSet();
                            }
                        });
                    } else {
                        this.ensureFocusSet();
                    }
                }
                if (dockable2 != dockable) {
                    this.fireDockableFocused(dockable2, dockable);
                }
            }
        }
        finally {
            this.onFocusing = false;
        }
    }

    public boolean isFocused(Dockable dockable) {
        Dockable dockable2 = this.focusedDockable;
        while (dockable2 != null) {
            if (dockable2 == dockable) {
                return true;
            }
            DockStation dockStation = dockable2.getDockParent();
            dockable2 = dockStation == null ? null : dockStation.asDockable();
        }
        return false;
    }

    public boolean isBound(DockTitle dockTitle) {
        return this.dockTitleObserver.isBound(dockTitle);
    }

    public void ensureFocusSet() {
        Dockable dockable = this.focusedDockable;
        if (dockable != null) {
            Object object;
            Object object2;
            Stack<Dockable> stack = new Stack<Dockable>();
            Dockable dockable2 = dockable;
            while (dockable2 != null) {
                object2 = dockable2.getDockParent();
                if (object2 != null) {
                    stack.push(dockable2);
                }
                dockable2 = object2 == null ? null : object2.asDockable();
            }
            while (!stack.isEmpty()) {
                object2 = (Dockable)stack.pop();
                object2.getDockParent().setFrontDockable((Dockable)object2);
            }
            object2 = dockable.listBoundTitles();
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (component != null) {
                if (SwingUtilities.isDescendingFrom(component, dockable.getComponent())) {
                    return;
                }
                object = object2;
                int n = ((Object)object).length;
                for (int i = 0; i < n; ++i) {
                    Object object3 = object[i];
                    if (!SwingUtilities.isDescendingFrom(component, object3.getComponent())) continue;
                    return;
                }
            }
            if (((Component)(object = dockable.getComponent())).isFocusable()) {
                ((Component)object).requestFocus();
                ((Component)object).requestFocusInWindow();
                this.focus((Component)object, 10, 20);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent((Component)object);
            }
        }
    }

    private void focus(final Component component, int n, final int n2) {
        final Timer timer = new Timer(n, null);
        timer.addActionListener(new ActionListener(){
            private int remaining;
            {
                this.remaining = n2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                --this.remaining;
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (keyboardFocusManager.getPermanentFocusOwner() != component) {
                    keyboardFocusManager.clearGlobalFocusOwner();
                    component.requestFocus();
                    if (this.remaining > 0) {
                        timer.restart();
                    }
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public Dockable getFocusedDockable() {
        return this.focusedDockable;
    }

    public DockableSelector getDockableSelector() {
        return this.dockableSelector;
    }

    public DockTitleManager getDockTitleManager() {
        return this.dockTitles;
    }

    public IconManager getIcons() {
        return this.icons;
    }

    public ColorManager getColors() {
        return this.colors;
    }

    public FontManager getFonts() {
        return this.fonts;
    }

    public void setRootWindow(Window window) {
        if (window == null) {
            this.setRootWindowProvider(null);
        } else {
            this.setRootWindowProvider(new DirectWindowProvider(window));
        }
    }

    public void setRootWindowProvider(WindowProvider windowProvider) {
        this.rootWindowProvider.setDelegate(windowProvider);
    }

    public WindowProviderWrapper getRootWindowProvider() {
        return this.rootWindowProvider;
    }

    protected void rootWindowChanged(Window window, Window window2) {
        if (this.componentHierarchyObserver != null) {
            if (window != null) {
                this.componentHierarchyObserver.remove(window);
            }
            if (window2 != null) {
                this.componentHierarchyObserver.add(window2);
            }
        }
    }

    public Window findRootWindow() {
        Component component;
        Object object;
        if (this.rootWindow != null) {
            return this.rootWindow;
        }
        Component component2 = null;
        Dialog dialog = null;
        for (DockStation dockElement : this.getRegister().listRoots()) {
            Window window;
            object = dockElement.asDockable();
            if (object == null || (window = SwingUtilities.getWindowAncestor(component = object.getComponent())) == null) continue;
            component2 = window;
            if (window instanceof Frame) {
                return window;
            }
            if (!(window instanceof Dialog)) continue;
            dialog = (Dialog)window;
        }
        for (DockElement dockElement : this.getRegister().listDockables()) {
            object = dockElement.getComponent();
            component = SwingUtilities.getWindowAncestor((Component)object);
            if (component == null) continue;
            component2 = component;
            if (component instanceof Frame) {
                return component;
            }
            if (!(component instanceof Dialog)) continue;
            dialog = (Dialog)component;
        }
        if (dialog != null) {
            return dialog;
        }
        return component2;
    }

    public void addActionGuard(ActionGuard actionGuard) {
        if (actionGuard == null) {
            throw new IllegalArgumentException("guard must not be null");
        }
        this.guards.add(actionGuard);
    }

    public void removeActionGuard(ActionGuard actionGuard) {
        this.guards.remove(actionGuard);
    }

    /*
     * WARNING - void declaration
     */
    public DockActionSource listOffers(Dockable dockable) {
        void var6_9;
        Object object2;
        ArrayList<DockActionSource> arrayList = new ArrayList<DockActionSource>();
        ArrayList<DockActionSource> arrayList2 = new ArrayList<DockActionSource>();
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            arrayList2.add(dockStation.getIndirectActionOffers(dockable));
            object2 = dockStation.asDockable();
            if (object2 != null) {
                dockStation = object2.getDockParent();
                continue;
            }
            dockStation = null;
        }
        for (ActionGuard object3 : this.guards) {
            if (!object3.react(dockable)) continue;
            arrayList.add(object3.getSource(dockable));
        }
        object2 = this.getActionOffer(dockable);
        Object var6_7 = null;
        if (dockable.getDockParent() != null) {
            DockActionSource dockActionSource = dockable.getDockParent().getDirectActionOffers(dockable);
        }
        return object2.getSource(dockable, dockable.getLocalActionOffers(), arrayList.toArray(new DockActionSource[arrayList.size()]), (DockActionSource)var6_9, arrayList2.toArray(new DockActionSource[arrayList2.size()]));
    }

    public void addDockTitleBindingListener(DockTitleBindingListener dockTitleBindingListener) {
        if (dockTitleBindingListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockTitleBindingListeners.add(dockTitleBindingListener);
    }

    public void removeDockTitleBindingListener(DockTitleBindingListener dockTitleBindingListener) {
        if (dockTitleBindingListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockTitleBindingListeners.remove(dockTitleBindingListener);
    }

    protected DockTitleBindingListener[] dockTitleBindingListeners() {
        return this.dockTitleBindingListeners.toArray(new DockTitleBindingListener[this.dockTitleBindingListeners.size()]);
    }

    public void addDockableFocusListener(DockableFocusListener dockableFocusListener) {
        if (dockableFocusListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableFocusListeners.add(dockableFocusListener);
    }

    public void removeDockableFocusListener(DockableFocusListener dockableFocusListener) {
        if (dockableFocusListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableFocusListeners.remove(dockableFocusListener);
    }

    protected DockableFocusListener[] dockableFocusListeners() {
        return this.dockableFocusListeners.toArray(new DockableFocusListener[this.dockableFocusListeners.size()]);
    }

    public void addDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        if (dockableSelectionListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableSelectionListeners.add(dockableSelectionListener);
    }

    public void removeDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        this.dockableSelectionListeners.remove(dockableSelectionListener);
    }

    protected DockableSelectionListener[] dockableSelectionListeners() {
        return this.dockableSelectionListeners.toArray(new DockableSelectionListener[this.dockableSelectionListeners.size()]);
    }

    protected void fireTitleBound(DockTitle dockTitle, Dockable dockable) {
        for (DockTitleBindingListener dockTitleBindingListener : this.dockTitleBindingListeners()) {
            dockTitleBindingListener.titleBound(this, dockTitle, dockable);
        }
    }

    protected void fireTitleUnbound(DockTitle dockTitle, Dockable dockable) {
        for (DockTitleBindingListener dockTitleBindingListener : this.dockTitleBindingListeners()) {
            dockTitleBindingListener.titleUnbound(this, dockTitle, dockable);
        }
    }

    protected void fireDockableFocused(Dockable dockable, Dockable dockable2) {
        DockableFocusEvent dockableFocusEvent = new DockableFocusEvent(this, dockable, dockable2);
        for (DockableFocusListener dockableFocusListener : this.dockableFocusListeners()) {
            dockableFocusListener.dockableFocused(dockableFocusEvent);
        }
    }

    protected void fireDockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
        DockableSelectionEvent dockableSelectionEvent = new DockableSelectionEvent(this, dockStation, dockable, dockable2);
        for (DockableSelectionListener dockableSelectionListener : this.dockableSelectionListeners()) {
            dockableSelectionListener.dockableSelected(dockableSelectionEvent);
        }
    }

    public void addUIListener(UIListener uIListener) {
        this.uiListeners.add(uIListener);
    }

    public void removeUIListener(UIListener uIListener) {
        this.uiListeners.remove(uIListener);
    }

    protected UIListener[] uiListeners() {
        return this.uiListeners.toArray(new UIListener[this.uiListeners.size()]);
    }

    public void updateUI() {
        for (UIListener uIListener : this.uiListeners()) {
            uIListener.updateUI(this);
        }
    }

    private class DockTitleObserver
    extends DockRegisterAdapter
    implements DockTitleBindingListener {
        private Set<DockTitle> titles = new HashSet<DockTitle>();
        private DockableListener dockableListener = new DockableAdapter(){

            public void titleBound(Dockable dockable, DockTitle dockTitle) {
                DockTitleObserver.this.titles.add(dockTitle);
                dockTitle.bind();
                DockController.this.fireTitleBound(dockTitle, dockable);
                DockStation dockStation = dockable.getDockParent();
                boolean bl = false;
                Dockable dockable2 = DockController.this.focusedDockable;
                while (!bl && dockable2 != null) {
                    bl = dockable2 == dockable;
                    DockStation dockStation2 = dockable2.getDockParent();
                    dockable2 = dockStation2 == null ? null : dockStation2.asDockable();
                }
                if (dockStation == null) {
                    dockTitle.changed(new DockTitleEvent(dockable, bl));
                } else {
                    dockStation.changed(dockable, dockTitle, bl);
                }
                if (bl) {
                    DockController.this.activeTitles.put(dockTitle, dockable);
                }
            }

            public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
                DockTitleObserver.this.titles.remove(dockTitle);
                dockTitle.unbind();
                DockController.this.fireTitleUnbound(dockTitle, dockable);
            }
        };

        private DockTitleObserver() {
        }

        public boolean isBound(DockTitle dockTitle) {
            return this.titles.contains(dockTitle);
        }

        public void titleBound(DockController dockController, DockTitle dockTitle, Dockable dockable) {
            DockController.this.addRepresentative(dockTitle);
        }

        public void titleUnbound(DockController dockController, DockTitle dockTitle, Dockable dockable) {
            DockController.this.removeRepresentative(dockTitle);
            DockController.this.activeTitles.remove(dockTitle);
            DockStation dockStation = dockable.getDockParent();
            if (dockStation != null) {
                dockStation.changed(dockable, dockTitle, false);
            } else {
                dockTitle.changed(new DockTitleEvent(dockable, false));
            }
        }

        public void dockableRegistering(DockController dockController, Dockable dockable) {
            dockable.addDockableListener(this.dockableListener);
        }

        public void dockableRegistered(DockController dockController, Dockable dockable) {
            DockTitle[] dockTitleArray;
            DockController.this.addRepresentative(dockable);
            for (DockTitle dockTitle : dockTitleArray = dockable.listBoundTitles()) {
                if (!this.titles.add(dockTitle)) continue;
                dockTitle.bind();
                DockController.this.fireTitleBound(dockTitle, dockable);
            }
        }

        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            DockTitle[] dockTitleArray;
            dockable.removeDockableListener(this.dockableListener);
            DockController.this.removeRepresentative(dockable);
            for (DockTitle dockTitle : dockTitleArray = dockable.listBoundTitles()) {
                if (!this.titles.remove(dockTitle)) continue;
                dockTitle.unbind();
                DockController.this.fireTitleUnbound(dockTitle, dockable);
            }
        }
    }

    private class DockableSelectionObserver
    extends DockRegisterAdapter {
        private DockStationListener listener = new DockStationAdapter(){

            public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
                DockController.this.fireDockableSelected(dockStation, dockable, dockable2);
            }
        };

        private DockableSelectionObserver() {
        }

        public void dockStationRegistered(DockController dockController, DockStation dockStation) {
            dockStation.addDockStationListener(this.listener);
        }

        public void dockStationUnregistered(DockController dockController, DockStation dockStation) {
            dockStation.removeDockStationListener(this.listener);
        }
    }
}

