/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.CombinedStackDockComponent;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.DLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatTab
extends CombinedStackDockComponent<FlatButton> {
    private StackDockStation station;

    public FlatTab(StackDockStation stackDockStation) {
        this.station = stackDockStation;
    }

    @Override
    protected FlatButton createTab(Dockable dockable) {
        return new FlatButton(dockable);
    }

    @Override
    protected void destroy(FlatButton flatButton) {
        flatButton.setController(null);
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            ((FlatButton)this.getTab(i)).setController(dockController);
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        int n2 = this.getTabCount();
        for (int i = 0; i < n2; ++i) {
            ((FlatButton)this.getTab(i)).updateForeground();
            ((FlatButton)this.getTab(i)).updateFonts();
        }
    }

    @Override
    public boolean hasBorder() {
        return false;
    }

    protected class FlatButton
    extends DLabel
    implements CombinedTab,
    DockableFocusListener {
        private Dockable dockable;
        private DockController controller;
        private int index;
        private boolean focused = false;
        private TabColor borderSelectedOut;
        private TabColor borderSelectedCenter;
        private TabColor borderFocusedOut;
        private TabColor borderFocusedCenter;
        private TabColor borderOut;
        private TabColor borderCenter;
        private TabColor border;
        private TabColor backgroundSelectedTop;
        private TabColor backgroundSelectedBottom;
        private TabColor backgroundFocusedTop;
        private TabColor backgroundFocusedBottom;
        private TabColor backgroundTop;
        private TabColor backgroundBottom;
        private TabColor background;
        private TabColor foreground;
        private TabColor foregroundSelected;
        private TabColor foregroundFocused;
        private TabFont fontFocused;
        private TabFont fontSelected;
        private TabFont fontUnselected;

        public FlatButton(Dockable dockable) {
            this.dockable = dockable;
            this.borderSelectedOut = new FlatTabColor("stack.tab.border.out.selected", dockable);
            this.borderSelectedCenter = new FlatTabColor("stack.tab.border.center.selected", dockable);
            this.borderFocusedOut = new FlatTabColor("stack.tab.border.out.focused", dockable);
            this.borderFocusedCenter = new FlatTabColor("stack.tab.border.center.focused", dockable);
            this.borderOut = new FlatTabColor("stack.tab.border.out", dockable);
            this.borderCenter = new FlatTabColor("stack.tab.border.center", dockable);
            this.border = new FlatTabColor("stack.tab.border", dockable);
            this.backgroundSelectedTop = new FlatTabColor("stack.tab.background.top.selected", dockable);
            this.backgroundSelectedBottom = new FlatTabColor("stack.tab.background.bottom.selected", dockable);
            this.backgroundFocusedTop = new FlatTabColor("stack.tab.background.top.focused", dockable);
            this.backgroundFocusedBottom = new FlatTabColor("stack.tab.background.bottom.focused", dockable);
            this.backgroundTop = new FlatTabColor("stack.tab.background.top", dockable);
            this.backgroundBottom = new FlatTabColor("stack.tab.background.bottom", dockable);
            this.background = new FlatTabColor("stack.tab.background", dockable);
            this.foreground = new FlatTabColor("stack.tab.foreground", dockable){

                protected void changed(Color color, Color color2) {
                    if (!FlatButton.this.isSelected()) {
                        FlatButton.this.setForeground(color2);
                    }
                }
            };
            this.foregroundSelected = new FlatTabColor("stack.tab.foreground.selected", dockable){

                protected void changed(Color color, Color color2) {
                    if (FlatButton.this.isSelected() && !FlatButton.this.focused) {
                        FlatButton.this.setForeground(color2);
                    }
                }
            };
            this.foregroundFocused = new FlatTabColor("stack.tab.foreground.focused", dockable){

                protected void changed(Color color, Color color2) {
                    if (FlatButton.this.focused) {
                        FlatButton.this.setForeground(color2);
                    }
                }
            };
            this.fontFocused = new FlatTabFont("tab.focused", dockable);
            this.fontSelected = new FlatTabFont("tab.selected", dockable);
            this.fontUnselected = new FlatTabFont("tab.unselected", dockable);
            this.setController(FlatTab.this.getController());
            this.setOpaque(false);
            this.setFocusable(true);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    FlatTab.this.setSelectedIndex(FlatButton.this.index);
                    FlatButton.this.repaint();
                }
            });
            this.setBorder(new Border(){

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Paint paint = graphics2D.getPaint();
                    Color color = null;
                    Color color2 = null;
                    if (FlatButton.this.focused) {
                        color = (Color)FlatButton.this.borderFocusedOut.value();
                        color2 = (Color)FlatButton.this.borderFocusedCenter.value();
                    }
                    if (FlatButton.this.isSelected()) {
                        if (color == null) {
                            color = (Color)FlatButton.this.borderSelectedOut.value();
                        }
                        if (color2 == null) {
                            color2 = (Color)FlatButton.this.borderSelectedCenter.value();
                        }
                    }
                    if (color == null) {
                        color = (Color)FlatButton.this.borderOut.value();
                    }
                    if (color2 == null) {
                        color2 = (Color)FlatButton.this.borderCenter.value();
                    }
                    if (color == null || color2 == null) {
                        Color color3 = (Color)FlatButton.this.border.value();
                        if (color3 == null) {
                            color3 = (Color)FlatButton.this.background.value();
                        }
                        if (color3 == null) {
                            color3 = FlatButton.this.getBackground();
                        }
                        if (color == null) {
                            color = color3;
                        }
                        if (color2 == null) {
                            color2 = FlatButton.this.isSelected() ? color3.brighter() : color3.darker();
                        }
                    }
                    graphics2D.setPaint(new GradientPaint(n, n2, color, n, n2 + n4 / 2, color2));
                    graphics.drawLine(n, n2, n, n2 + n4 / 2);
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 / 2);
                    graphics2D.setPaint(new GradientPaint(n, n2 + n4, color, n, n2 + n4 / 2, color2));
                    graphics.drawLine(n, n2 + n4, n, n2 + n4 / 2);
                    graphics.drawLine(n + n3 - 1, n2 + n4, n + n3 - 1, n2 + n4 / 2);
                    graphics2D.setPaint(paint);
                }

                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 1, 0, 1);
                }

                public boolean isBorderOpaque() {
                    return false;
                }
            });
        }

        public void updateForeground() {
            if (this.focused) {
                this.setForeground((Color)this.foregroundFocused.value());
            } else if (this.isSelected()) {
                this.setForeground((Color)this.foregroundSelected.value());
            } else {
                this.setForeground((Color)this.foreground.value());
            }
        }

        public void updateFonts() {
            if (this.focused) {
                this.setFontModifier(this.fontFocused.font());
            } else if (this.isSelected()) {
                this.setFontModifier(this.fontSelected.font());
            } else {
                this.setFontModifier(this.fontUnselected.font());
            }
        }

        public void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.removeDockableFocusListener(this);
            }
            this.controller = dockController;
            if (dockController != null) {
                dockController.addDockableFocusListener(this);
            }
            this.borderSelectedOut.connect(dockController);
            this.borderSelectedCenter.connect(dockController);
            this.borderFocusedOut.connect(dockController);
            this.borderFocusedCenter.connect(dockController);
            this.borderOut.connect(dockController);
            this.borderCenter.connect(dockController);
            this.border.connect(dockController);
            this.backgroundSelectedTop.connect(dockController);
            this.backgroundSelectedBottom.connect(dockController);
            this.backgroundFocusedTop.connect(dockController);
            this.backgroundFocusedBottom.connect(dockController);
            this.backgroundTop.connect(dockController);
            this.backgroundBottom.connect(dockController);
            this.background.connect(dockController);
            this.foregroundSelected.connect(dockController);
            this.foregroundFocused.connect(dockController);
            this.foreground.connect(dockController);
            this.fontFocused.connect(dockController);
            this.fontSelected.connect(dockController);
            this.fontUnselected.connect(dockController);
        }

        public Point getPopupLocation(Point point, boolean bl) {
            if (bl) {
                return point;
            }
            return null;
        }

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            this.focused = this.dockable == dockableFocusEvent.getNewFocusOwner();
            this.updateForeground();
            this.updateFonts();
            this.repaint();
        }

        public JComponent getComponent() {
            return this;
        }

        public DockElement getElement() {
            return this.dockable;
        }

        public boolean isUsedAsTitle() {
            return false;
        }

        public void addMouseInputListener(MouseInputListener mouseInputListener) {
            this.addMouseListener(mouseInputListener);
            this.addMouseMotionListener(mouseInputListener);
        }

        public void removeMouseInputListener(MouseInputListener mouseInputListener) {
            this.removeMouseListener(mouseInputListener);
            this.removeMouseMotionListener(mouseInputListener);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.width < 10 || dimension.height < 10) {
                dimension = new Dimension(dimension);
                dimension.width = Math.max(dimension.width, 10);
                dimension.height = Math.max(dimension.height, 10);
            }
            return dimension;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            if (dimension.width < 10 || dimension.height < 10) {
                dimension = new Dimension(dimension);
                dimension.width = Math.max(dimension.width, 10);
                dimension.height = Math.max(dimension.height, 10);
            }
            return dimension;
        }

        public void setTooltip(String string) {
            this.setToolTipText(string);
        }

        public void setIndex(int n) {
            this.index = n;
            this.repaint();
        }

        public boolean isSelected() {
            return this.index == FlatTab.this.getSelectedIndex();
        }

        public void paintComponent(Graphics graphics) {
            Paint paint;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint2 = graphics2D.getPaint();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color color = null;
            Color color2 = null;
            if (this.focused) {
                color = (Color)this.backgroundFocusedTop.value();
                color2 = (Color)this.backgroundFocusedBottom.value();
            }
            if (this.isSelected()) {
                if (color == null) {
                    color = (Color)this.backgroundSelectedTop.value();
                }
                if (color2 == null) {
                    color2 = (Color)this.backgroundSelectedBottom.value();
                }
            }
            if (color == null) {
                color = (Color)this.backgroundTop.value();
            }
            if (color2 == null) {
                color2 = (Color)this.backgroundBottom.value();
            }
            if (color == null || color2 == null) {
                paint = (Color)this.background.value();
                if (paint == null) {
                    paint = this.getBackground();
                }
                if (color2 == null) {
                    color2 = paint;
                }
                if (color == null) {
                    color = this.isSelected() ? paint.brighter() : paint;
                }
            }
            if (color.equals(color2)) {
                graphics.setColor(color);
            } else {
                paint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n2, color2);
                graphics2D.setPaint(paint);
            }
            graphics.fillRect(0, 0, n, n2);
            graphics2D.setPaint(paint2);
            super.paintComponent(graphics);
        }

        private class FlatTabFont
        extends TabFont {
            public FlatTabFont(String string, Dockable dockable) {
                super(string, FlatTab.this.station, dockable);
            }

            protected void changed(FontModifier fontModifier, FontModifier fontModifier2) {
                FlatButton.this.updateFonts();
            }
        }

        private class FlatTabColor
        extends TabColor {
            public FlatTabColor(String string, Dockable dockable) {
                super(string, FlatTab.this.station, dockable, null);
            }

            protected void changed(Color color, Color color2) {
                FlatButton.this.repaint();
            }
        }
    }
}

