/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.rex.tab;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseBorder;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexTabbedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.LineStripPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabStripPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class ShapedGradientPainter
extends BaseTabComponent {
    public static final TabPainter FACTORY = new TabPainter(){

        public TabComponent createTabComponent(DockController dockController, RexTabbedComponent rexTabbedComponent, StackDockStation stackDockStation, Dockable dockable, int n) {
            return new ShapedGradientPainter(dockController, rexTabbedComponent, stackDockStation, dockable, n);
        }

        public TabStripPainter createTabStripPainter(RexTabbedComponent rexTabbedComponent) {
            return new LineStripPainter(rexTabbedComponent);
        }

        public Border getFullBorder(DockController dockController, Dockable dockable) {
            return new EclipseBorder(dockController, true);
        }

        public Border getFullBorder(DockController dockController, DockStation dockStation, RexTabbedComponent rexTabbedComponent) {
            return new EclipseBorder(dockController, true);
        }
    };
    private MatteBorder contentBorder = new MatteBorder(2, 2, 2, 2, Color.BLACK);
    private final int TAB_OVERLAP = 24;

    public ShapedGradientPainter(DockController dockController, RexTabbedComponent rexTabbedComponent, StackDockStation stackDockStation, Dockable dockable, int n) {
        super(rexTabbedComponent, dockController, stackDockStation, dockable, n);
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.getButtons());
    }

    protected void updateBorder() {
        Window window = SwingUtilities.getWindowAncestor(this.getTabbedComponent());
        boolean bl = false;
        if (window != null) {
            boolean bl2 = bl = !window.isActive();
        }
        Color color = this.isSelected() ? (this.isFocused() ? (bl ? (Color)this.colorStackTabBorderSelectedFocusLost.value() : (Color)this.colorStackTabBorderSelectedFocused.value()) : (Color)this.colorStackTabBorderSelected.value()) : (Color)this.colorStackTabBorder.value();
        if (!color.equals(this.contentBorder.getMatteColor())) {
            this.contentBorder = new MatteBorder(2, 2, 2, 2, color);
        }
        if (this.getTabbedComponent() != null) {
            this.getTabbedComponent().updateContentBorder();
        }
    }

    public Border getContentBorder() {
        return this.contentBorder;
    }

    public int getOverlap() {
        if (this.isTabBeforeSelected()) {
            return 34;
        }
        return 0;
    }

    private boolean isTabBeforeSelected() {
        return this.getTabbedComponent().getSelectedIndex() == this.getIndex() - 1;
    }

    public Dimension getPreferredSize() {
        Dockable dockable = this.getDockable();
        boolean bl = this.isSelected();
        ButtonPanel buttonPanel = this.getButtons();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = this.getFont().getStringBounds(dockable.getTitleText(), fontRenderContext);
        int n = 5 + (int)rectangle2D.getWidth() + 5;
        int n2 = 6 + (int)rectangle2D.getHeight();
        if ((this.doPaintIconWhenInactive() || bl) && dockable.getTitleIcon() != null) {
            n += dockable.getTitleIcon().getIconWidth() + 5;
        }
        if (bl) {
            n += 35;
        }
        if (this.isTabBeforeSelected()) {
            n += 24;
        }
        if (buttonPanel != null) {
            Dimension dimension = buttonPanel.getPreferredSize();
            n += dimension.width + 1;
            n2 = Math.max(n2, dimension.height + 1);
        }
        return new Dimension(n, n2);
    }

    public void doLayout() {
        ButtonPanel buttonPanel = this.getButtons();
        if (buttonPanel != null) {
            Dockable dockable = this.getDockable();
            boolean bl = this.isSelected();
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            Rectangle2D rectangle2D = this.getFont().getStringBounds(dockable.getTitleText(), fontRenderContext);
            int n = 5 + (int)rectangle2D.getWidth() + 5;
            if ((this.doPaintIconWhenInactive() || bl) && dockable.getTitleIcon() != null) {
                n += dockable.getTitleIcon().getIconWidth() + 5;
            }
            if (bl) {
                n += 5;
            }
            if (this.isTabBeforeSelected()) {
                n += 24;
            }
            Dimension dimension = buttonPanel.getPreferredSize();
            int n2 = Math.min(dimension.width, this.getWidth() - n);
            int n3 = Math.min(this.getHeight() - 1, dimension.height);
            buttonPanel.setBounds(n, this.getHeight() - 1 - n3, n2 - 1, n3);
        }
    }

    public void update() {
        this.revalidate();
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        Color color;
        Color color2;
        Color color3;
        super.paintComponent(graphics);
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        int n = 0;
        int n2 = 0;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color4 = (Color)this.colorStackBorder.value();
        Window window = SwingUtilities.getWindowAncestor(this.getTabbedComponent());
        boolean bl = false;
        if (window != null) {
            boolean bl2 = bl = !window.isActive();
        }
        if (this.isFocused() && !bl) {
            color3 = (Color)this.colorStackTabTopSelectedFocused.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocused.value();
            color = (Color)this.colorStackTabTextSelectedFocused.value();
        } else if (this.isFocused() && bl) {
            color3 = (Color)this.colorStackTabTopSelectedFocusLost.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocusLost.value();
            color = (Color)this.colorStackTabTextSelectedFocusLost.value();
        } else if (this.isSelected()) {
            color3 = (Color)this.colorStackTabTopSelected.value();
            color2 = (Color)this.colorStackTabBottomSelected.value();
            color = (Color)this.colorStackTabTextSelected.value();
        } else {
            color3 = (Color)this.colorStackTabTop.value();
            color2 = (Color)this.colorStackTabBottom.value();
            color = (Color)this.colorStackTabText.value();
        }
        GradientPaint gradientPaint = color3.equals(color2) ? null : new GradientPaint(n, n2, color3, n, n2 + n4, color2);
        Paint paint = graphics2D.getPaint();
        if (this.isSelected()) {
            graphics.setColor(color4);
            Polygon polygon = this.innerPolygon(n, n2, n3, n4);
            object = this.copyPolygon(polygon);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.getIndex() == 0) {
                ((Polygon)object).translate(-1, 0);
            }
            graphics.fillPolygon((Polygon)object);
            ((Polygon)object).translate(2, 0);
            graphics.fillPolygon((Polygon)object);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (gradientPaint != null) {
                graphics2D.setPaint(gradientPaint);
            } else {
                graphics2D.setPaint(color3);
            }
            if (this.getIndex() != 0) {
                polygon.translate(1, 0);
            }
            graphics.fillPolygon(polygon);
        } else {
            if (gradientPaint != null) {
                graphics2D.setPaint(gradientPaint);
            } else {
                graphics2D.setPaint(color3);
            }
            graphics2D.fillRect(n, n2, n3, n4 - 1);
        }
        graphics2D.setPaint(paint);
        int n5 = 0;
        if (this.isTabBeforeSelected()) {
            n5 += 24;
        }
        if ((this.isSelected() || this.doPaintIconWhenInactive()) && (object = this.getDockable().getTitleIcon()) != null) {
            int n6 = (n4 - object.getIconHeight()) / 2;
            object.paintIcon(this.getTabbedComponent(), graphics, n5 += 5, n6);
            n5 += object.getIconWidth();
        }
        if (!this.isSelected() && this.getIndex() != this.getTabbedComponent().indexOf(this.getTabbedComponent().getSelectedTab()) - 1) {
            graphics.setColor(color4);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4);
        }
        graphics.setColor(color);
        graphics.drawString(this.getDockable().getTitleText(), n + 5 + n5, n4 / 2 + graphics.getFontMetrics().getHeight() / 2 - 2);
    }

    public boolean contains(int n, int n2) {
        if (!super.contains(n, n2)) {
            return false;
        }
        if (this.isSelected()) {
            Polygon polygon = this.innerPolygon(0, 0, this.getWidth(), this.getHeight());
            return polygon.contains(n, n2);
        }
        return true;
    }

    private Polygon innerPolygon(int n, int n2, int n3, int n4) {
        int n5;
        int[] nArray = new int[]{0, 6, 1, 5, 1, 4, 4, 1, 5, 1, 6, 0};
        int n6 = 24;
        int n7 = n6 - 12;
        int[] nArray2 = new int[]{0, 0, 0, 1, 2, 1, 3, 2, 5, 2, 6, 3, 7, 3, 9, 5, 10, 5, 11, 6, 11 + n7, 6 + n7, 12 + n7, 7 + n7, 13 + n7, 7 + n7, 15 + n7, 9 + n7, 16 + n7, 9 + n7, 17 + n7, 10 + n7, 19 + n7, 10 + n7, 20 + n7, 11 + n7, 22 + n7, 11 + n7, 23 + n7, 12 + n7};
        int n8 = Math.min(n + n3 - 20, this.getTabbedComponent().getWidth());
        int n9 = 26 + n7;
        int n10 = n9 / 3;
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        int[] nArray5 = new int[nArray3.length + nArray4.length + 8];
        int n11 = 0;
        int n12 = 23;
        nArray5[n11++] = n;
        nArray5[n11++] = n2 + n12 + 1;
        nArray5[n11++] = n;
        nArray5[n11++] = n2 + n12 + 1;
        for (n5 = 0; n5 < nArray3.length / 2; ++n5) {
            nArray5[n11++] = n + nArray3[2 * n5];
            nArray5[n11++] = n2 + nArray3[2 * n5 + 1];
        }
        for (n5 = 0; n5 < nArray4.length / 2; ++n5) {
            nArray5[n11++] = n8 - n10 + nArray4[2 * n5];
            nArray5[n11++] = n2 + nArray4[2 * n5 + 1];
        }
        nArray5[n11++] = n8 + n9 - n10;
        nArray5[n11++] = n2 + n12 + 1;
        nArray5[n11++] = n8 + n9 - n10;
        nArray5[n11++] = n2 + n12 + 1;
        this.stretch(0, 4, nArray5, (float)n4 / 23.0f);
        this.stretch(4 + nArray3.length, nArray4.length + 4, nArray5, (float)n4 / 23.0f);
        return this.makePolygon(nArray5);
    }

    private void stretch(int n, int n2, int[] nArray, float f) {
        for (int i = n + 1; i < n + n2; i += 2) {
            nArray[i] = Math.round((float)nArray[i] * f);
        }
    }

    private Polygon copyPolygon(Polygon polygon) {
        int[] nArray = new int[polygon.npoints];
        int[] nArray2 = new int[polygon.npoints];
        System.arraycopy(polygon.xpoints, 0, nArray, 0, nArray.length);
        System.arraycopy(polygon.ypoints, 0, nArray2, 0, nArray2.length);
        return new Polygon(nArray, nArray2, nArray.length);
    }

    private Polygon makePolygon(int[] nArray) {
        int[] nArray2 = new int[nArray.length / 2];
        int[] nArray3 = new int[nArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < nArray.length - 1) {
            int n3 = nArray[n];
            int n4 = nArray[n + 1];
            nArray2[n2] = n3;
            nArray3[n2] = n4;
            n += 2;
            ++n2;
        }
        return new Polygon(nArray2, nArray3, nArray2.length);
    }
}

