/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.rex.tab;

import bibliothek.extension.gui.dock.theme.eclipse.RectEclipseBorder;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexTabbedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.LineStripPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabStripPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class RectGradientPainter
extends BaseTabComponent {
    public static final TabPainter FACTORY = new TabPainter(){

        public TabComponent createTabComponent(DockController dockController, RexTabbedComponent rexTabbedComponent, StackDockStation stackDockStation, Dockable dockable, int n) {
            return new RectGradientPainter(rexTabbedComponent, dockController, stackDockStation, dockable, n);
        }

        public TabStripPainter createTabStripPainter(RexTabbedComponent rexTabbedComponent) {
            return new LineStripPainter(rexTabbedComponent);
        }

        public Border getFullBorder(DockController dockController, Dockable dockable) {
            return new RectEclipseBorder(dockController, true);
        }

        public Border getFullBorder(DockController dockController, DockStation dockStation, RexTabbedComponent rexTabbedComponent) {
            return new RectEclipseBorder(dockController, true);
        }
    };
    private MatteBorder contentBorder = new MatteBorder(2, 2, 2, 2, Color.BLACK);

    public RectGradientPainter(RexTabbedComponent rexTabbedComponent, DockController dockController, StackDockStation stackDockStation, Dockable dockable, int n) {
        super(rexTabbedComponent, dockController, stackDockStation, dockable, n);
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.getButtons());
    }

    public int getOverlap() {
        return 0;
    }

    public void update() {
        this.updateBorder();
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dockable dockable = this.getDockable();
        boolean bl = this.isSelected();
        ButtonPanel buttonPanel = this.getButtons();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = this.getFont().getStringBounds(dockable.getTitleText(), fontRenderContext);
        int n = 5 + (int)rectangle2D.getWidth() + 5;
        int n2 = 6 + (int)rectangle2D.getHeight();
        if ((this.doPaintIconWhenInactive() || bl) && dockable.getTitleIcon() != null) {
            n += dockable.getTitleIcon().getIconWidth() + 5;
        }
        if (bl) {
            n += 5;
        }
        if (buttonPanel != null) {
            Dimension dimension = buttonPanel.getPreferredSize();
            n += dimension.width + 1;
            n2 = Math.max(n2, dimension.height + 1);
        }
        return new Dimension(n, n2);
    }

    public void doLayout() {
        ButtonPanel buttonPanel = this.getButtons();
        if (buttonPanel != null) {
            Dockable dockable = this.getDockable();
            boolean bl = this.isSelected();
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            Rectangle2D rectangle2D = this.getFont().getStringBounds(dockable.getTitleText(), fontRenderContext);
            int n = 5 + (int)rectangle2D.getWidth() + 5;
            if ((this.doPaintIconWhenInactive() || bl) && dockable.getTitleIcon() != null) {
                n += dockable.getTitleIcon().getIconWidth() + 5;
            }
            if (bl) {
                n += 5;
            }
            Dimension dimension = buttonPanel.getPreferredSize();
            int n2 = Math.min(dimension.width, this.getWidth() - n);
            int n3 = Math.min(this.getHeight() - 1, dimension.height);
            buttonPanel.setBounds(n, this.getHeight() - 1 - n3, n2 - 1, n3);
        }
    }

    public Border getContentBorder() {
        return this.contentBorder;
    }

    protected void updateBorder() {
        Window window = SwingUtilities.getWindowAncestor(this.getTabbedComponent());
        boolean bl = false;
        if (window != null) {
            boolean bl2 = bl = !window.isActive();
        }
        Color color = this.isSelected() ? (this.isFocused() ? (bl ? (Color)this.colorStackTabBorderSelectedFocusLost.value() : (Color)this.colorStackTabBorderSelectedFocused.value()) : (Color)this.colorStackTabBorderSelected.value()) : (Color)this.colorStackTabBorder.value();
        if (!color.equals(this.contentBorder.getMatteColor())) {
            this.contentBorder = new MatteBorder(2, 2, 2, 2, color);
        }
        if (this.getTabbedComponent() != null) {
            this.getTabbedComponent().updateContentBorder();
        }
    }

    protected void paintComponent(Graphics graphics) {
        Icon icon;
        Color color;
        Color color2;
        Color color3;
        boolean bl;
        super.paintComponent(graphics);
        int n = this.getHeight();
        int n2 = this.getWidth();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color4 = (Color)this.colorStackBorder.value();
        boolean bl2 = bl = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != SwingUtilities.getWindowAncestor(this.getTabbedComponent());
        if (this.isFocused() && !bl) {
            color3 = (Color)this.colorStackTabTopSelectedFocused.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocused.value();
            color = (Color)this.colorStackTabTextSelectedFocused.value();
        } else if (this.isFocused() && bl) {
            color3 = (Color)this.colorStackTabTopSelectedFocusLost.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocusLost.value();
            color = (Color)this.colorStackTabTextSelectedFocusLost.value();
        } else if (this.isSelected()) {
            color3 = (Color)this.colorStackTabTopSelected.value();
            color2 = (Color)this.colorStackTabBottomSelected.value();
            color = (Color)this.colorStackTabTextSelected.value();
        } else {
            color3 = (Color)this.colorStackTabTop.value();
            color2 = (Color)this.colorStackTabBottom.value();
            color = (Color)this.colorStackTabText.value();
        }
        GradientPaint gradientPaint = color3.equals(color2) ? null : new GradientPaint(0.0f, 0.0f, color3, 0.0f, n, color2);
        boolean bl3 = this.isSelected();
        Dockable dockable = this.getDockable();
        int n3 = this.getIndex();
        RexTabbedComponent rexTabbedComponent = this.getTabbedComponent();
        Paint paint = graphics2D.getPaint();
        if (gradientPaint != null) {
            graphics2D.setPaint(gradientPaint);
        } else {
            graphics2D.setPaint(color3);
        }
        if (bl3) {
            graphics.fillRect(1, 0, n2 - 2, n);
            graphics.drawLine(0, 1, 0, n);
            graphics2D.setPaint(paint);
            if (n3 != 0) {
                graphics.drawLine(1, 0, 1, 0);
                graphics.drawLine(0, 1, 0, n);
            }
            graphics.drawLine(n2 - 2, 0, n2 - 2, 0);
            graphics.drawLine(n2 - 1, 1, n2 - 1, n);
        } else {
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            graphics2D.setPaint(paint);
        }
        int n4 = 0;
        if ((bl3 || this.doPaintIconWhenInactive()) && (icon = dockable.getTitleIcon()) != null) {
            icon.paintIcon(rexTabbedComponent, graphics, 5, 4);
            n4 = icon.getIconWidth() + 5;
        }
        if (!bl3 && n3 != rexTabbedComponent.indexOf(rexTabbedComponent.getSelectedTab()) - 1) {
            graphics.setColor(color4);
            graphics.drawLine(n2 - 1, 0, n2 - 1, n);
        }
        graphics.setColor(color);
        graphics.setFont(this.getFont());
        graphics.drawString(dockable.getTitleText(), 5 + n4, n / 2 + graphics.getFontMetrics().getHeight() / 2 - 2);
    }
}

