/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.rex.tab;

import bibliothek.extension.gui.dock.theme.eclipse.rex.RexTabbedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.EclipseDockTitleEvent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.ShapedGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabStripPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class DockTitleTab
implements TabComponent {
    public static final TabPainter FACTORY = DockTitleTab.createFactory(ShapedGradientPainter.FACTORY);
    private DockStation station;
    private Dockable dockable;
    private DockTitle title;
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
    private boolean focused;
    private boolean selected;
    private int index;
    private boolean paintIconWhenInactive;

    public static final TabPainter createFactory(final TabPainter tabPainter) {
        return new TabPainter(){

            public TabComponent createTabComponent(DockController dockController, RexTabbedComponent rexTabbedComponent, StackDockStation stackDockStation, Dockable dockable, int n) {
                DockTitle dockTitle;
                DockTitleVersion dockTitleVersion = dockController.getDockTitleManager().getVersion("eclipse.tab");
                DockTitle dockTitle2 = dockTitle = dockTitleVersion == null ? null : dockable.getDockTitle(dockTitleVersion);
                if (dockTitle == null) {
                    return tabPainter.createTabComponent(dockController, rexTabbedComponent, stackDockStation, dockable, n);
                }
                dockTitle.setOrientation(DockTitle.Orientation.NORTH_SIDED);
                return new DockTitleTab(rexTabbedComponent.getStation(), dockable, dockTitle, n);
            }

            public TabStripPainter createTabStripPainter(RexTabbedComponent rexTabbedComponent) {
                return tabPainter.createTabStripPainter(rexTabbedComponent);
            }

            public Border getFullBorder(DockController dockController, Dockable dockable) {
                return BorderFactory.createLineBorder((Color)dockController.getColors().get("stack.border"));
            }

            public Border getFullBorder(DockController dockController, DockStation dockStation, RexTabbedComponent rexTabbedComponent) {
                return BorderFactory.createLineBorder((Color)dockController.getColors().get("stack.border"));
            }
        };
    }

    public DockTitleTab(DockStation dockStation, Dockable dockable, DockTitle dockTitle, int n) {
        this.station = dockStation;
        this.dockable = dockable;
        this.title = dockTitle;
        this.index = n;
        dockTitle.addMouseInputListener(new MouseInputListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                    mouseListener.mouseClicked(mouseEvent);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                    mouseListener.mouseEntered(mouseEvent);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                    mouseListener.mouseExited(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                    mouseListener.mousePressed(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                    mouseListener.mouseReleased(mouseEvent);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                for (MouseMotionListener mouseMotionListener : DockTitleTab.this.mouseMotionListeners.toArray(new MouseMotionListener[DockTitleTab.this.mouseMotionListeners.size()])) {
                    mouseMotionListener.mouseDragged(mouseEvent);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                for (MouseMotionListener mouseMotionListener : DockTitleTab.this.mouseMotionListeners.toArray(new MouseMotionListener[DockTitleTab.this.mouseMotionListeners.size()])) {
                    mouseMotionListener.mouseMoved(mouseEvent);
                }
            }
        });
    }

    public void bind() {
        this.dockable.bind(this.title);
        this.fire();
    }

    public void unbind() {
        this.dockable.unbind(this.title);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.add(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.add(mouseMotionListener);
    }

    public Component getComponent() {
        return this.title.getComponent();
    }

    public DockElement getElement() {
        return this.title.getElement();
    }

    public boolean isUsedAsTitle() {
        return true;
    }

    public Point getPopupLocation(Point point, boolean bl) {
        return this.title.getPopupLocation(point, bl);
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.title.addMouseInputListener(mouseInputListener);
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.title.removeMouseInputListener(mouseInputListener);
    }

    public Border getContentBorder() {
        return null;
    }

    public int getOverlap() {
        return 0;
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListeners.remove(mouseListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.remove(mouseMotionListener);
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
        this.fire();
    }

    public void setIndex(int n) {
        this.index = n;
        this.fire();
    }

    public void setPaintIconWhenInactive(boolean bl) {
        this.paintIconWhenInactive = bl;
        this.fire();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.fire();
    }

    public void update() {
        this.fire();
    }

    protected void fire() {
        EclipseDockTitleEvent eclipseDockTitleEvent = new EclipseDockTitleEvent(this.station, this.dockable, this.selected, this.focused, this.paintIconWhenInactive, this.index);
        this.title.changed(eclipseDockTitleEvent);
    }
}

