/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.rex.tab;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexTabbedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.AbstractUIValue;
import bibliothek.gui.dock.util.font.AbstractDockFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.DComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public abstract class BaseTabComponent
extends DComponent
implements TabComponent {
    protected final TabColor colorStackTabBorder;
    protected final TabColor colorStackTabBorderSelected;
    protected final TabColor colorStackTabBorderSelectedFocused;
    protected final TabColor colorStackTabBorderSelectedFocusLost;
    protected final TabColor colorStackTabTop;
    protected final TabColor colorStackTabTopSelected;
    protected final TabColor colorStackTabTopSelectedFocused;
    protected final TabColor colorStackTabTopSelectedFocusLost;
    protected final TabColor colorStackTabBottom;
    protected final TabColor colorStackTabBottomSelected;
    protected final TabColor colorStackTabBottomSelectedFocused;
    protected final TabColor colorStackTabBottomSelectedFocusLost;
    protected final TabColor colorStackTabText;
    protected final TabColor colorStackTabTextSelected;
    protected final TabColor colorStackTabTextSelectedFocused;
    protected final TabColor colorStackTabTextSelectedFocusLost;
    protected final TabColor colorStackBorder;
    protected final TabFont fontSelected;
    protected final TabFont fontFocused;
    protected final TabFont fontUnselected;
    private TabColor[] colors;
    private TabFont[] fonts;
    private Dockable dockable;
    private StackDockStation station;
    private DockController controller;
    private boolean paintIconWhenInactive = false;
    private ButtonPanel buttons;
    private Listener dockableListener = new Listener();
    private boolean hasFocus;
    private boolean isSelected;
    private RexTabbedComponent tabbedComponent;
    private int tabIndex;

    public BaseTabComponent(RexTabbedComponent rexTabbedComponent, DockController dockController, StackDockStation stackDockStation, Dockable dockable, int n) {
        this.tabbedComponent = rexTabbedComponent;
        this.dockable = dockable;
        this.station = stackDockStation;
        this.controller = dockController;
        this.tabIndex = n;
        this.colorStackTabBorder = new BorderTabColor("stack.tab.border", Color.WHITE);
        this.colorStackTabBorderSelected = new BorderTabColor("stack.tab.border.selected", Color.WHITE);
        this.colorStackTabBorderSelectedFocused = new BorderTabColor("stack.tab.border.selected.focused", Color.WHITE);
        this.colorStackTabBorderSelectedFocusLost = new BorderTabColor("stack.tab.border.selected.focuslost", Color.WHITE);
        this.colorStackTabTop = new BaseTabColor("stack.tab.top", Color.LIGHT_GRAY);
        this.colorStackTabTopSelected = new BaseTabColor("stack.tab.top.selected", Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocused = new BaseTabColor("stack.tab.top.selected.focused", Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocusLost = new BaseTabColor("stack.tab.top.selected.focuslost", Color.LIGHT_GRAY);
        this.colorStackTabBottom = new BaseTabColor("stack.tab.bottom", Color.WHITE);
        this.colorStackTabBottomSelected = new BaseTabColor("stack.tab.bottom.selected", Color.WHITE);
        this.colorStackTabBottomSelectedFocused = new BaseTabColor("stack.tab.bottom.selected.focused", Color.WHITE);
        this.colorStackTabBottomSelectedFocusLost = new BaseTabColor("stack.tab.bottom.selected.focuslost", Color.WHITE);
        this.colorStackTabText = new BaseTabColor("stack.tab.text", Color.BLACK);
        this.colorStackTabTextSelected = new BaseTabColor("stack.tab.text.selected", Color.BLACK);
        this.colorStackTabTextSelectedFocused = new BaseTabColor("stack.tab.text.selected.focused", Color.BLACK);
        this.colorStackTabTextSelectedFocusLost = new BaseTabColor("stack.tab.text.selected.focuslost", Color.BLACK);
        this.colorStackBorder = new BaseTabColor("stack.border", Color.BLACK);
        this.fontFocused = new BaseTabFont("tab.focused");
        this.fontSelected = new BaseTabFont("tab.selected");
        this.fontUnselected = new BaseTabFont("tab.unselected");
        this.colors = new TabColor[]{this.colorStackTabBorder, this.colorStackTabBorderSelected, this.colorStackTabBorderSelectedFocused, this.colorStackTabBorderSelectedFocusLost, this.colorStackTabTop, this.colorStackTabTopSelected, this.colorStackTabTopSelectedFocused, this.colorStackTabTopSelectedFocusLost, this.colorStackTabBottom, this.colorStackTabBottomSelected, this.colorStackTabBottomSelectedFocused, this.colorStackTabBottomSelectedFocusLost, this.colorStackTabText, this.colorStackTabTextSelected, this.colorStackTabTextSelectedFocused, this.colorStackTabTextSelectedFocusLost, this.colorStackBorder};
        this.fonts = new TabFont[]{this.fontFocused, this.fontSelected, this.fontUnselected};
        this.addHierarchyListener(new WindowActiveObserver());
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.buttons = new ButtonPanel(false);
    }

    protected abstract void updateBorder();

    protected void updateFont() {
        TabFont tabFont = null;
        tabFont = this.isFocused() ? this.fontFocused : (this.isSelected() ? this.fontSelected : this.fontUnselected);
        this.setFontModifier(tabFont.font());
    }

    public void bind() {
        if (this.buttons != null) {
            this.buttons.set(this.dockable, new EclipseDockActionSource(this.tabbedComponent.getTheme(), this.dockable.getGlobalActionOffers(), this.dockable, true));
        }
        this.dockable.addDockableListener(this.dockableListener);
        for (TabColor abstractUIValue : this.colors) {
            abstractUIValue.connect(this.controller);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(this.controller);
        }
        this.setToolTipText(this.dockable.getTitleToolTip());
        this.revalidate();
    }

    public void unbind() {
        if (this.buttons != null) {
            this.buttons.set(null);
        }
        this.dockable.removeDockableListener(this.dockableListener);
        for (TabColor abstractUIValue : this.colors) {
            abstractUIValue.connect(null);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(null);
        }
        this.setToolTipText(null);
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockElement getElement() {
        return this.dockable;
    }

    public boolean isUsedAsTitle() {
        return true;
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.removeMouseListener(mouseInputListener);
        this.removeMouseMotionListener(mouseInputListener);
    }

    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public DockController getController() {
        return this.controller;
    }

    public StackDockStation getStation() {
        return this.station;
    }

    public ButtonPanel getButtons() {
        return this.buttons;
    }

    public RexTabbedComponent getTabbedComponent() {
        return this.tabbedComponent;
    }

    public Component getComponent() {
        return this;
    }

    public void setFocused(boolean bl) {
        this.hasFocus = bl;
        this.updateBorder();
        this.updateFont();
        this.repaint();
    }

    public boolean isFocused() {
        return this.hasFocus;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        this.updateBorder();
        this.updateFont();
        this.revalidate();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setIndex(int n) {
        this.tabIndex = n;
        this.repaint();
    }

    public int getIndex() {
        return this.tabIndex;
    }

    public boolean doPaintIconWhenInactive() {
        return this.paintIconWhenInactive;
    }

    public void setPaintIconWhenInactive(boolean bl) {
        this.paintIconWhenInactive = bl;
        this.revalidate();
        this.repaint();
    }

    private class Listener
    implements DockableListener {
        private Listener() {
        }

        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            BaseTabComponent.this.repaint();
            BaseTabComponent.this.revalidate();
        }

        public void titleTextChanged(Dockable dockable, String string, String string2) {
            BaseTabComponent.this.repaint();
            BaseTabComponent.this.revalidate();
        }

        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            BaseTabComponent.this.setToolTipText(string2);
        }

        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
        }
    }

    private class WindowActiveObserver
    extends WindowAdapter
    implements HierarchyListener {
        private Window window;

        private WindowActiveObserver() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (this.window != null) {
                this.window.removeWindowListener(this);
                this.window = null;
            }
            this.window = SwingUtilities.getWindowAncestor(BaseTabComponent.this);
            if (this.window != null) {
                this.window.addWindowListener(this);
                BaseTabComponent.this.updateBorder();
                BaseTabComponent.this.repaint();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            BaseTabComponent.this.updateBorder();
            BaseTabComponent.this.repaint();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            BaseTabComponent.this.updateBorder();
            BaseTabComponent.this.repaint();
        }
    }

    private class BaseTabFont
    extends TabFont {
        public BaseTabFont(String string) {
            super(string, BaseTabComponent.this.station, BaseTabComponent.this.dockable);
        }

        protected void changed(FontModifier fontModifier, FontModifier fontModifier2) {
            BaseTabComponent.this.updateFont();
        }
    }

    private class BaseTabColor
    extends TabColor {
        public BaseTabColor(String string, Color color) {
            super(string, BaseTabComponent.this.station, BaseTabComponent.this.dockable, color);
        }

        protected void changed(Color color, Color color2) {
            BaseTabComponent.this.repaint();
        }
    }

    private class BorderTabColor
    extends TabColor {
        public BorderTabColor(String string, Color color) {
            super(string, BaseTabComponent.this.station, BaseTabComponent.this.dockable, color);
        }

        protected void changed(Color color, Color color2) {
            BaseTabComponent.this.updateBorder();
        }
    }
}

