/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.rex;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexTabStrip;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.ShapedGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabListener;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabStripPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class RexTabbedComponent
extends JComponent {
    public static final String X_OVERLAY_PROPERTY = "RexTabbedComponent.xOverlay";
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    protected JComponent tabStrip;
    private int selectedTab = -1;
    private int focusedTab = -1;
    private TabPainter tabPainter;
    private TabStripPainter tabStripPainter;
    private List<TabListener> listeners = new LinkedList<TabListener>();
    private List<TabEntry> tabs = new ArrayList<TabEntry>();
    private JComponent contentArea;
    private CardLayout contentLayout;
    private boolean paintIconsWhenInactive = false;
    private DockController controller;
    private EclipseTheme theme;
    private StackDockStation stack;
    private DockStation station;

    public RexTabbedComponent(EclipseTheme eclipseTheme, DockStation dockStation) {
        this.theme = eclipseTheme;
        this.station = dockStation;
        if (dockStation instanceof StackDockStation) {
            this.stack = (StackDockStation)dockStation;
        }
        this.initComponent();
    }

    private void initComponent() {
        this.setTabStrip(new RexTabStrip(this));
        this.contentLayout = new CardLayout();
        this.contentArea = new JPanel(this.contentLayout);
        this.contentArea.setFocusable(false);
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, SystemColor.controlShadow));
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentArea, "Center");
        this.setTabPainter(ShapedGradientPainter.FACTORY);
    }

    protected void bind(TabEntry tabEntry) {
        if (tabEntry.tab != null && !tabEntry.tabBound) {
            tabEntry.tab.bind();
            tabEntry.tabBound = true;
            if (this.controller != null) {
                this.controller.addRepresentative(tabEntry.tab);
            }
        }
    }

    protected void unbind(TabEntry tabEntry) {
        if (tabEntry.tab != null && tabEntry.tabBound) {
            tabEntry.tab.unbind();
            tabEntry.tabBound = false;
            if (this.controller != null) {
                this.controller.removeRepresentative(tabEntry.tab);
            }
        }
    }

    public void setTabStrip(JComponent jComponent) {
        if (this.tabStrip != null) {
            this.remove(this.tabStrip);
            this.tabStrip.removeAll();
        }
        String string = "North";
        this.tabStrip = jComponent;
        this.add((Component)jComponent, string);
        for (TabEntry tabEntry : this.tabs) {
            if (tabEntry.tab == null) continue;
            this.tabStrip.add(tabEntry.tab.getComponent());
        }
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                for (TabEntry tabEntry : this.tabs) {
                    this.controller.removeRepresentative(tabEntry.tab);
                }
            }
            this.controller = dockController;
            if (this.tabStripPainter != null) {
                this.tabStripPainter.setController(dockController);
            }
            this.reinitializeTabs();
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public EclipseTheme getTheme() {
        return this.theme;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void setTabPainter(TabPainter tabPainter) {
        if (this.tabPainter != tabPainter) {
            this.tabPainter = tabPainter;
            if (this.tabStripPainter != null) {
                this.tabStripPainter.setController(null);
                this.tabStripPainter = null;
            }
            if (tabPainter != null) {
                this.tabStripPainter = tabPainter.createTabStripPainter(this);
                if (this.tabStripPainter != null) {
                    this.tabStripPainter.setController(this.controller);
                }
            }
            this.reinitializeTabs();
        }
    }

    protected void reinitializeTabs() {
        this.tabStrip.removeAll();
        for (TabEntry object : this.tabs) {
            TabComponent tabComponent = object.tab;
            if (tabComponent == null) continue;
            tabComponent.removeMouseListener(object.tabMouseListener);
            this.unbind(object);
        }
        if (this.controller != null && this.tabPainter != null) {
            int n = 0;
            for (TabEntry tabEntry : this.tabs) {
                tabEntry.tab = this.tabPainter.createTabComponent(this.controller, this, this.stack, tabEntry.dockable, n);
                tabEntry.tab.addMouseListener(tabEntry.tabMouseListener);
                tabEntry.tab.setPaintIconWhenInactive(this.paintIconsWhenInactive);
                tabEntry.tab.setSelected(n == this.selectedTab);
                tabEntry.tab.setFocused(n == this.focusedTab);
                this.bind(tabEntry);
                this.tabStrip.add(tabEntry.tab.getComponent());
                ++n;
            }
            this.tabStrip.revalidate();
        }
    }

    public TabPainter getTabPainter() {
        return this.tabPainter;
    }

    public TabStripPainter getTabStripPainter() {
        return this.tabStripPainter;
    }

    public void setPaintIconsWhenInactive(boolean bl) {
        this.paintIconsWhenInactive = bl;
        for (TabEntry tabEntry : this.tabs) {
            if (tabEntry.tab == null) continue;
            tabEntry.tab.setPaintIconWhenInactive(bl);
        }
    }

    public void addTab(Dockable dockable) {
        this.insertTab(dockable, this.tabs.size());
        this.setSelectedTab(dockable);
    }

    public void insertTab(Dockable dockable, int n) {
        TabEntry tabEntry = new TabEntry();
        tabEntry.dockable = dockable;
        tabEntry.tabMouseListener = new TabMouseListener(dockable);
        this.tabs.add(n, tabEntry);
        if (this.controller != null) {
            tabEntry.tab = this.tabPainter.createTabComponent(this.controller, this, this.stack, dockable, n);
            tabEntry.tab.addMouseListener(tabEntry.tabMouseListener);
            tabEntry.tab.setPaintIconWhenInactive(this.paintIconsWhenInactive);
            this.bind(tabEntry);
            this.tabStrip.removeAll();
            int n2 = this.tabs.size();
            for (int i = 0; i < n2; ++i) {
                TabComponent tabComponent = this.tabs.get((int)i).tab;
                tabComponent.setIndex(i);
                this.tabStrip.add(tabComponent.getComponent());
            }
        }
        if (this.selectedTab >= n) {
            ++this.selectedTab;
        }
        if (this.focusedTab >= n) {
            ++this.focusedTab;
        }
        this.contentArea.add(dockable.getComponent(), String.valueOf(tabEntry.id));
        this.setSelectedTab(n, true);
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public Dockable getSelectedTab() {
        if (this.selectedTab < 0) {
            return null;
        }
        return this.getTabAt(this.selectedTab);
    }

    public TabComponent getTabComponent(int n) {
        return this.tabs.get((int)n).tab;
    }

    public int indexOf(Dockable dockable) {
        int n = this.tabs.size();
        for (int i = 0; i < n; ++i) {
            if (this.tabs.get((int)i).dockable != dockable) continue;
            return i;
        }
        return -1;
    }

    public void removeTab(int n) {
        int n2;
        Dockable dockable = this.getTabAt(n);
        int n3 = this.selectedTab;
        this.selectedTab = -1;
        TabEntry tabEntry = this.tabs.get(n);
        this.tabs.remove(n);
        if (tabEntry.tab != null) {
            this.tabStrip.remove(tabEntry.tab.getComponent());
            this.unbind(tabEntry);
            tabEntry.tab.removeMouseListener(tabEntry.tabMouseListener);
        }
        int n4 = this.tabs.size();
        for (n2 = n; n2 < n4; ++n2) {
            TabComponent object = this.tabs.get((int)n2).tab;
            if (object == null) continue;
            object.setIndex(n2);
        }
        n2 = n < n3 ? n3 - 1 : (n == n3 ? (n == this.tabs.size() ? n - 1 : n) : n3);
        n3 = -1;
        this.contentLayout.show(this.contentArea, String.valueOf(tabEntry.id));
        this.contentArea.remove(tabEntry.dockable.getComponent());
        if (n < this.focusedTab) {
            --this.focusedTab;
        } else if (n == this.focusedTab) {
            this.focusedTab = -1;
        }
        for (TabListener tabListener : this.listeners) {
            tabListener.tabRemoved(dockable);
        }
        this.setSelectedTab(n2, true);
    }

    public void removeTab(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n >= 0) {
            this.removeTab(n);
        }
    }

    public void removeAllTabs() {
        this.selectedTab = -1;
        this.focusedTab = -1;
        this.contentArea.removeAll();
        for (TabEntry tabEntry : this.tabs) {
            this.contentLayout.removeLayoutComponent(tabEntry.dockable.getComponent());
            tabEntry.dockable.getComponent().setVisible(true);
            for (TabListener tabListener : this.listeners) {
                tabListener.tabRemoved(tabEntry.dockable);
                if (tabEntry.tab == null) continue;
                this.unbind(tabEntry);
                tabEntry.tab.removeMouseListener(tabEntry.tabMouseListener);
            }
        }
        this.tabStrip.removeAll();
        this.tabs.clear();
    }

    public JComponent getContentArea() {
        return this.contentArea;
    }

    public Insets getContentInsets() {
        Insets insets;
        Insets insets2 = new Insets(0, 0, 0, 0);
        Dimension dimension = this.tabStrip.getPreferredSize();
        if (dimension != null) {
            insets2.top += dimension.height;
        }
        if ((insets = this.contentArea.getInsets()) != null) {
            insets2.left += insets.left;
            insets2.right += insets.right;
            insets2.top += insets.top;
            insets2.bottom += insets.bottom;
        }
        if ((insets = this.getInsets()) != null) {
            insets2.left += insets.left;
            insets2.right += insets.right;
            insets2.top += insets.top;
            insets2.bottom += insets.bottom;
        }
        return insets2;
    }

    public void addTabListener(TabListener tabListener) {
        this.listeners.add(tabListener);
    }

    public void removeTabListener(TabListener tabListener) {
        this.listeners.remove(tabListener);
    }

    public int getSelectedIndex() {
        return this.selectedTab;
    }

    public void setSelectedTab(int n) {
        this.setSelectedTab(n, false);
    }

    private void setSelectedTab(int n, boolean bl) {
        if (bl || n != this.selectedTab) {
            Dockable dockable;
            TabComponent tabComponent;
            if (!bl && this.selectedTab >= 0 && this.selectedTab < this.tabs.size() && (tabComponent = this.tabs.get((int)this.selectedTab).tab) != null) {
                tabComponent.setSelected(false);
            }
            this.selectedTab = n;
            if (!bl && this.selectedTab >= 0 && this.selectedTab < this.tabs.size() && (tabComponent = this.tabs.get((int)this.selectedTab).tab) != null) {
                tabComponent.setSelected(true);
            }
            if (bl) {
                int n2 = 0;
                for (TabEntry object : this.tabs) {
                    if (object.tab != null) {
                        object.tab.setSelected(n == n2);
                    }
                    ++n2;
                }
            }
            if (n >= 0 && n < this.tabs.size()) {
                TabEntry tabEntry = this.tabs.get(n);
                dockable = tabEntry.dockable;
                this.contentLayout.show(this.contentArea, String.valueOf(tabEntry.id));
            } else {
                dockable = null;
            }
            for (TabListener tabListener : this.listeners) {
                tabListener.tabChanged(dockable);
            }
        }
    }

    public void setFocusedTab(Dockable dockable) {
        this.focusedTab = this.indexOf(dockable);
        for (TabEntry tabEntry : this.tabs) {
            if (tabEntry.tab == null) continue;
            tabEntry.tab.setFocused(tabEntry.dockable == dockable);
        }
    }

    public void setSelectedTab(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n >= 0) {
            this.setSelectedTab(n);
        }
    }

    public Dockable getTabAt(int n) {
        return this.tabs.get((int)n).dockable;
    }

    public Rectangle getBoundsAt(int n) {
        return this.getBounds(this.getTabAt(n));
    }

    public Rectangle getBounds(Dockable dockable) {
        TabComponent tabComponent = this.tabs.get((int)this.indexOf((Dockable)dockable)).tab;
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(tabComponent.getComponent(), point, this);
        return new Rectangle(point, tabComponent.getComponent().getSize());
    }

    public void updateContentBorder() {
        if (this.selectedTab >= 0 && this.selectedTab < this.tabs.size()) {
            TabEntry tabEntry = this.tabs.get(this.selectedTab);
            if (tabEntry.tab == null) {
                this.contentArea.setBorder(null);
            } else {
                this.contentArea.setBorder(tabEntry.tab.getContentBorder());
            }
        } else {
            this.contentArea.setBorder(null);
        }
    }

    protected void popup(Dockable dockable, MouseEvent mouseEvent) {
        JComponent jComponent;
        JPopupMenu jPopupMenu;
        Component component;
        if (!mouseEvent.isConsumed() && mouseEvent.isPopupTrigger() && (component = dockable.getComponent()) instanceof JComponent && (jPopupMenu = (jComponent = (JComponent)component).getComponentPopupMenu()) != null) {
            Point point = jComponent.getPopupLocation(mouseEvent);
            if (point == null) {
                point = mouseEvent.getPoint();
            }
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private int nextFreeId() {
        int n = 0;
        boolean bl = false;
        do {
            bl = false;
            int n2 = this.tabs.size();
            for (int i = 0; i < n2; ++i) {
                if (this.tabs.get((int)i).id != n) continue;
                ++n;
                bl = true;
            }
        } while (bl);
        return n;
    }

    private class TabMouseListener
    extends MouseAdapter {
        private Dockable dockable;

        public TabMouseListener(Dockable dockable) {
            this.dockable = dockable;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            RexTabbedComponent.this.setSelectedTab(this.dockable);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            RexTabbedComponent.this.popup(this.dockable, mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            RexTabbedComponent.this.popup(this.dockable, mouseEvent);
        }
    }

    private class TabEntry {
        public Dockable dockable;
        public DockTitle title;
        public TabComponent tab;
        public boolean tabBound = false;
        public TabMouseListener tabMouseListener;
        public int id;

        public TabEntry() {
            this.id = RexTabbedComponent.this.nextFreeId();
        }
    }
}

