/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.rex;

import bibliothek.gui.DockUI;
import java.awt.Color;
import java.awt.SystemColor;

public class RexSystemColor {
    private RexSystemColor() {
    }

    public static Color getActiveColor() {
        return RexSystemColor.decide("dock.title.selection.background.[brighter]", SystemColor.activeCaption.brighter());
    }

    public static Color getActiveColorGradient() {
        return RexSystemColor.decide("dock.title.selection.background", SystemColor.activeCaption);
    }

    public static Color getInactiveColor() {
        return RexSystemColor.decide("dock.title.background.[darker]", SystemColor.inactiveCaption.darker());
    }

    public static Color getInactiveColorGradient() {
        return RexSystemColor.decide("dock.background", SystemColor.inactiveCaption);
    }

    public static Color getActiveTextColor() {
        return RexSystemColor.decide("dock.title.selection.foreground", SystemColor.activeCaptionText);
    }

    public static Color getInactiveTextColor() {
        return RexSystemColor.decide("dock.title.foreground", SystemColor.inactiveCaptionText);
    }

    public static Color getBorderColor() {
        return RexSystemColor.decide("dock.control.shadow", SystemColor.controlShadow);
    }

    private static Color decide(String string, Color color) {
        Color color2;
        boolean bl = string.endsWith("[brighter]");
        boolean bl2 = string.endsWith("[darker]");
        if (bl || bl2) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        if ((color2 = DockUI.getDefaultDockUI().getColors().getColor(string)) == null) {
            return color;
        }
        if (bl) {
            color2 = color2.brighter();
        }
        if (bl2) {
            color2 = color2.darker();
        }
        return color2;
    }
}

