/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundRectDropDownButton
extends JComponent {
    private BasicDropDownButtonModel model;
    private BasicDropDownButtonHandler handler;
    private Icon dropIcon;
    private Icon disabledDropIcon;

    public RoundRectDropDownButton(BasicDropDownButtonHandler basicDropDownButtonHandler) {
        this.handler = basicDropDownButtonHandler;
        this.model = new BasicDropDownButtonModel(this, basicDropDownButtonHandler, true){

            protected boolean inDropDownArea(int n, int n2) {
                return RoundRectDropDownButton.this.inDropDownArea(n, n2);
            }

            public void changed() {
                RoundRectDropDownButton.this.revalidate();
                super.changed();
            }
        };
        this.setOpaque(false);
        this.dropIcon = this.createDropIcon();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                RoundRectDropDownButton.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                RoundRectDropDownButton.this.repaint();
            }
        });
    }

    public BasicDropDownButtonModel getModel() {
        return this.model;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.model.getMaxIconSize();
        int n = Math.max(dimension.width + 4, 10);
        int n2 = Math.max(dimension.height + 4, 10);
        if (this.model.getOrientation().isHorizontal()) {
            return new Dimension(n + 6 + this.dropIcon.getIconWidth(), n2);
        }
        return new Dimension(n, n2 + 6 + this.dropIcon.getIconHeight());
    }

    protected void paintComponent(Graphics graphics) {
        Icon icon;
        Icon icon2 = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = DockUtilities.disabledIcon(this, this.dropIcon);
            }
            icon2 = this.disabledDropIcon;
        }
        Color color = this.getBackground();
        Color color2 = null;
        if (this.model.isMousePressed()) {
            color2 = Colors.diffMirror(color, 0.3);
            color = Colors.undiffMirror(color, 0.8);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            color2 = Colors.diffMirror(color, 0.3);
            color = Colors.undiffMirror(color, 0.4);
        }
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        if (color2 != null) {
            graphics.setColor(color);
            graphics.fillRoundRect(0, 0, n, n2, 4, 4);
            graphics.setColor(color2);
            graphics.drawRoundRect(0, 0, n, n2, 4, 4);
            if (this.model.isMouseOverDropDown()) {
                int n3;
                if (this.model.getOrientation().isHorizontal()) {
                    n3 = n - icon2.getIconWidth() - 5;
                    graphics.drawLine(n3, 0, n3, n2);
                } else {
                    n3 = n2 - icon2.getIconHeight() - 5;
                    graphics.drawLine(0, n3, n, n3);
                }
            }
        }
        if ((icon = this.model.getPaintIcon()) != null) {
            if (this.model.getOrientation().isHorizontal()) {
                icon.paintIcon(this, graphics, (n - 3 - icon2.getIconWidth() + 1 - icon.getIconWidth()) / 2, (n2 + 1 - icon.getIconHeight()) / 2);
            } else {
                icon.paintIcon(this, graphics, (n + 1 - icon.getIconWidth()) / 2, (n2 - 3 - icon2.getIconHeight() + 1 - icon.getIconHeight()) / 2);
            }
        }
        if (this.model.getOrientation().isHorizontal()) {
            icon2.paintIcon(this, graphics, n - icon2.getIconWidth() - 2, (n2 - icon2.getIconHeight()) / 2);
        } else {
            icon2.paintIcon(this, graphics, (n - icon2.getIconWidth()) / 2, n2 - icon2.getIconHeight() - 2);
        }
        if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            graphics.setColor(Colors.diffMirror(color, 0.4));
            graphics.drawLine(2, 3, 2, 4);
            graphics.drawLine(3, 2, 4, 2);
            graphics.drawLine(n - 2, 3, n - 2, 4);
            graphics.drawLine(n - 3, 2, n - 4, 2);
            graphics.drawLine(2, n2 - 3, 2, n2 - 4);
            graphics.drawLine(3, n2 - 2, 4, n2 - 2);
            graphics.drawLine(n - 2, n2 - 3, n - 2, n2 - 4);
            graphics.drawLine(n - 3, n2 - 2, n - 4, n2 - 2);
        }
    }

    public boolean inDropDownArea(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        if (this.model.getOrientation().isHorizontal()) {
            return n >= this.getWidth() - this.dropIcon.getIconWidth() - 5;
        }
        return n2 >= this.getHeight() - this.dropIcon.getIconHeight() - 5;
    }

    public void updateUI() {
        this.disabledDropIcon = null;
        super.updateUI();
        if (this.handler != null) {
            this.handler.updateUI();
        }
    }

    protected Icon createDropIcon() {
        return new Icon(){

            public int getIconHeight() {
                return 7;
            }

            public int getIconWidth() {
                return 7;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.setColor(RoundRectDropDownButton.this.getForeground());
                graphics.drawLine(++n, n2 + 1, n + 4, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 3, n2 + 2);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            }
        };
    }
}

