/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundRectButton
extends JComponent {
    private BasicButtonModel model;

    public RoundRectButton(BasicTrigger basicTrigger) {
        this.model = new BasicButtonModel(this, basicTrigger, true);
        this.setOpaque(false);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                RoundRectButton.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                RoundRectButton.this.repaint();
            }
        });
    }

    public BasicButtonModel getModel() {
        return this.model;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.model.getMaxIconSize();
        dimension.width = Math.max(10, dimension.width + 4);
        dimension.height = Math.max(10, dimension.height + 4);
        return dimension;
    }

    protected void paintComponent(Graphics graphics) {
        Icon icon;
        Color color = this.getBackground();
        Color color2 = null;
        if (this.model.isMousePressed()) {
            color2 = Colors.diffMirror(color, 0.3);
            color = Colors.undiffMirror(color, 0.6);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            color2 = Colors.diffMirror(color, 0.3);
            color = Colors.undiffMirror(color, 0.3);
        }
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        if (color2 != null) {
            graphics.setColor(color);
            graphics.fillRoundRect(0, 0, n, n2, 4, 4);
            graphics.setColor(color2);
            graphics.drawRoundRect(0, 0, n, n2, 4, 4);
        }
        if ((icon = this.model.getPaintIcon()) != null) {
            icon.paintIcon(this, graphics, (n + 1 - icon.getIconWidth()) / 2, (n2 + 1 - icon.getIconHeight()) / 2);
        }
        if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            graphics.setColor(Colors.diffMirror(color, 0.4));
            graphics.drawLine(2, 3, 2, 4);
            graphics.drawLine(3, 2, 4, 2);
            graphics.drawLine(n - 2, 3, n - 2, 4);
            graphics.drawLine(n - 3, 2, n - 4, 2);
            graphics.drawLine(2, n2 - 3, 2, n2 - 4);
            graphics.drawLine(3, n2 - 2, 4, n2 - 2);
            graphics.drawLine(n - 2, n2 - 3, n - 2, n2 - 4);
            graphics.drawLine(n - 3, n2 - 2, n - 4, n2 - 2);
        }
    }
}

