/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;

public class NoTitleDisplayer
extends JPanel
implements DockableDisplayer {
    private Dockable dockable;
    private DockController controller;
    private DockStation station;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private PropertyValue<TabPainter> painter;
    private boolean defaultBorderHint;
    private Boolean borderHint;
    private DockableDisplayerHints hints;

    public NoTitleDisplayer(DockStation dockStation, Dockable dockable, boolean bl, boolean bl2) {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.setOpaque(false);
        if (bl2) {
            this.hints = new DockableDisplayerHints(){

                public void setShowBorderHint(Boolean bl) {
                    NoTitleDisplayer.this.borderHint = bl;
                    NoTitleDisplayer.this.updateFullBorder();
                }
            };
        }
        this.setStation(dockStation);
        this.setDockable(dockable);
        this.setBorder(null);
        this.defaultBorderHint = bl;
        if (bl || bl2) {
            this.painter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

                @Override
                protected void valueChanged(TabPainter tabPainter, TabPainter tabPainter2) {
                    NoTitleDisplayer.this.updateFullBorder();
                }
            };
            this.updateFullBorder();
        }
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    protected boolean getBorderHint() {
        if (this.borderHint != null) {
            return this.borderHint;
        }
        return this.defaultBorderHint;
    }

    protected void updateFullBorder() {
        if (this.painter != null) {
            TabPainter tabPainter = this.painter.getValue();
            if (this.controller == null || tabPainter == null || this.dockable == null) {
                this.setBorder(null);
            } else if (this.hints == null || this.getBorderHint()) {
                this.setBorder(tabPainter.getFullBorder(this.controller, this.dockable));
            } else {
                this.setBorder(null);
            }
        }
    }

    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            return new Insets(0, 0, 0, 0);
        }
        return insets;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintBorder(graphics);
    }

    public Component getComponent() {
        return this;
    }

    public DockController getController() {
        return this.controller;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockStation getStation() {
        return this.station;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void setController(DockController dockController) {
        this.controller = dockController;
        if (this.painter != null) {
            this.painter.setProperties(dockController == null ? null : dockController.getProperties());
        }
        this.updateFullBorder();
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.configureDisplayerHints(null);
        }
        this.dockable = dockable;
        this.removeAll();
        if (dockable != null) {
            this.add(dockable.getComponent());
            dockable.configureDisplayerHints(this.hints);
        }
        this.updateFullBorder();
    }

    public void setStation(DockStation dockStation) {
        this.station = dockStation;
    }

    public void setTitle(DockTitle dockTitle) {
        this.title = dockTitle;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
    }

    public boolean titleContains(int n, int n2) {
        return false;
    }
}

