/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexTabbedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.ShapedGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabStripLayoutManager;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabStripPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionPopup;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EclipseTabbedComponent
extends RexTabbedComponent {
    private ButtonPanel itemPanel;
    private PropertyValue<TabPainter> painter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

        @Override
        protected void valueChanged(TabPainter tabPainter, TabPainter tabPainter2) {
            EclipseTabbedComponent.this.updateFullBorder();
        }
    };

    public EclipseTabbedComponent(EclipseTheme eclipseTheme, DockStation dockStation) {
        super(eclipseTheme, dockStation);
        this.itemPanel = new ButtonPanel(true);
        this.itemPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 4));
        this.itemPanel.setOpaque(false);
        this.setTabStrip(new EclipseTabStrip());
        this.setTabPainter(ShapedGradientPainter.FACTORY);
        this.updateFullBorder();
        this.setFocusable(false);
    }

    public JComponent getTabStrip() {
        return this.tabStrip;
    }

    public void set(Dockable dockable, DockActionSource dockActionSource) {
        this.itemPanel.set(dockable, dockActionSource);
    }

    public ButtonPanel getItemPanel() {
        return this.itemPanel;
    }

    public void setController(DockController dockController) {
        super.setController(dockController);
        this.painter.setProperties(dockController == null ? null : dockController.getProperties());
        this.updateFullBorder();
    }

    protected void updateFullBorder() {
        if (this.painter != null) {
            TabPainter tabPainter = this.painter.getValue();
            DockController dockController = this.getController();
            DockStation dockStation = this.getStation();
            if (dockController == null || dockStation == null || tabPainter == null) {
                this.setBorder(null);
            } else {
                this.setBorder(tabPainter.getFullBorder(dockController, dockStation, this));
            }
        }
    }

    protected void popup(final Dockable dockable, MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && mouseEvent.isPopupTrigger()) {
            ActionPopup actionPopup = new ActionPopup(true){

                protected Dockable getDockable() {
                    return dockable;
                }

                protected DockActionSource getSource() {
                    return this.getDockable().getGlobalActionOffers();
                }

                protected boolean isEnabled() {
                    return true;
                }
            };
            actionPopup.popup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintBorder(graphics);
    }

    private class EclipseTabStrip
    extends JPanel {
        private JPanel strip;

        public EclipseTabStrip() {
            this.setLayout(null);
            this.setFocusable(false);
            this.setOpaque(false);
            this.strip = new JPanel(new TabStripLayoutManager(EclipseTabbedComponent.this));
            this.strip.setOpaque(false);
            this.addImpl(this.strip, null, -1);
            this.addImpl(EclipseTabbedComponent.this.itemPanel, null, -1);
            this.setComponentZOrder(EclipseTabbedComponent.this.itemPanel, 0);
            this.setComponentZOrder(this.strip, 1);
        }

        public void removeAll() {
            this.strip.removeAll();
        }

        public Component add(Component component) {
            return this.strip.add(component);
        }

        public void remove(Component component) {
            this.strip.remove(component);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            TabStripPainter tabStripPainter = EclipseTabbedComponent.this.getTabStripPainter();
            if (tabStripPainter != null) {
                tabStripPainter.paintTabStrip(this, graphics);
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.strip.getPreferredSize();
            Dimension dimension2 = EclipseTabbedComponent.this.itemPanel.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width, Math.max(dimension.height, dimension2.height));
        }

        public void doLayout() {
            int n;
            Dimension dimension = this.strip.getPreferredSize();
            Dimension[] dimensionArray = EclipseTabbedComponent.this.itemPanel.getPreferredSizes();
            int n2 = 0;
            n2 = dimension.width + dimensionArray[0].width <= this.getWidth() ? dimension.width : Math.max(this.getWidth() / 2, this.getWidth() - dimensionArray[0].width);
            int n3 = this.getWidth() - n2;
            for (n = dimensionArray.length - 1; n > 0 && dimensionArray[n].width > n3; --n) {
            }
            int n4 = Math.min(n3, dimensionArray[n].width);
            this.strip.setBounds(0, 0, this.getWidth(), this.getHeight());
            EclipseTabbedComponent.this.itemPanel.setVisibleActions(n);
            EclipseTabbedComponent.this.itemPanel.setBounds(this.getWidth() - n4, 0, n4, this.getHeight());
        }
    }
}

