/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseFocusTraversalPolicy;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabbedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.ShapedGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabListener;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EclipseStackDockComponent
extends JPanel
implements StackDockComponent,
TabListener {
    private List<Dockable> dockables = new ArrayList<Dockable>();
    private DockController controller;
    private FocusListener controllerFocusListener = new FocusListener();
    private RemoteRelocator relocator;
    private EclipseTheme theme;
    private EclipseTabbedComponent tabs;
    private Dockable selectedDockable;
    private PropertyValue<Boolean> paintIconsWhenDeselected = new PropertyValue<Boolean>(EclipseTheme.PAINT_ICONS_WHEN_DESELECTED){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            EclipseStackDockComponent.this.tabs.setPaintIconsWhenInactive(Boolean.TRUE.equals(bl2));
        }
    };
    private PropertyValue<TabPainter> tabPainter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

        @Override
        protected void valueChanged(TabPainter tabPainter, TabPainter tabPainter2) {
            if (tabPainter2 == null) {
                tabPainter2 = ShapedGradientPainter.FACTORY;
            }
            if (EclipseStackDockComponent.this.tabs.getTabPainter() != tabPainter2) {
                EclipseStackDockComponent.this.tabs.setTabPainter(tabPainter2);
            }
        }
    };

    public EclipseStackDockComponent(EclipseTheme eclipseTheme, DockStation dockStation) {
        this.theme = eclipseTheme;
        this.setLayout(new GridLayout(1, 1));
        this.tabs = new EclipseTabbedComponent(eclipseTheme, dockStation);
        this.tabs.addTabListener(this);
        this.tabs.setAlignmentX(1.0f);
        this.tabs.setAlignmentY(0.0f);
        this.add(this.tabs);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new EclipseFocusTraversalPolicy(this), true));
    }

    public EclipseTabbedComponent getTabs() {
        return this.tabs;
    }

    public void removeAll() {
        this.tabs.removeAllTabs();
        this.dockables.clear();
    }

    public void remove(int n) {
        Dockable dockable = this.tabs.getTabAt(n);
        this.tabs.removeTab(dockable);
    }

    public void tabRemoved(Dockable dockable) {
    }

    public void tabChanged(Dockable dockable) {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
        this.updateActions();
    }

    private void updateActions() {
        Dockable dockable = this.tabs.getSelectedTab();
        if (dockable != this.selectedDockable) {
            if (this.selectedDockable != null) {
                this.tabs.set(null, null);
            }
            this.selectedDockable = dockable;
            if (dockable != null) {
                this.tabs.set(dockable, new EclipseDockActionSource(this.theme, dockable.getGlobalActionOffers(), dockable, false));
            }
        }
    }

    private void updateFocus() {
        if (this.controller != null) {
            this.tabs.setFocusedTab(this.controller.getFocusedDockable());
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public int getSelectedIndex() {
        return this.tabs.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.tabs.setSelectedTab(n);
    }

    public Rectangle getBoundsAt(int n) {
        return this.tabs.getBoundsAt(n);
    }

    public void addTab(String string, Icon icon, Component component, Dockable dockable) {
        this.insertTab(string, icon, component, dockable, this.getTabCount());
        this.tabs.setSelectedTab(this.getTabCount() - 1);
    }

    public void insertTab(String string, Icon icon, Component component, Dockable dockable, int n) {
        this.tabs.insertTab(dockable, n);
        this.dockables.add(n, dockable);
        this.updateFocus();
    }

    public Dockable getDockable(int n) {
        return this.dockables.get(n);
    }

    public int getTabCount() {
        return this.tabs.getTabCount();
    }

    public void setTitleAt(int n, String string) {
    }

    public void setIconAt(int n, Icon icon) {
    }

    public void setTooltipAt(int n, String string) {
    }

    public Component getComponent() {
        return this;
    }

    public boolean hasBorder() {
        return true;
    }

    public DockController getController() {
        return this.controller;
    }

    public void setController(DockController dockController) {
        if (this.tabs != null) {
            this.tabs.setController(dockController);
        }
        if (this.controller != dockController) {
            if (this.relocator != null) {
                this.relocator.cancel();
                this.relocator = null;
            }
            if (this.controller != null) {
                this.controller.removeDockableFocusListener(this.controllerFocusListener);
            }
            this.controller = dockController;
            if (dockController != null) {
                dockController.addDockableFocusListener(this.controllerFocusListener);
            }
            this.paintIconsWhenDeselected.setProperties(dockController);
            this.tabPainter.setProperties(dockController);
            this.updateFocus();
            this.updateActions();
        }
    }

    private class FocusListener
    implements DockableFocusListener {
        private FocusListener() {
        }

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            EclipseStackDockComponent.this.updateFocus();
        }
    }
}

