/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseStackDockComponent;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class EclipseDockableDisplayer
extends EclipseStackDockComponent
implements DockableDisplayer {
    private DockStation station;
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;

    public EclipseDockableDisplayer(EclipseTheme eclipseTheme, DockStation dockStation, Dockable dockable) {
        super(eclipseTheme, dockStation);
        this.station = dockStation;
        this.setDockable(dockable);
        this.setFocusCycleRoot(true);
    }

    public Dimension getMinimumSize() {
        if (this.dockable == null) {
            return new Dimension(10, 10);
        }
        return this.dockable.getComponent().getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.dockable == null) {
            return new Dimension(10, 10);
        }
        return this.dockable.getComponent().getMinimumSize();
    }

    public void setDockable(Dockable dockable) {
        if (this.getDockable() != null) {
            this.removeAll();
        }
        this.dockable = dockable;
        if (dockable != null) {
            this.addTab(dockable.getTitleText(), dockable.getTitleIcon(), dockable.getComponent(), dockable);
        }
        this.revalidate();
    }

    public boolean titleContains(int n, int n2) {
        Point point = new Point(n, n2);
        point = SwingUtilities.convertPoint(this, point, this);
        int n3 = this.getTabCount();
        for (int i = 0; i < n3; ++i) {
            Rectangle rectangle = this.getBoundsAt(i);
            if (!rectangle.contains(point)) continue;
            return true;
        }
        return false;
    }

    public Insets getDockableInsets() {
        return this.getTabs().getContentInsets();
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockStation getStation() {
        return this.station;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void setStation(DockStation dockStation) {
        this.station = dockStation;
    }

    public void setTitle(DockTitle dockTitle) {
        this.title = dockTitle;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
    }
}

