/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseDockTitleFactory
implements DockTitleFactory {
    private EclipseTheme theme;
    private DockTitleFactory factory;

    public EclipseDockTitleFactory(EclipseTheme eclipseTheme, DockTitleFactory dockTitleFactory) {
        if (eclipseTheme == null) {
            throw new IllegalArgumentException("theme must not be null");
        }
        if (dockTitleFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.theme = eclipseTheme;
        this.factory = dockTitleFactory;
    }

    @Override
    public DockTitle createDockableTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        EclipseThemeConnector.TitleBar titleBar = this.theme.getThemeConnector(dockTitleVersion.getController()).getTitleBarKind(dockable);
        if (titleBar == EclipseThemeConnector.TitleBar.BASIC || titleBar == EclipseThemeConnector.TitleBar.BASIC_BORDERED) {
            return this.factory.createDockableTitle(dockable, dockTitleVersion);
        }
        return null;
    }

    @Override
    public <D extends Dockable & DockStation> DockTitle createStationTitle(D d, DockTitleVersion dockTitleVersion) {
        EclipseThemeConnector.TitleBar titleBar = this.theme.getThemeConnector(dockTitleVersion.getController()).getTitleBarKind(d);
        if (titleBar == EclipseThemeConnector.TitleBar.BASIC || titleBar == EclipseThemeConnector.TitleBar.BASIC_BORDERED) {
            return this.factory.createStationTitle(d, dockTitleVersion);
        }
        return null;
    }
}

