/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockableDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.NoTitleDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexSystemColor;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDisplayerFactory;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;

public class EclipseDisplayerFactory
extends BasicDisplayerFactory {
    private EclipseTheme theme;

    public EclipseDisplayerFactory(EclipseTheme eclipseTheme) {
        this.theme = eclipseTheme;
    }

    public DockableDisplayer create(DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        EclipseThemeConnector.TitleBar titleBar = this.theme.getThemeConnector(dockStation.getController()).getTitleBarKind(dockable);
        switch (titleBar) {
            case NONE: {
                return new NoTitleDisplayer(dockStation, dockable, false, false);
            }
            case NONE_BORDERED: {
                return new NoTitleDisplayer(dockStation, dockable, true, false);
            }
            case NONE_HINTED: {
                return new NoTitleDisplayer(dockStation, dockable, false, true);
            }
            case NONE_HINTED_BORDERED: {
                return new NoTitleDisplayer(dockStation, dockable, true, true);
            }
            case ECLIPSE: {
                return new EclipseDockableDisplayer(this.theme, dockStation, dockable);
            }
            case BASIC_BORDERED: {
                DockableDisplayer dockableDisplayer = super.create(dockStation, dockable, dockTitle);
                if (dockableDisplayer.getComponent() instanceof JComponent) {
                    ((JComponent)dockableDisplayer.getComponent()).setBorder(new LineBorder(RexSystemColor.getBorderColor()));
                }
                return dockableDisplayer;
            }
        }
        DockableDisplayer dockableDisplayer = super.create(dockStation, dockable, dockTitle);
        if (dockableDisplayer.getComponent() instanceof JComponent) {
            ((JComponent)dockableDisplayer.getComponent()).setBorder(null);
        }
        return dockableDisplayer;
    }

    protected BasicDockableDisplayer create(Dockable dockable, DockTitle dockTitle, DockableDisplayer.Location location) {
        return new BasicDockableDisplayer(dockable, dockTitle, location){

            public void updateUI() {
                super.updateUI();
                this.setBorder(new LineBorder(RexSystemColor.getBorderColor()));
            }
        };
    }
}

