/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.CombinedStackDockComponent;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.DLabel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BubbleStackDockComponent
extends CombinedStackDockComponent<Tab> {
    private int arc = 6;
    private int borderSize = 3;
    private Insets insets = new Insets(this.borderSize, this.borderSize, 0, this.borderSize);
    private StackDockStation station;

    public BubbleStackDockComponent(StackDockStation stackDockStation) {
        this.station = stackDockStation;
    }

    @Override
    protected Tab createTab(Dockable dockable) {
        Tab tab = new Tab(dockable);
        this.addChangeListener(tab);
        return tab;
    }

    @Override
    protected void destroy(Tab tab) {
        this.removeChangeListener(tab);
        tab.setController(null);
        tab.animation.stop();
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            ((Tab)this.getTab(i)).setController(dockController);
        }
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    protected class Tab
    extends JPanel
    implements CombinedTab,
    ChangeListener,
    Runnable,
    DockableFocusListener {
        private int index = 0;
        private DLabel label = new DLabel();
        private BubbleColorAnimation animation;
        private boolean mouse = false;
        private boolean focused = false;
        private Dockable dockable;
        private DockController controller;
        private BubbleTabColor topMouse;
        private BubbleTabColor bottomMouse;
        private BubbleTabColor borderMouse;
        private BubbleTabColor textMouse;
        private BubbleTabColor top;
        private BubbleTabColor bottom;
        private BubbleTabColor border;
        private BubbleTabColor text;
        private BubbleTabColor topSelectedMouse;
        private BubbleTabColor bottomSelectedMouse;
        private BubbleTabColor borderSelectedMouse;
        private BubbleTabColor textSelectedMouse;
        private BubbleTabColor topSelected;
        private BubbleTabColor bottomSelected;
        private BubbleTabColor borderSelected;
        private BubbleTabColor textSelected;
        private BubbleTabColor topFocusedMouse;
        private BubbleTabColor bottomFocusedMouse;
        private BubbleTabColor borderFocusedMouse;
        private BubbleTabColor textFocusedMouse;
        private BubbleTabColor topFocused;
        private BubbleTabColor bottomFocused;
        private BubbleTabColor borderFocused;
        private BubbleTabColor textFocused;
        private BubbleTabColor[] colors;
        private BubbleTabFont fontFocused;
        private BubbleTabFont fontSelected;
        private BubbleTabFont fontUnselected;
        private static final int STATE_SELECTED = 1;
        private static final int STATE_FOCUSED = 3;
        private static final int STATE_MOUSE = 4;
        private int state = 0;

        public Tab(Dockable dockable) {
            this.dockable = dockable;
            this.animation = new BubbleColorAnimation();
            this.animation.addTask(this);
            this.topMouse = new BubbleTabColor(this, 4, "stack.tab.background.top.mouse", "top", this.animation, dockable, Color.RED.brighter());
            this.bottomMouse = new BubbleTabColor(this, 4, "stack.tab.background.bottom.mouse", "bottom", this.animation, dockable, Color.RED.darker());
            this.borderMouse = new BubbleTabColor(this, 4, "stack.tab.border.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
            this.textMouse = new BubbleTabColor(this, 4, "stack.tab.foreground.mouse", "text", this.animation, dockable, Color.BLACK);
            this.top = new BubbleTabColor(this, 0, "stack.tab.background.top", "top", this.animation, dockable, Color.RED.brighter());
            this.bottom = new BubbleTabColor(this, 0, "stack.tab.background.bottom", "bottom", this.animation, dockable, Color.RED.darker());
            this.border = new BubbleTabColor(this, 0, "stack.tab.border", "border", this.animation, dockable, Color.RED.darker().darker());
            this.text = new BubbleTabColor(this, 0, "stack.tab.foreground", "text", this.animation, dockable, Color.BLACK);
            this.topSelectedMouse = new BubbleTabColor(this, 5, "stack.tab.background.top.selected.mouse", "top", this.animation, dockable, Color.RED.brighter());
            this.bottomSelectedMouse = new BubbleTabColor(this, 5, "stack.tab.background.bottom.selected.mouse", "bottom", this.animation, dockable, Color.RED.darker());
            this.borderSelectedMouse = new BubbleTabColor(this, 5, "stack.tab.border.selected.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
            this.textSelectedMouse = new BubbleTabColor(this, 5, "stack.tab.foreground.selected.mouse", "text", this.animation, dockable, Color.BLACK);
            this.topSelected = new BubbleTabColor(this, 1, "stack.tab.background.top.selected", "top", this.animation, dockable, Color.RED.brighter());
            this.bottomSelected = new BubbleTabColor(this, 1, "stack.tab.background.bottom.selected", "bottom", this.animation, dockable, Color.RED.darker());
            this.borderSelected = new BubbleTabColor(this, 1, "stack.tab.border.selected", "border", this.animation, dockable, Color.RED.darker().darker());
            this.textSelected = new BubbleTabColor(this, 1, "stack.tab.foreground.selected", "text", this.animation, dockable, Color.BLACK);
            this.topFocusedMouse = new BubbleTabColor(this, 7, "stack.tab.background.top.focused.mouse", "top", this.animation, dockable, Color.RED.brighter());
            this.bottomFocusedMouse = new BubbleTabColor(this, 7, "stack.tab.background.bottom.focused.mouse", "bottom", this.animation, dockable, Color.RED.darker());
            this.borderFocusedMouse = new BubbleTabColor(this, 7, "stack.tab.border.focused.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
            this.textFocusedMouse = new BubbleTabColor(this, 7, "stack.tab.foreground.focused.mouse", "text", this.animation, dockable, Color.BLACK);
            this.topFocused = new BubbleTabColor(this, 3, "stack.tab.background.top.focused", "top", this.animation, dockable, Color.RED.brighter());
            this.bottomFocused = new BubbleTabColor(this, 3, "stack.tab.background.bottom.focused", "bottom", this.animation, dockable, Color.RED.darker());
            this.borderFocused = new BubbleTabColor(this, 3, "stack.tab.border.focused", "border", this.animation, dockable, Color.RED.darker().darker());
            this.textFocused = new BubbleTabColor(this, 3, "stack.tab.foreground.focused", "text", this.animation, dockable, Color.BLACK);
            this.colors = new BubbleTabColor[]{this.top, this.bottom, this.border, this.text, this.topMouse, this.bottomMouse, this.borderMouse, this.textMouse, this.topSelected, this.bottomSelected, this.borderSelected, this.textSelected, this.topSelectedMouse, this.bottomSelectedMouse, this.borderSelectedMouse, this.textSelectedMouse, this.topFocused, this.bottomFocused, this.borderFocused, this.textFocused, this.topFocusedMouse, this.bottomFocusedMouse, this.borderFocusedMouse, this.textFocusedMouse};
            this.fontFocused = new BubbleTabFont(this, "tab.focused", dockable);
            this.fontSelected = new BubbleTabFont(this, "tab.selected", dockable);
            this.fontUnselected = new BubbleTabFont(this, "tab.unselected", dockable);
            this.setController(BubbleStackDockComponent.this.getController());
            this.checkAnimation();
            this.setOpaque(false);
            this.add(this.label);
            this.setLayout(null);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    BubbleStackDockComponent.this.setSelectedIndex(Tab.this.index);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    Tab.this.mouse = true;
                    Tab.this.checkAnimation();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    Tab.this.mouse = false;
                    Tab.this.checkAnimation();
                }
            };
            this.addMouseListener(mouseAdapter);
            this.label.addMouseListener(mouseAdapter);
        }

        public Point getPopupLocation(Point point, boolean bl) {
            if (bl) {
                return point;
            }
            return null;
        }

        public void setTooltip(String string) {
            this.setToolTipText(string);
            this.label.setToolTipText(string);
        }

        public int getState() {
            return this.state;
        }

        public void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.removeDockableFocusListener(this);
            }
            for (BubbleTabColor bubbleTabColor : this.colors) {
                bubbleTabColor.connect(dockController);
            }
            this.fontFocused.connect(dockController);
            this.fontSelected.connect(dockController);
            this.fontUnselected.connect(dockController);
            this.controller = dockController;
            if (dockController != null) {
                dockController.addDockableFocusListener(this);
                this.focused = dockController.getFocusedDockable() == this.dockable;
            }
            this.checkAnimation();
            this.animation.kick();
        }

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            boolean bl = this.focused;
            boolean bl2 = this.focused = this.dockable == dockableFocusEvent.getNewFocusOwner();
            if (bl != this.focused) {
                this.checkAnimation();
            }
        }

        public void run() {
            this.label.setForeground(this.animation.getColor("text"));
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.label.getPreferredSize();
            return new Dimension(dimension.width + 2 * BubbleStackDockComponent.this.borderSize + ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.left + ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.right, dimension.height + BubbleStackDockComponent.this.arc + ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.top + ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.bottom);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            this.label.setBounds(BubbleStackDockComponent.this.borderSize + ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.left, ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.top, this.getWidth() - BubbleStackDockComponent.this.borderSize - ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.left - ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.right, this.getHeight() - BubbleStackDockComponent.this.arc - ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.top - ((BubbleStackDockComponent)BubbleStackDockComponent.this).insets.bottom);
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.animation.getColor("bottom");
            Color color2 = this.animation.getColor("top");
            Color color3 = this.animation.getColor("border");
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(color3);
            graphics2D.fillRoundRect(0, -BubbleStackDockComponent.this.arc, n, n2 + BubbleStackDockComponent.this.arc, 2 * BubbleStackDockComponent.this.arc, 2 * BubbleStackDockComponent.this.arc);
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, 0.0f, n2 - BubbleStackDockComponent.this.borderSize, color));
            graphics2D.fillRoundRect(BubbleStackDockComponent.this.borderSize, -BubbleStackDockComponent.this.arc, n - 2 * BubbleStackDockComponent.this.borderSize, n2 + BubbleStackDockComponent.this.arc - BubbleStackDockComponent.this.borderSize, 2 * BubbleStackDockComponent.this.arc, 2 * BubbleStackDockComponent.this.arc);
            Graphics graphics2 = graphics.create(this.label.getX(), this.label.getY(), this.label.getWidth(), this.label.getHeight());
            this.label.update(graphics2);
            graphics2.dispose();
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, n2 / 2, Color.WHITE));
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
            graphics2D.fillRect(0, 0, n, n2 / 2);
            graphics2D.dispose();
        }

        protected void paintChildren(Graphics graphics) {
        }

        public JComponent getComponent() {
            return this;
        }

        public DockElement getElement() {
            return this.dockable;
        }

        public boolean isUsedAsTitle() {
            return false;
        }

        public void addMouseInputListener(MouseInputListener mouseInputListener) {
            this.addMouseListener(mouseInputListener);
            this.addMouseMotionListener(mouseInputListener);
            this.label.addMouseListener(mouseInputListener);
            this.label.addMouseMotionListener(mouseInputListener);
        }

        public void removeMouseInputListener(MouseInputListener mouseInputListener) {
            this.removeMouseListener(mouseInputListener);
            this.removeMouseMotionListener(mouseInputListener);
            this.label.removeMouseListener(mouseInputListener);
            this.label.removeMouseMotionListener(mouseInputListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.checkAnimation();
        }

        public void setIndex(int n) {
            this.index = n;
            this.checkAnimation();
        }

        private void checkAnimation() {
            this.state = 0;
            if (BubbleStackDockComponent.this.getSelectedIndex() == this.index) {
                this.state |= 1;
            }
            if (this.mouse) {
                this.state |= 4;
            }
            if (this.focused) {
                this.state |= 3;
            }
            for (BubbleTabColor bubbleTabColor : this.colors) {
                bubbleTabColor.transmit();
            }
            this.updateFonts();
        }

        public void updateFonts() {
            if (this.focused) {
                this.label.setFontModifier((FontModifier)this.fontFocused.value());
            } else if (BubbleStackDockComponent.this.getSelectedIndex() == this.index) {
                this.label.setFontModifier((FontModifier)this.fontSelected.value());
            } else {
                this.label.setFontModifier((FontModifier)this.fontUnselected.value());
            }
        }

        public void setIcon(Icon icon) {
            this.label.setIcon(icon);
        }

        public void setText(String string) {
            this.label.setText(string);
        }
    }

    protected class BubbleTabFont
    extends TabFont {
        private Tab tab;

        public BubbleTabFont(Tab tab, String string, Dockable dockable) {
            super(string, BubbleStackDockComponent.this.station, dockable);
            this.tab = tab;
        }

        protected void changed(FontModifier fontModifier, FontModifier fontModifier2) {
            this.tab.updateFonts();
        }
    }

    protected class BubbleTabColor
    extends TabColor {
        private Tab tab;
        private int state;
        private String animationId;
        private BubbleColorAnimation animation;

        public BubbleTabColor(Tab tab, int n, String string, String string2, BubbleColorAnimation bubbleColorAnimation, Dockable dockable, Color color) {
            super(string, BubbleStackDockComponent.this.station, dockable, color);
            this.tab = tab;
            this.state = n;
            this.animationId = string2;
            this.animation = bubbleColorAnimation;
        }

        public void transmit() {
            if (this.tab.getState() == this.state) {
                this.animation.putColor(this.animationId, (Color)this.value());
            }
        }

        protected void changed(Color color, Color color2) {
            if (this.tab.getState() == this.state) {
                this.animation.putColor(this.animationId, color2);
            }
        }
    }
}

