/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.AbstractBubbleDockTitle;
import bibliothek.extension.gui.dock.util.Path;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Condition;
import java.awt.Color;

public class BubbleDockTitle
extends AbstractBubbleDockTitle {
    public BubbleDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this(dockable, dockTitleVersion, true);
    }

    public BubbleDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        this.init(dockable, dockTitleVersion, bl);
    }

    protected BubbleDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        super.init(dockable, dockTitleVersion, bl);
        this.initAnimation();
        this.updateAnimation();
    }

    private void initAnimation() {
        Path path = TitleColor.KIND_TITLE_COLOR;
        this.addColor("title.background.top.active.mouse", path, Color.RED);
        this.addColor("title.background.top.active", path, Color.LIGHT_GRAY);
        this.addColor("title.background.top.inactive.mouse", path, Color.BLUE);
        this.addColor("title.background.top.inactive", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.active.mouse", path, Color.LIGHT_GRAY);
        this.addColor("title.background.bottom.active", path, Color.WHITE);
        this.addColor("title.background.bottom.inactive.mouse", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.inactive", path, Color.BLACK);
        this.addColor("title.foreground.active.mouse", path, Color.BLACK);
        this.addColor("title.foreground.active", path, Color.BLACK);
        this.addColor("title.foreground.inactive.mouse", path, Color.WHITE);
        this.addColor("title.foreground.inactive", path, Color.WHITE);
        this.addConditionalFont("title.active", TitleFont.KIND_TITLE_FONT, new Condition(){

            public boolean getState() {
                return BubbleDockTitle.this.isActive();
            }
        }, null);
        this.addConditionalFont("title.inactive", TitleFont.KIND_TITLE_FONT, new Condition(){

            public boolean getState() {
                return !BubbleDockTitle.this.isActive();
            }
        }, null);
    }

    protected void updateAnimation() {
        this.updateFonts();
        String string = "";
        string = this.isActive() ? (this.isMouseOver() ? "active.mouse" : "active") : (this.isMouseOver() ? "inactive.mouse" : "inactive");
        String string2 = "title.background.top." + string;
        String string3 = "title.background.bottom." + string;
        String string4 = "title.foreground." + string;
        this.updateAnimation("text", string4);
        this.updateAnimation("top", string2);
        this.updateAnimation("top", string3);
    }
}

