/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.extension.gui.dock.theme.flat.FlatButtonTitle;
import bibliothek.extension.gui.dock.theme.flat.FlatColorScheme;
import bibliothek.extension.gui.dock.theme.flat.FlatDisplayerFactory;
import bibliothek.extension.gui.dock.theme.flat.FlatStationPaint;
import bibliothek.extension.gui.dock.theme.flat.FlatTab;
import bibliothek.extension.gui.dock.theme.flat.FlatTitleFactory;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.dockable.ScreencaptureMovingImageFactory;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.basic.action.buttons.BasicMiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.DropDownMiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButton;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThemeProperties(nameBundle="theme.flat", descriptionBundle="theme.flat.description", authors={"Benjamin Sigg"}, webpages={})
public class FlatTheme
extends BasicTheme {
    protected DisplayerFactory splitDisplayFactory = new FlatDisplayerFactory(true);
    public static final PropertyKey<ColorScheme> FLAT_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.FlatTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> propertyKey, DockProperties dockProperties) {
            return new FlatColorScheme();
        }
    }, true);

    public FlatTheme() {
        this.setColorSchemeKey(FLAT_COLOR_SCHEME);
        this.setPaint(new FlatStationPaint());
        this.setTitleFactory(new FlatTitleFactory());
        this.setDisplayerFactory(new FlatDisplayerFactory(false));
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            public StackDockComponent create(StackDockStation stackDockStation) {
                return new FlatTab(stackDockStation);
            }
        });
        this.setMovingImageFactory(new ScreencaptureMovingImageFactory(new Dimension(300, 200)));
    }

    @Override
    public void install(DockController dockController) {
        super.install(dockController);
        dockController.getDockTitleManager().registerTheme("flap button", new DockTitleFactory(){

            @Override
            public DockTitle createDockableTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
                return new FlatButtonTitle(dockable, dockTitleVersion);
            }

            @Override
            public <D extends Dockable & DockStation> DockTitle createStationTitle(D d, DockTitleVersion dockTitleVersion) {
                return new FlatButtonTitle(d, dockTitleVersion);
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                BasicButtonHandler basicButtonHandler = new BasicButtonHandler(buttonDockAction, dockable);
                MiniButton<BasicButtonModel> miniButton = FlatTheme.this.createTitleMiniButton(basicButtonHandler);
                basicButtonHandler.setModel(miniButton.getModel());
                return basicButtonHandler;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                BasicSelectableHandler.Check check = new BasicSelectableHandler.Check(selectableDockAction, dockable);
                MiniButton<BasicButtonModel> miniButton = FlatTheme.this.createTitleMiniButton(check);
                check.setModel(miniButton.getModel());
                return check;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
                BasicMenuHandler basicMenuHandler = new BasicMenuHandler(menuDockAction, dockable);
                MiniButton<BasicButtonModel> miniButton = FlatTheme.this.createTitleMiniButton(basicMenuHandler);
                basicMenuHandler.setModel(miniButton.getModel());
                return basicMenuHandler;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                BasicSelectableHandler.Radio radio = new BasicSelectableHandler.Radio(selectableDockAction, dockable);
                MiniButton<BasicButtonModel> miniButton = FlatTheme.this.createTitleMiniButton(radio);
                radio.setModel(miniButton.getModel());
                return radio;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, DropDownAction dropDownAction, Dockable dockable) {
                BasicDropDownButtonHandler basicDropDownButtonHandler = new BasicDropDownButtonHandler(dropDownAction, dockable);
                DropDownMiniButton dropDownMiniButton = new DropDownMiniButton(basicDropDownButtonHandler);
                basicDropDownButtonHandler.setModel((BasicDropDownButtonModel)dropDownMiniButton.getModel());
                dropDownMiniButton.setMouseOverBorder(BorderFactory.createEtchedBorder());
                return basicDropDownButtonHandler;
            }
        });
    }

    protected MiniButton<BasicButtonModel> createTitleMiniButton(BasicTrigger basicTrigger) {
        BasicMiniButton basicMiniButton = new BasicMiniButton(basicTrigger);
        basicMiniButton.setMouseOverBorder(BorderFactory.createEtchedBorder());
        basicMiniButton.setNormalSelectedBorder(BorderFactory.createEtchedBorder());
        return basicMiniButton;
    }

    @Override
    public void uninstall(DockController dockController) {
        super.uninstall(dockController);
        dockController.getDockTitleManager().clearThemeFactories();
        dockController.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, null);
    }

    @Override
    protected void updateColors() {
        DockController dockController = this.getController();
        if (dockController != null && this.getColorScheme() != null) {
            dockController.getColors().lockUpdate();
            super.updateColors();
            this.updateColor("title.active.left", null);
            this.updateColor("title.inactive.left", null);
            this.updateColor("title.active.right", null);
            this.updateColor("title.inactive.right", null);
            this.updateColor("title.active.text", null);
            this.updateColor("title.inactive.text", null);
            this.updateColor("paint.line", null);
            this.updateColor("paint.divider", null);
            this.updateColor("paint.insertion.area", null);
            this.updateColor("paint.insertion.border", null);
            this.updateColor("stack.tab.border.out.selected", null);
            this.updateColor("stack.tab.border.center.selected", null);
            this.updateColor("stack.tab.border.out.focused", null);
            this.updateColor("stack.tab.border.center.focused", null);
            this.updateColor("stack.tab.border.out", null);
            this.updateColor("stack.tab.border.center", null);
            this.updateColor("stack.tab.border", null);
            this.updateColor("stack.tab.background.top.selected", null);
            this.updateColor("stack.tab.background.bottom.selected", null);
            this.updateColor("stack.tab.background.top.focused", null);
            this.updateColor("stack.tab.background.bottom.focused", null);
            this.updateColor("stack.tab.background.top", null);
            this.updateColor("stack.tab.background.bottom", null);
            this.updateColor("stack.tab.background", null);
            this.updateColor("stack.tab.foreground", null);
            this.updateColor("stack.tab.foreground.selected", null);
            dockController.getColors().unlockUpdate();
        } else {
            super.updateColors();
        }
    }

    public void setSplitDisplayFactory(DisplayerFactory displayerFactory) {
        this.splitDisplayFactory = displayerFactory;
    }

    public DisplayerFactory getSplitDisplayFactory() {
        return this.splitDisplayFactory;
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        if (dockStation instanceof SplitDockStation) {
            return this.splitDisplayFactory;
        }
        return super.getDisplayFactory(dockStation);
    }
}

