/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.extension.gui.dock.theme.eclipse.DefaultEclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseColorScheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDisplayerFactory;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockTitleFactory;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockableSelection;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseStackDockComponent;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseStationPaint;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.RoundRectButton;
import bibliothek.extension.gui.dock.theme.eclipse.RoundRectDropDownButton;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.BasicTabDockTitle;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.ShapedGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.rex.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.flat.FlatButtonTitle;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.nostack.NoStackAcceptance;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleManager;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;

@ThemeProperties(authors={"Janni Kovacs", "Benjamin Sigg"}, descriptionBundle="theme.eclipse.description", nameBundle="theme.eclipse", webpages={""})
public class EclipseTheme
extends BasicTheme {
    public static final PropertyKey<Boolean> PAINT_ICONS_WHEN_DESELECTED = new PropertyKey<Boolean>("EclipseTheme paint icons when deselected", new ConstantPropertyFactory<Boolean>(false), true);
    public static final PropertyKey<TabPainter> TAB_PAINTER = new PropertyKey<TabPainter>("EclipseTheme tab painter", new ConstantPropertyFactory<TabPainter>(ShapedGradientPainter.FACTORY), true);
    public static final PropertyKey<EclipseThemeConnector> THEME_CONNECTOR = new PropertyKey<DefaultEclipseThemeConnector>("EclipseTheme theme connector", new ConstantPropertyFactory<DefaultEclipseThemeConnector>(new DefaultEclipseThemeConnector()), true);
    public static final PropertyKey<ColorScheme> ECLIPSE_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.EclipseTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> propertyKey, DockProperties dockProperties) {
            return new EclipseColorScheme();
        }
    }, true);
    public static final String TAB_DOCK_TITLE = "eclipse.tab";
    private DockAcceptance acceptance = new NoStackAcceptance();

    public EclipseTheme() {
        this.setColorSchemeKey(ECLIPSE_COLOR_SCHEME);
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            public StackDockComponent create(StackDockStation stackDockStation) {
                return new EclipseStackDockComponent(EclipseTheme.this, stackDockStation);
            }
        });
        this.setDisplayerFactory(new EclipseDisplayerFactory(this));
        this.setPaint(new EclipseStationPaint());
        this.setMovingImageFactory(new DockableMovingImageFactory(){

            public MovingImage create(DockController dockController, Dockable dockable) {
                return null;
            }

            public MovingImage create(DockController dockController, DockTitle dockTitle) {
                return null;
            }
        });
        this.setTitleFactory(new BasicDockTitleFactory(){

            @Override
            public <D extends Dockable & DockStation> DockTitle createStationTitle(D d, DockTitleVersion dockTitleVersion) {
                return this.createDockableTitle(d, dockTitleVersion);
            }
        });
        this.setDockableSelection(new EclipseDockableSelection());
    }

    public void install(DockController dockController) {
        DockTitleManager dockTitleManager = dockController.getDockTitleManager();
        dockTitleManager.registerTheme(TAB_DOCK_TITLE, BasicTabDockTitle.createFactory(this));
        super.install(dockController);
        Map<String, Icon> map = DockUtilities.loadIcons("data/eclipse/icons.ini", null, EclipseTheme.class.getClassLoader());
        for (Map.Entry<String, Icon> entry : map.entrySet()) {
            dockController.getIcons().setIconTheme(entry.getKey(), entry.getValue());
        }
        EclipseDockTitleFactory eclipseDockTitleFactory = new EclipseDockTitleFactory(this, new ControllerTitleFactory());
        dockTitleManager.registerTheme("split", eclipseDockTitleFactory);
        dockTitleManager.registerTheme("flap window", eclipseDockTitleFactory);
        dockTitleManager.registerTheme("screen dock", eclipseDockTitleFactory);
        dockTitleManager.registerTheme("stack", eclipseDockTitleFactory);
        dockController.addAcceptance(this.acceptance);
        dockTitleManager.registerTheme("flap button", new DockTitleFactory(){

            @Override
            public DockTitle createDockableTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
                return new FlatButtonTitle(dockable, dockTitleVersion);
            }

            @Override
            public <D extends Dockable & DockStation> DockTitle createStationTitle(D d, DockTitleVersion dockTitleVersion) {
                return new FlatButtonTitle(d, dockTitleVersion);
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                BasicButtonHandler basicButtonHandler = new BasicButtonHandler(buttonDockAction, dockable);
                RoundRectButton roundRectButton = new RoundRectButton(basicButtonHandler);
                basicButtonHandler.setModel(roundRectButton.getModel());
                return basicButtonHandler;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                BasicSelectableHandler.Check check = new BasicSelectableHandler.Check(selectableDockAction, dockable);
                RoundRectButton roundRectButton = new RoundRectButton(check);
                check.setModel(roundRectButton.getModel());
                return check;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
                BasicMenuHandler basicMenuHandler = new BasicMenuHandler(menuDockAction, dockable);
                RoundRectButton roundRectButton = new RoundRectButton(basicMenuHandler);
                basicMenuHandler.setModel(roundRectButton.getModel());
                return basicMenuHandler;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                BasicSelectableHandler.Radio radio = new BasicSelectableHandler.Radio(selectableDockAction, dockable);
                RoundRectButton roundRectButton = new RoundRectButton(radio);
                radio.setModel(roundRectButton.getModel());
                return radio;
            }
        });
        dockController.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, DropDownAction dropDownAction, Dockable dockable) {
                BasicDropDownButtonHandler basicDropDownButtonHandler = new BasicDropDownButtonHandler(dropDownAction, dockable);
                RoundRectDropDownButton roundRectDropDownButton = new RoundRectDropDownButton(basicDropDownButtonHandler);
                basicDropDownButtonHandler.setModel(roundRectDropDownButton.getModel());
                return basicDropDownButtonHandler;
            }
        });
    }

    protected void updateColors() {
        DockController dockController = this.getController();
        if (dockController != null && this.getColorScheme() != null) {
            dockController.getColors().lockUpdate();
            super.updateColors();
            this.updateColor("stack.tab.border", null);
            this.updateColor("stack.tab.border.selected", null);
            this.updateColor("stack.tab.border.selected.focused", null);
            this.updateColor("stack.tab.border.selected.focuslost", null);
            this.updateColor("stack.tab.top", null);
            this.updateColor("stack.tab.top.selected", null);
            this.updateColor("stack.tab.top.selected.focused", null);
            this.updateColor("stack.tab.top.selected.focuslost", null);
            this.updateColor("stack.tab.bottom", null);
            this.updateColor("stack.tab.bottom.selected", null);
            this.updateColor("stack.tab.bottom.selected.focused", null);
            this.updateColor("stack.tab.bottom.selected.focuslost", null);
            this.updateColor("stack.tab.text", null);
            this.updateColor("stack.tab.text.selected", null);
            this.updateColor("stack.tab.text.selected.focused", null);
            this.updateColor("stack.tab.text.selected.focuslost", null);
            this.updateColor("stack.border", null);
            this.updateColor("selection.border", null);
            dockController.getColors().unlockUpdate();
        } else {
            super.updateColors();
        }
    }

    public void uninstall(DockController dockController) {
        super.uninstall(dockController);
        dockController.getIcons().clearThemeIcons();
        dockController.getDockTitleManager().clearThemeFactories();
        dockController.removeAcceptance(this.acceptance);
        dockController.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, null);
        dockController.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, null);
    }

    public EclipseThemeConnector getThemeConnector(DockController dockController) {
        EclipseThemeConnector eclipseThemeConnector = null;
        if (dockController != null) {
            eclipseThemeConnector = dockController.getProperties().get(THEME_CONNECTOR);
        }
        if (eclipseThemeConnector == null) {
            eclipseThemeConnector = THEME_CONNECTOR.getDefault(null);
        }
        return eclipseThemeConnector;
    }
}

