/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.extension.gui.dock.theme.bubble.BubbleButtonDockTitle;
import bibliothek.extension.gui.dock.theme.bubble.BubbleColorScheme;
import bibliothek.extension.gui.dock.theme.bubble.BubbleDisplayerFactory;
import bibliothek.extension.gui.dock.theme.bubble.BubbleDockTitleFactory;
import bibliothek.extension.gui.dock.theme.bubble.BubbleMovingImageFactory;
import bibliothek.extension.gui.dock.theme.bubble.BubbleSeparator;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStackDockComponent;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStationPaint;
import bibliothek.extension.gui.dock.theme.bubble.RoundButton;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonViewItem;
import bibliothek.extension.gui.dock.theme.bubble.RoundDropDownButton;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;

@ThemeProperties(authors={"Ivan Seidl", "Benjamin Sigg"}, descriptionBundle="theme.bubble.description", nameBundle="theme.bubble", webpages={""})
public class BubbleTheme
extends BasicTheme {
    public static final PropertyKey<ColorScheme> BUBBLE_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.BubbleTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> propertyKey, DockProperties dockProperties) {
            return new BubbleColorScheme();
        }
    }, true);
    private Map<String, Color> colors = new HashMap<String, Color>();
    private List<DockController> controllers = new ArrayList<DockController>();

    public BubbleTheme() {
        this.setColorSchemeKey(BUBBLE_COLOR_SCHEME);
        this.setDisplayerFactory(new BubbleDisplayerFactory());
        this.setTitleFactory(new BubbleDockTitleFactory());
        this.setPaint(new BubbleStationPaint());
        this.setMovingImageFactory(new BubbleMovingImageFactory());
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            public StackDockComponent create(StackDockStation stackDockStation) {
                return new BubbleStackDockComponent(stackDockStation);
            }
        });
    }

    public Color getColor(String string) {
        return this.colors.get(string);
    }

    public void setColor(String string, Color color) {
        this.colors.put(string, color);
    }

    public void install(DockController dockController) {
        super.install(dockController);
        this.controllers.add(dockController);
        dockController.getDockTitleManager().registerTheme("flap button", BubbleButtonDockTitle.FACTORY);
        Map<String, Icon> map = DockUtilities.loadIcons("data/bubble/icons.ini", null, BubbleTheme.class.getClassLoader());
        for (Map.Entry<String, Icon> entry : map.entrySet()) {
            dockController.getIcons().setIconTheme(entry.getKey(), entry.getValue());
        }
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(ActionType.BUTTON, ViewTarget.TITLE, new ButtonGenerator());
        actionViewConverter.putTheme(ActionType.CHECK, ViewTarget.TITLE, new CheckGenerator());
        actionViewConverter.putTheme(ActionType.RADIO, ViewTarget.TITLE, new RadioGenerator());
        actionViewConverter.putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, new DropDownGenerator());
        actionViewConverter.putTheme(ActionType.MENU, ViewTarget.TITLE, new MenuGenerator());
        actionViewConverter.putTheme(ActionType.SEPARATOR, ViewTarget.TITLE, new SeparatorGenerator());
    }

    public void uninstall(DockController dockController) {
        super.uninstall(dockController);
        this.controllers.remove(dockController);
        dockController.getDockTitleManager().clearThemeFactories();
        dockController.getIcons().clearThemeIcons();
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(ActionType.BUTTON, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(ActionType.CHECK, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(ActionType.RADIO, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(ActionType.MENU, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(ActionType.SEPARATOR, ViewTarget.TITLE, null);
    }

    protected void updateColors() {
        DockController dockController = this.getController();
        if (dockController != null && this.getColorScheme() != null) {
            dockController.getColors().lockUpdate();
            super.updateColors();
            this.updateColor("tab.border.active", null);
            this.updateColor("stack.tab.background.top.mouse", null);
            this.updateColor("stack.tab.background.bottom.mouse", null);
            this.updateColor("stack.tab.border.mouse", null);
            this.updateColor("stack.tab.foreground.mouse", null);
            this.updateColor("stack.tab.background.top", null);
            this.updateColor("stack.tab.background.bottom", null);
            this.updateColor("stack.tab.border", null);
            this.updateColor("stack.tab.foreground", null);
            this.updateColor("stack.tab.background.top.selected.mouse", null);
            this.updateColor("stack.tab.background.bottom.selected.mouse", null);
            this.updateColor("stack.tab.border.selected.mouse", null);
            this.updateColor("stack.tab.foreground.selected.mouse", null);
            this.updateColor("stack.tab.background.top.selected", null);
            this.updateColor("stack.tab.background.bottom.selected", null);
            this.updateColor("stack.tab.border.selected", null);
            this.updateColor("stack.tab.foreground.selected", null);
            this.updateColor("stack.tab.background.top.focused.mouse", null);
            this.updateColor("stack.tab.background.bottom.focused.mouse", null);
            this.updateColor("stack.tab.border.focused.mouse", null);
            this.updateColor("stack.tab.foreground.focused.mouse", null);
            this.updateColor("stack.tab.background.top.focused", null);
            this.updateColor("stack.tab.background.bottom.focused", null);
            this.updateColor("stack.tab.border.focused", null);
            this.updateColor("stack.tab.foreground.focused", null);
            this.updateColor("title.background.top.active", null);
            this.updateColor("title.background.top.active.mouse", null);
            this.updateColor("title.background.top.inactive", null);
            this.updateColor("title.background.top.inactive.mouse", null);
            this.updateColor("title.background.bottom.active", null);
            this.updateColor("title.background.bottom.active.mouse", null);
            this.updateColor("title.background.bottom.inactive", null);
            this.updateColor("title.background.bottom.inactive.mouse", null);
            this.updateColor("title.foreground.active", null);
            this.updateColor("title.foreground.active.mouse", null);
            this.updateColor("title.foreground.inactive", null);
            this.updateColor("title.foreground.inactive.mouse", null);
            this.updateColor("title.background.top.active.flap", null);
            this.updateColor("title.background.top.active.mouse.flap", null);
            this.updateColor("title.background.top.inactive.flap", null);
            this.updateColor("title.background.top.inactive.mouse.flap", null);
            this.updateColor("title.background.top.selected.flap", null);
            this.updateColor("title.background.top.selected.mouse.flap", null);
            this.updateColor("title.background.bottom.active.flap", null);
            this.updateColor("title.background.bottom.active.mouse.flap", null);
            this.updateColor("title.background.bottom.inactive.flap", null);
            this.updateColor("title.background.bottom.inactive.mouse.flap", null);
            this.updateColor("title.background.bottom.selected.flap", null);
            this.updateColor("title.background.bottom.selected.mouse.flap", null);
            this.updateColor("title.foreground.active.flap", null);
            this.updateColor("title.foreground.active.mouse.flap", null);
            this.updateColor("title.foreground.inactive.flap", null);
            this.updateColor("title.foreground.inactive.mouse.flap", null);
            this.updateColor("title.foreground.selected.flap", null);
            this.updateColor("title.foreground.selected.mouse.flap", null);
            this.updateColor("displayer.border.high.active", null);
            this.updateColor("displayer.border.high.inactive", null);
            this.updateColor("displayer.border.low.active", null);
            this.updateColor("displayer.border.low.inactive", null);
            this.updateColor("action.button", null);
            this.updateColor("action.button.enabled", null);
            this.updateColor("action.button.selected", null);
            this.updateColor("action.button.selected.enabled", null);
            this.updateColor("action.button.mouse.enabled", null);
            this.updateColor("action.button.mouse.selected.enabled", null);
            this.updateColor("action.button.pressed.enabled", null);
            this.updateColor("action.button.pressed.selected.enabled", null);
            this.updateColor("action.dropdown", null);
            this.updateColor("action.dropdown.enabled", null);
            this.updateColor("action.dropdown.selected", null);
            this.updateColor("action.dropdown.selected.enabled", null);
            this.updateColor("action.dropdown.mouse.enabled", null);
            this.updateColor("action.dropdown.mouse.selected.enabled", null);
            this.updateColor("action.dropdown.pressed.enabled", null);
            this.updateColor("action.dropdown.pressed.selected.enabled", null);
            this.updateColor("action.dropdown.line", null);
            this.updateColor("action.dropdown.line.enabled", null);
            this.updateColor("action.dropdown.line.selected", null);
            this.updateColor("action.dropdown.line.selected.enabled", null);
            this.updateColor("action.dropdown.line.mouse.enabled", null);
            this.updateColor("action.dropdown.line.mouse.selected.enabled", null);
            this.updateColor("action.dropdown.line.pressed.enabled", null);
            this.updateColor("action.dropdown.line.pressed.selected.enabled", null);
            this.updateColor("paint.divider", null);
            this.updateColor("paint.insertion", null);
            this.updateColor("paint.line", null);
            dockController.getColors().unlockUpdate();
        } else {
            super.updateColors();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SeparatorGenerator
    implements ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>> {
        private SeparatorGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SeparatorAction separatorAction, Dockable dockable) {
            if (separatorAction.shouldDisplay(ViewTarget.TITLE)) {
                return new BubbleSeparator(separatorAction);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MenuGenerator
    implements ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>> {
        private MenuGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
            BasicMenuHandler basicMenuHandler = new BasicMenuHandler(menuDockAction, dockable);
            RoundButton roundButton = new RoundButton(basicMenuHandler, dockable, menuDockAction);
            basicMenuHandler.setModel(roundButton.getModel());
            return new RoundButtonViewItem(dockable, basicMenuHandler, roundButton);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DropDownGenerator
    implements ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>> {
        private DropDownGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, DropDownAction dropDownAction, Dockable dockable) {
            BasicDropDownButtonHandler basicDropDownButtonHandler = new BasicDropDownButtonHandler(dropDownAction, dockable);
            RoundDropDownButton roundDropDownButton = new RoundDropDownButton(basicDropDownButtonHandler, dockable, dropDownAction);
            basicDropDownButtonHandler.setModel(roundDropDownButton.getModel());
            return new RoundButtonViewItem(dockable, basicDropDownButtonHandler, roundDropDownButton);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RadioGenerator
    implements ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>> {
        private RadioGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
            BasicSelectableHandler.Radio radio = new BasicSelectableHandler.Radio(selectableDockAction, dockable);
            RoundButton roundButton = new RoundButton(radio, dockable, selectableDockAction);
            radio.setModel(roundButton.getModel());
            return new RoundButtonViewItem(dockable, radio, roundButton);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckGenerator
    implements ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>> {
        private CheckGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
            BasicSelectableHandler.Check check = new BasicSelectableHandler.Check(selectableDockAction, dockable);
            RoundButton roundButton = new RoundButton(check, dockable, selectableDockAction);
            check.setModel(roundButton.getModel());
            return new RoundButtonViewItem(dockable, check, roundButton);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ButtonGenerator
    implements ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>> {
        private ButtonGenerator() {
        }

        @Override
        public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
            BasicButtonHandler basicButtonHandler = new BasicButtonHandler(buttonDockAction, dockable);
            RoundButton roundButton = new RoundButton(basicButtonHandler, dockable, buttonDockAction);
            basicButtonHandler.setModel(roundButton.getModel());
            return new RoundButtonViewItem(dockable, basicButtonHandler, roundButton);
        }
    }
}

