/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.PreferenceFactory;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceStorage {
    private Map<Path, PreferenceFactory<?>> factories = new HashMap();
    private Node root = new Node(null);

    public static void write(PreferenceModel preferenceModel, DataOutputStream dataOutputStream) throws IOException {
        PreferenceStorage preferenceStorage = new PreferenceStorage();
        preferenceStorage.store(preferenceModel);
        preferenceStorage.write(dataOutputStream);
    }

    public static void read(PreferenceModel preferenceModel, DataInputStream dataInputStream) throws IOException {
        PreferenceStorage preferenceStorage = new PreferenceStorage();
        preferenceStorage.read(dataInputStream);
        preferenceStorage.load(preferenceModel, true);
    }

    public static void writeXML(PreferenceModel preferenceModel, XElement xElement) {
        PreferenceStorage preferenceStorage = new PreferenceStorage();
        preferenceStorage.store(preferenceModel);
        preferenceStorage.writeXML(xElement);
    }

    public static void readXML(PreferenceModel preferenceModel, XElement xElement) {
        PreferenceStorage preferenceStorage = new PreferenceStorage();
        preferenceStorage.readXML(xElement);
        preferenceStorage.load(preferenceModel, true);
    }

    public PreferenceStorage() {
        this.addFactory(Path.TYPE_INT_PATH, PreferenceFactory.FACTORY_INT);
        this.addFactory(Path.TYPE_STRING_PATH, PreferenceFactory.FACTORY_STRING);
        this.addFactory(Path.TYPE_BOOLEAN_PATH, PreferenceFactory.FACTORY_BOOLEAN);
        this.addFactory(Path.TYPE_KEYSTROKE_PATH, PreferenceFactory.FACTORY_KEYSTROKE);
        this.addFactory(Path.TYPE_MODIFIER_MASK_PATH, PreferenceFactory.FACTORY_MODIFIER_MASK);
        this.addFactory(Path.TYPE_STRING_CHOICE_PATH, PreferenceFactory.FACTORY_STRING);
    }

    public void addFactory(Path path, PreferenceFactory<?> preferenceFactory) {
        if (path == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (preferenceFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        if (path.getSegmentCount() == 0) {
            throw new IllegalArgumentException("the root path is not a valid path for this metho");
        }
        this.factories.put(path, preferenceFactory);
    }

    public void store(PreferenceModel preferenceModel) {
        int n = preferenceModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (preferenceModel.isNatural(i)) continue;
            Node node = this.root.getNode(preferenceModel.getPath(i), true);
            node.put(preferenceModel.getTypePath(i), preferenceModel.getValue(i));
        }
    }

    public void load(PreferenceModel preferenceModel, boolean bl) {
        int n = preferenceModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!preferenceModel.isNatural(i)) {
                Node node = this.root.getNode(preferenceModel.getPath(i), false);
                if (node == null) {
                    if (!bl) continue;
                    preferenceModel.setValue(i, null);
                    continue;
                }
                preferenceModel.setValue(i, node.value);
                continue;
            }
            preferenceModel.setValueNatural(i);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.CURRENT);
        this.write(this.root, dataOutputStream);
    }

    private void write(Node node, DataOutputStream dataOutputStream) throws IOException {
        Path path = node.getType();
        if (path == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(path.toString());
            Object object = node.getValue();
            if (object == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                PreferenceFactory<?> preferenceFactory = this.factories.get(path);
                if (preferenceFactory == null) {
                    throw new IOException("unknown path for a type: " + path);
                }
                preferenceFactory.write(object, dataOutputStream);
            }
        }
        int n = node.getChildrenCount();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = node.getChild(i);
            dataOutputStream.writeUTF(node2.getName());
            this.write(node2, dataOutputStream);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.read(this.root, dataInputStream);
    }

    private void read(Node node, DataInputStream dataInputStream) throws IOException {
        Path path = null;
        Object var4_4 = null;
        if (dataInputStream.readBoolean()) {
            path = new Path(dataInputStream.readUTF());
            if (dataInputStream.readBoolean()) {
                PreferenceFactory<?> preferenceFactory = this.factories.get(path);
                if (preferenceFactory == null) {
                    throw new IOException("don't know how to read objects of type " + path);
                }
                var4_4 = preferenceFactory.read(dataInputStream);
            }
        }
        node.put(path, var4_4);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            Node node2 = node.getNode(new Path(string), true);
            this.read(node2, dataInputStream);
        }
    }

    public void writeXML(XElement xElement) {
        this.writeXML(this.root, xElement);
    }

    private void writeXML(Node node, XElement xElement) {
        PreferenceFactory<?> preferenceFactory;
        Path path = node.getType();
        Object object = node.getValue();
        if (path != null && object != null && (preferenceFactory = this.factories.get(path)) != null) {
            XElement xElement2 = xElement.addElement("value");
            xElement2.addString("type", path.toString());
            preferenceFactory.writeXML(object, xElement2);
        }
        int n = node.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            Node node2 = node.getChild(i);
            XElement xElement3 = xElement.addElement("child");
            xElement3.addString("name", node2.getName());
            this.writeXML(node2, xElement3);
        }
    }

    public void readXML(XElement xElement) {
        this.readXML(this.root, xElement);
    }

    private void readXML(Node node, XElement xElement) {
        XElement[] xElementArray;
        Object object;
        Path path = null;
        Object var4_4 = null;
        XElement xElement2 = xElement.getElement("value");
        if (xElement2 != null && (object = this.factories.get(path = new Path((String)(xElementArray = xElement2.getString("type"))))) != null) {
            var4_4 = object.readXML(xElement2);
        }
        node.put(path, var4_4);
        xElementArray = xElement.getElements("child");
        for (XElement xElement3 : xElementArray) {
            String string = xElement3.getString("name");
            Node node2 = node.getNode(new Path(string), true);
            this.readXML(node2, xElement3);
        }
    }

    public void clear() {
        this.root = new Node(null);
    }

    private static class Node {
        private String name;
        private Object value;
        private Path type;
        private List<Node> children;

        public Node(String string) {
            this.name = string;
        }

        public void put(Path path, Object object) {
            this.type = path;
            this.value = object;
        }

        public Path getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public int getChildrenCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public Node getChild(int n) {
            return this.children.get(n);
        }

        public String getName() {
            return this.name;
        }

        public Node getNode(Path path, boolean bl) {
            return this.getNode(path, bl, 0);
        }

        private Node getNode(Path path, boolean bl, int n) {
            if (path.getSegmentCount() == n) {
                return this;
            }
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            String string = path.getSegment(n);
            for (Node node : this.children) {
                if (!string.equals(node.getName())) continue;
                return node.getNode(path, bl, n + 1);
            }
            if (!bl) {
                return null;
            }
            Node node = new Node(string);
            this.children.add(node);
            return super.getNode(path, bl, n + 1);
        }
    }
}

