/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreference;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPreference<V>
extends AbstractPreference<V> {
    private V value;
    private Object valueInfo;
    private Path type;
    private String label;
    private String description;
    private V defaultValue;
    private Path path;
    private boolean natural = false;

    public DefaultPreference(Path path, Path path2) {
        if (path == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (path2 == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (path2.getSegmentCount() == 0) {
            throw new IllegalArgumentException("the root path is not a valid path for a preference");
        }
        this.type = path;
        this.path = path2;
    }

    public DefaultPreference(String string, Path path, Path path2) {
        this(path, path2);
        this.setLabel(string);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public Path getTypePath() {
        return this.type;
    }

    public void setValueInfo(Object object) {
        this.valueInfo = object;
    }

    @Override
    public Object getValueInfo() {
        return this.valueInfo;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V v) {
        if (this.value != v) {
            this.value = v;
            this.fireChanged();
        }
    }

    public void setDefaultValue(V v) {
        this.defaultValue = v;
        this.fireChanged();
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public void setNatural(boolean bl) {
        this.natural = bl;
    }

    @Override
    public boolean isNatural() {
        return this.natural;
    }

    @Override
    public PreferenceOperation[] getOperations() {
        if (this.defaultValue == null) {
            return null;
        }
        return new PreferenceOperation[]{PreferenceOperation.DEFAULT};
    }

    @Override
    public boolean isEnabled(PreferenceOperation preferenceOperation) {
        if (preferenceOperation == PreferenceOperation.DEFAULT) {
            if (this.defaultValue == null) {
                return false;
            }
            return !this.defaultValue.equals(this.getValue());
        }
        return false;
    }

    @Override
    public void doOperation(PreferenceOperation preferenceOperation) {
        if (preferenceOperation == PreferenceOperation.DEFAULT) {
            if (this.defaultValue != null) {
                this.setValue(this.defaultValue);
            }
        } else {
            super.doOperation(preferenceOperation);
        }
    }
}

