/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock;

import bibliothek.extension.gui.dock.PreferenceTable;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.PreferenceTreeModel;
import bibliothek.extension.gui.dock.util.Path;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceTreePanel
extends JPanel {
    private PreferenceTreeModel model;
    private JTree tree;
    private PreferenceTable table;

    public PreferenceTreePanel() {
        this((PreferenceTreeModel)null);
    }

    public PreferenceTreePanel(PreferenceTreeModel preferenceTreeModel) {
        if (preferenceTreeModel == null) {
            preferenceTreeModel = new PreferenceTreeModel();
        }
        this.model = preferenceTreeModel;
        this.setLayout(new GridLayout(1, 1));
        JSplitPane jSplitPane = new JSplitPane(1);
        this.tree = new JTree(preferenceTreeModel);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        jSplitPane.setLeftComponent(new JScrollPane(this.tree));
        this.table = new PreferenceTable();
        jSplitPane.setRightComponent(new JScrollPane(this.table));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                PreferenceTreePanel.this.checkSelection();
            }
        });
        this.add(jSplitPane);
        this.checkSelection();
    }

    public void addOperation(PreferenceOperation preferenceOperation) {
        this.table.addOperation(preferenceOperation);
    }

    public void setEditorFactory(Path path, PreferenceEditorFactory<?> preferenceEditorFactory) {
        this.table.setEditorFactory(path, preferenceEditorFactory);
    }

    public JTree getTree() {
        return this.tree;
    }

    public PreferenceTable getTable() {
        return this.table;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.table.getModel() == null) {
            dimension = new Dimension(dimension.width * 2, dimension.height);
        }
        return dimension;
    }

    private void checkSelection() {
        PreferenceModel preferenceModel = null;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            PreferenceTreeModel.Node node = (PreferenceTreeModel.Node)treePath.getLastPathComponent();
            preferenceModel = node.getModel();
        }
        this.table.setModel(preferenceModel);
    }

    public void setModel(PreferenceTreeModel preferenceTreeModel) {
        if (preferenceTreeModel == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.model = preferenceTreeModel;
        this.tree.setModel(preferenceTreeModel);
    }

    public PreferenceTreeModel getModel() {
        return this.model;
    }
}

