/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.util;

import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

public class ApplicationResourceManager {
    private Map<String, ApplicationResource> resources = new HashMap<String, ApplicationResource>();
    private Map<String, Object> buffer = new HashMap<String, Object>();

    public void put(String string, ApplicationResource applicationResource) throws IOException {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (applicationResource == null) {
            throw new NullPointerException("resource must not be null");
        }
        this.resources.put(string, applicationResource);
        Object object = this.buffer.get(string);
        if (object != null) {
            if (object instanceof byte[]) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                applicationResource.read(dataInputStream);
                dataInputStream.close();
            }
            if (object instanceof XElement) {
                applicationResource.readXML((XElement)object);
            }
        }
    }

    public void remove(String string) {
        this.resources.remove(string);
    }

    public void writeStream(DataOutputStream dataOutputStream) throws IOException {
        Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_4);
        dataOutputStream.writeInt(this.resources.size());
        for (Map.Entry<String, ApplicationResource> entry : this.resources.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
            entry.getValue().write(dataOutputStream2);
            dataOutputStream2.close();
            dataOutputStream.writeInt(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo(dataOutputStream);
        }
    }

    public void readStream(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read((DataInputStream)dataInputStream);
        version.checkCurrent();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            ApplicationResource applicationResource = this.resources.get(string);
            if (applicationResource != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
                applicationResource.read(dataInputStream2);
                dataInputStream2.close();
                continue;
            }
            this.buffer.put(string, byArray);
        }
    }

    public void writeXML(XElement xElement) {
        for (Map.Entry<String, ApplicationResource> entry : this.resources.entrySet()) {
            XElement xElement2 = xElement.addElement("resource");
            xElement2.addString("name", entry.getKey());
            entry.getValue().writeXML(xElement2);
        }
    }

    public void readXML(XElement xElement) {
        for (XElement xElement2 : xElement.getElements("resource")) {
            String string = xElement2.getString("name");
            ApplicationResource applicationResource = this.resources.get(string);
            if (applicationResource != null) {
                applicationResource.readXML(xElement2);
                continue;
            }
            this.buffer.put(string, xElement2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            this.writeStream(dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            this.readStream(dataInputStream);
        }
        finally {
            dataInputStream.close();
        }
    }

    public byte[] writeArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeStream(dataOutputStream);
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void readArray(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.readStream(dataInputStream);
        dataInputStream.close();
    }

    public void writePreferences() throws IOException {
        Preferences preferences = Preferences.userNodeForPackage(ApplicationResourceManager.class);
        preferences.putByteArray("content", this.writeArray());
    }

    public void readPreferences() throws IOException {
        Preferences preferences = Preferences.userNodeForPackage(ApplicationResourceManager.class);
        byte[] byArray = preferences.getByteArray("content", null);
        if (byArray != null) {
            this.readArray(byArray);
        }
    }
}

