/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.DockFrontendListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;

public abstract class FrontendSettingsList
extends BaseMenuPiece {
    private DockFrontend frontend;
    private Listener listener = new Listener();
    private Map<String, JMenuItem> items = new HashMap<String, JMenuItem>();

    public FrontendSettingsList(DockFrontend dockFrontend) {
        this.setFrontend(dockFrontend);
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public void setFrontend(DockFrontend dockFrontend) {
        if (this.frontend != dockFrontend) {
            if (this.frontend != null) {
                int n = this.getItemCount();
                while (n > 0) {
                    this.remove(--n);
                }
                this.items.clear();
                this.frontend.removeFrontendListener((DockFrontendListener)this.listener);
            }
            this.frontend = dockFrontend;
            if (this.frontend != null) {
                this.frontend.addFrontendListener((DockFrontendListener)this.listener);
                for (String string : dockFrontend.getSettings()) {
                    this.add(string);
                }
            }
        }
    }

    protected abstract void action(String var1);

    private void add(final String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrontendSettingsList.this.action(string);
            }
        });
        this.add(jMenuItem);
        this.items.put(string, jMenuItem);
    }

    private void remove(String string) {
        JMenuItem jMenuItem = this.items.remove(string);
        if (jMenuItem != null) {
            this.remove(jMenuItem);
        }
    }

    private class Listener
    extends DockFrontendAdapter {
        private Listener() {
        }

        public void deleted(DockFrontend dockFrontend, String string) {
            FrontendSettingsList.this.remove(string);
        }

        public void saved(DockFrontend dockFrontend, String string) {
            if (!FrontendSettingsList.this.items.containsKey(string)) {
                FrontendSettingsList.this.add(string);
            }
        }

        public void read(DockFrontend dockFrontend, String string) {
            if (!FrontendSettingsList.this.items.containsKey(string)) {
                FrontendSettingsList.this.add(string);
            }
        }
    }
}

