/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.lookandfeel;

import bibliothek.gui.dock.support.lookandfeel.ComponentCollector;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelListener;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelUtilities;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAndFeelList {
    private static LookAndFeelList list;
    private Wrapper defaultInfo;
    private Wrapper systemInfo;
    private Info currentInfo;
    private List<Info> infos = new ArrayList<Info>();
    private List<LookAndFeelListener> listeners = new ArrayList<LookAndFeelListener>();
    private List<ComponentCollector> componentCollectors = new ArrayList<ComponentCollector>();
    private boolean allowReadOnlyOnce = false;
    private boolean hasRead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LookAndFeelList getDefaultList() {
        if (list != null) return list;
        Class<LookAndFeelList> clazz = LookAndFeelList.class;
        synchronized (LookAndFeelList.class) {
            if (list != null) return list;
            list = new LookAndFeelList();
            // ** MonitorExit[var0] (shouldn't be in output)
            return list;
        }
    }

    public static void setDefaultList(LookAndFeelList lookAndFeelList) {
        list = lookAndFeelList;
    }

    protected LookAndFeelList() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        this.setDefault(new Info(lookAndFeel.getClass().getName(), lookAndFeel.getName()));
        this.currentInfo = this.defaultInfo;
        this.setSystem(new Info(UIManager.getSystemLookAndFeelClassName(), "System"));
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            this.add(new Info(lookAndFeelInfoArray[i].getClassName(), lookAndFeelInfoArray[i].getName()));
        }
        this.add(new Info(MetalLookAndFeel.class.getName(), "Retro"){
            private MetalTheme oldTheme;

            protected void setup() {
                this.oldTheme = MetalLookAndFeel.getCurrentTheme();
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }

            protected void kill() {
                MetalLookAndFeel.setCurrentTheme(this.oldTheme);
            }
        });
    }

    public boolean isAllowReadOnlyOnce() {
        return this.allowReadOnlyOnce;
    }

    public void setAllowReadOnlyOnce(boolean bl) {
        this.allowReadOnlyOnce = bl;
    }

    public void setReadOnce(boolean bl) {
        this.hasRead = bl;
    }

    public void addLookAndFeelListener(LookAndFeelListener lookAndFeelListener) {
        if (lookAndFeelListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(lookAndFeelListener);
    }

    public void removeLookAndFeelListener(LookAndFeelListener lookAndFeelListener) {
        this.listeners.remove(lookAndFeelListener);
    }

    protected LookAndFeelListener[] listeners() {
        return this.listeners.toArray(new LookAndFeelListener[this.listeners.size()]);
    }

    public void addComponentCollector(ComponentCollector componentCollector) {
        this.componentCollectors.add(componentCollector);
    }

    public void removeComponentCollector(ComponentCollector componentCollector) {
        this.componentCollectors.remove(componentCollector);
    }

    public void add(Info info) {
        this.insert(this.infos.size(), info);
    }

    public void insert(int n, Info info) {
        if (info == null) {
            throw new NullPointerException("Info must not be null");
        }
        this.infos.add(n, info);
        for (LookAndFeelListener lookAndFeelListener : this.listeners()) {
            lookAndFeelListener.lookAndFeelAdded(this, info);
        }
    }

    public int size() {
        return this.infos.size();
    }

    public Info get(int n) {
        return this.infos.get(n);
    }

    public int indexOf(Info info) {
        return this.infos.indexOf(info);
    }

    public Info getFull(int n) {
        if (n == 0) {
            return this.getDefault();
        }
        if (n == 1) {
            return this.getSystem();
        }
        return this.get(n - 2);
    }

    public int indexOfFull(Info info) {
        if (info == this.defaultInfo) {
            return 0;
        }
        if (info == this.systemInfo) {
            return 1;
        }
        int n = this.indexOf(info);
        if (n < 0) {
            return -1;
        }
        return n + 2;
    }

    public void remove(Info info) {
        int n = this.indexOf(info);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        Info info = this.infos.remove(n);
        for (LookAndFeelListener lookAndFeelListener : this.listeners()) {
            lookAndFeelListener.lookAndFeelRemoved(this, info);
        }
    }

    public Info getLookAndFeel() {
        return this.currentInfo;
    }

    public void setLookAndFeel(Info info) {
        if (info == this.currentInfo) {
            return;
        }
        if (info == null) {
            throw new NullPointerException("lookAndFeel must not be null");
        }
        try {
            this.currentInfo.kill();
            this.currentInfo = info;
            info.setup();
            UIManager.setLookAndFeel(info.getClassName());
            LookAndFeelUtilities.updateUI(this.listComponents());
            for (LookAndFeelListener lookAndFeelListener : this.listeners()) {
                lookAndFeelListener.lookAndFeelChanged(this, info);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
    }

    public Info getDefault() {
        return this.defaultInfo;
    }

    public void setDefault(Info info) {
        if (info == null) {
            throw new NullPointerException("argument must not be null");
        }
        this.defaultInfo = new Wrapper(info);
        for (LookAndFeelListener lookAndFeelListener : this.listeners()) {
            lookAndFeelListener.defaultLookAndFeelChanged(this, this.defaultInfo);
        }
    }

    public Info getSystem() {
        return this.systemInfo;
    }

    public void setSystem(Info info) {
        if (info == null) {
            throw new NullPointerException("argument must not be null");
        }
        this.systemInfo = new Wrapper(info);
        for (LookAndFeelListener lookAndFeelListener : this.listeners()) {
            lookAndFeelListener.systemLookAndFeelChanged(this, this.systemInfo);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_4);
        dataOutputStream.writeInt(this.indexOfFull(this.getLookAndFeel()));
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read((DataInputStream)dataInputStream);
        version.checkCurrent();
        int n = dataInputStream.readInt();
        if (!(this.hasRead && this.allowReadOnlyOnce || n < 0 || n >= this.size() + 2)) {
            this.setLookAndFeel(this.getFull(n));
        }
        this.hasRead = true;
    }

    public void writeXML(XElement xElement) {
        xElement.addElement("index").setInt(this.indexOfFull(this.getLookAndFeel()));
    }

    public void readXML(XElement xElement) {
        int n;
        if (!(this.hasRead && this.allowReadOnlyOnce || (n = xElement.getElement("index").getInt()) < 0 || n >= this.size() + 2)) {
            this.setLookAndFeel(this.getFull(n));
        }
        this.hasRead = true;
    }

    protected Collection<Component> listComponents() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (ComponentCollector componentCollector : this.componentCollectors) {
            arrayList.addAll(componentCollector.listComponents());
        }
        return arrayList;
    }

    public static class Info {
        private String className;
        private String name;

        public Info(String string, String string2) {
            this.className = string;
            this.name = string2;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        protected void setup() {
        }

        protected void kill() {
        }
    }

    private class Wrapper
    extends Info {
        private Info info;

        public Wrapper(Info info) {
            super(info.getClassName(), info.getName());
            this.info = info;
        }

        protected void setup() {
            this.info.setup();
        }

        protected void kill() {
            this.info.kill();
        }
    }
}

