/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.action;

import bibliothek.gui.dock.support.action.ModeTransitionConverter;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeTransitionSetting<A, B> {
    private List<Entry> entries = new ArrayList<Entry>();
    private ModeTransitionConverter<A, B> converter;

    public ModeTransitionSetting(ModeTransitionConverter<A, B> modeTransitionConverter) {
        if (modeTransitionConverter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        this.converter = modeTransitionConverter;
    }

    public ModeTransitionConverter<A, B> getConverter() {
        return this.converter;
    }

    public void add(String string, String string2, Map<String, A> map, Collection<String> collection) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        if (map == null) {
            throw new NullPointerException("properties");
        }
        if (collection == null) {
            throw new NullPointerException("history");
        }
        Entry entry = new Entry();
        entry.id = string;
        entry.current = string2;
        entry.history = collection.toArray(new String[collection.size()]);
        entry.properties = new HashMap();
        for (Map.Entry<String, A> entry2 : map.entrySet()) {
            entry.properties.put(entry2.getKey(), this.converter.convertToSetting(entry2.getValue()));
        }
        this.entries.add(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public String getId(int n) {
        return this.entries.get((int)n).id;
    }

    public String getCurrent(int n) {
        return this.entries.get((int)n).current;
    }

    public String[] getHistory(int n) {
        return this.entries.get((int)n).history;
    }

    public Map<String, A> getProperties(int n) {
        HashMap<String, A> hashMap = new HashMap<String, A>();
        for (Map.Entry entry : this.entries.get((int)n).properties.entrySet()) {
            hashMap.put(entry.getKey(), this.converter.convertToWorld(entry.getValue()));
        }
        return hashMap;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_4);
        dataOutputStream.writeInt(this.entries.size());
        for (Entry entry : this.entries) {
            dataOutputStream.writeUTF(entry.id);
            if (entry.current == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeUTF(entry.current);
            }
            dataOutputStream.writeInt(entry.history.length);
            for (String string : entry.history) {
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.writeInt(entry.properties.size());
            for (Map.Entry entry2 : entry.properties.entrySet()) {
                dataOutputStream.writeUTF((String)entry2.getKey());
                this.converter.writeProperty(entry2.getValue(), dataOutputStream);
            }
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read((DataInputStream)dataInputStream);
        version.checkCurrent();
        this.entries.clear();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2;
            Entry entry = new Entry();
            this.entries.add(entry);
            entry.id = dataInputStream.readUTF();
            if (dataInputStream.readBoolean()) {
                entry.current = dataInputStream.readUTF();
            }
            entry.history = new String[dataInputStream.readInt()];
            for (n2 = 0; n2 < entry.history.length; ++n2) {
                entry.history[n2] = dataInputStream.readUTF();
            }
            entry.properties = new HashMap();
            int n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                String string = dataInputStream.readUTF();
                B b = this.converter.readProperty(dataInputStream);
                entry.properties.put(string, b);
            }
        }
    }

    public void writeXML(XElement xElement) {
        for (Entry entry : this.entries) {
            XElement xElement2 = xElement.addElement("entry");
            xElement2.addString("id", entry.id);
            if (entry.current != null) {
                xElement2.addString("current", entry.current);
            }
            XElement xElement3 = xElement2.addElement("history");
            for (String string : entry.history) {
                xElement3.addElement("mode").setString(string);
            }
            XElement xElement4 = xElement2.addElement("properties");
            for (Map.Entry entry2 : entry.properties.entrySet()) {
                String string;
                string = xElement4.addElement("property");
                string.addString("id", entry2.getKey());
                this.converter.writePropertyXML(entry2.getValue(), (XElement)string);
            }
        }
    }

    public void readXML(XElement xElement) {
        this.entries.clear();
        for (XElement xElement2 : xElement.getElements("entry")) {
            XElement xElement3;
            XElement xElement4;
            Entry entry = new Entry();
            this.entries.add(entry);
            entry.id = xElement2.getString("id");
            XAttribute xAttribute = xElement2.getAttribute("current");
            if (xAttribute != null) {
                entry.current = xAttribute.getString();
            }
            if ((xElement4 = xElement2.getElement("history")) == null) {
                entry.history = new String[0];
            } else {
                xElement3 = xElement4.getElements("mode");
                entry.history = new String[((XElement[])xElement3).length];
                for (int i = 0; i < ((XElement)xElement3).length; ++i) {
                    entry.history[i] = xElement3[i].getString();
                }
            }
            xElement3 = xElement2.getElement("properties");
            entry.properties = new HashMap();
            if (xElement3 == null) continue;
            for (XElement xElement5 : xElement3.getElements("property")) {
                entry.properties.put(xElement5.getString("id"), this.converter.readPropertyXML(xElement5));
            }
        }
    }

    private class Entry {
        public String id;
        public String current;
        public Map<String, B> properties;
        public String[] history;

        private Entry() {
        }
    }
}

