/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.support.action.ModeTransitionConverter;
import bibliothek.gui.dock.support.action.ModeTransitionSetting;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModeTransitionManager<A>
implements ActionGuard {
    private Map<String, Mode> modes = new HashMap<String, Mode>();
    private Map<Dockable, Entry> dockables = new HashMap<Dockable, Entry>();
    private Map<String, Entry> entries = new HashMap<String, Entry>();

    public ModeTransitionManager(String ... stringArray) {
        for (String string : stringArray) {
            this.modes.put(string, new Mode(string));
        }
    }

    public boolean react(Dockable dockable) {
        return this.dockables.containsKey(dockable);
    }

    public DockActionSource getSource(Dockable dockable) {
        return this.dockables.get((Object)dockable).source;
    }

    public void addEmpty(String string) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        Entry entry = this.entries.get(string);
        if (entry == null) {
            entry = new Entry(null, string);
            this.entries.put(string, entry);
        }
    }

    public void removeEmpty(String string) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        Entry entry = this.entries.get(string);
        if (entry.dockable == null) {
            this.entries.remove(string);
        }
    }

    public void add(String string, Dockable dockable) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        Entry entry = this.entries.get(string);
        if (entry != null && entry.dockable != null) {
            throw new IllegalArgumentException("There is already a dockable registered with the name: " + string);
        }
        if (entry == null) {
            entry = new Entry(dockable, string);
            this.entries.put(entry.id, entry);
        } else {
            entry.dockable = dockable;
        }
        this.dockables.put(dockable, entry);
        entry.putMode(this.currentMode(dockable));
        this.added(dockable);
        this.rebuild(dockable);
    }

    protected void added(Dockable dockable) {
    }

    public void put(String string, Dockable dockable) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        Entry entry = this.entries.get(string);
        if (entry != null) {
            if (entry.dockable != null) {
                this.dockables.remove(entry.dockable);
                this.removed(entry.dockable);
            }
            entry.dockable = dockable;
            this.dockables.put(dockable, entry);
        } else {
            entry = new Entry(dockable, string);
            this.dockables.put(dockable, entry);
            this.entries.put(entry.id, entry);
            entry.putMode(this.currentMode(dockable));
        }
        this.added(dockable);
        this.rebuild(dockable);
    }

    public void remove(Dockable dockable) {
        Entry entry = this.dockables.remove(dockable);
        if (entry != null) {
            this.entries.remove(entry.id);
            this.removed(dockable);
        }
    }

    public void reduceToEmpty(Dockable dockable) {
        Entry entry = this.dockables.get(dockable);
        if (entry != null) {
            entry.dockable = null;
            this.removed(dockable);
        }
    }

    protected void removed(Dockable dockable) {
    }

    public List<Dockable> getDockables() {
        return new ArrayList<Dockable>(this.dockables.keySet());
    }

    public String getName(Dockable dockable) {
        Entry entry = this.dockables.get(dockable);
        return entry == null ? null : entry.id;
    }

    public SimpleButtonAction getOutgoingAction(String string) {
        Mode mode = this.modes.get(string);
        if (mode == null) {
            throw new IllegalArgumentException("mode is unknown: " + string);
        }
        return mode.outgoing();
    }

    public DockAction getOutgoingAction(String string, Dockable dockable) {
        return this.getOutgoingAction(string);
    }

    protected void putOutgoingAction(String string, SimpleButtonAction simpleButtonAction) {
        Mode mode = this.modes.get(string);
        if (mode == null) {
            throw new IllegalArgumentException("mode unknown: " + string);
        }
        mode.outgoing = simpleButtonAction;
    }

    public SimpleButtonAction getIngoingAction(String string) {
        Mode mode = this.modes.get(string);
        if (mode == null) {
            throw new IllegalArgumentException("Mode is unknown: " + string);
        }
        return mode.ingoing();
    }

    public DockAction getIngoingAction(String string, Dockable dockable) {
        return this.getIngoingAction(string);
    }

    protected void putIngoingAction(String string, SimpleButtonAction simpleButtonAction) {
        Mode mode = this.modes.get(string);
        if (mode == null) {
            throw new IllegalArgumentException("mode unknown: " + string);
        }
        mode.ingoing = simpleButtonAction;
    }

    protected abstract String currentMode(Dockable var1);

    protected abstract String[] availableModes(String var1, Dockable var2);

    protected abstract String getDefaultMode(Dockable var1);

    protected abstract void transition(String var1, String var2, Dockable var3);

    protected abstract void transitionDuringRead(String var1, String var2, String var3, Dockable var4);

    protected String[] history(Dockable dockable) {
        Entry entry = this.dockables.get(dockable);
        if (entry == null) {
            return null;
        }
        return entry.history.toArray(new String[entry.history.size()]);
    }

    protected void goOut(String string, Dockable dockable) {
        this.transition(string, this.dockables.get(dockable).previousMode(), dockable);
    }

    protected void goIn(String string, Dockable dockable) {
        this.transition(this.currentMode(dockable), string, dockable);
        Entry entry = this.dockables.get(dockable);
        if (entry != null) {
            entry.putMode(string);
        }
    }

    public void setMode(Dockable dockable, String string) {
        this.goIn(string, dockable);
    }

    protected void rebuildAll() {
        for (Entry entry : this.dockables.values()) {
            this.rebuild(entry);
        }
    }

    protected void rebuild(Dockable dockable) {
        Entry entry = this.dockables.get(dockable);
        if (entry != null) {
            this.rebuild(entry);
        }
    }

    private void rebuild(Entry entry) {
        String string = this.currentMode(entry.dockable);
        String[] stringArray = this.availableModes(string, entry.dockable);
        entry.source.removeAll();
        for (String string2 : stringArray) {
            if (!this.modes.containsKey(string2)) continue;
            if (string2.equals(string)) {
                entry.source.add(new DockAction[]{this.getOutgoingAction(string2, entry.dockable)});
                continue;
            }
            entry.source.add(new DockAction[]{this.getIngoingAction(string2, entry.dockable)});
        }
    }

    protected A getProperties(String string, Dockable dockable) {
        Entry entry = this.dockables.get(dockable);
        if (entry == null) {
            return null;
        }
        return entry.properties.get(string);
    }

    protected void setProperties(String string, Dockable dockable, A a) {
        Entry entry = this.dockables.get(dockable);
        if (entry != null) {
            if (a == null) {
                entry.properties.remove(string);
            } else {
                entry.properties.put(string, a);
            }
        }
    }

    protected void putMode(Dockable dockable, String string) {
        Entry entry = this.dockables.get(dockable);
        if (entry != null) {
            entry.putMode(string);
        }
    }

    protected void modeChanged(Dockable dockable, String string, String string2) {
    }

    protected String previousMode(Dockable dockable) {
        Entry entry = this.dockables.get(dockable);
        if (entry == null) {
            return null;
        }
        if (entry.history.size() < 2) {
            return null;
        }
        return (String)entry.history.get(entry.history.size() - 2);
    }

    public <B> ModeTransitionSetting<A, B> getSetting(ModeTransitionConverter<A, B> modeTransitionConverter) {
        ModeTransitionSetting modeTransitionSetting = this.createSetting(modeTransitionConverter);
        for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
            String string = null;
            Entry entry2 = entry.getValue();
            if (entry2.dockable != null) {
                string = this.currentMode(entry2.dockable);
            }
            modeTransitionSetting.add(entry2.id, string, entry2.properties, entry2.history);
        }
        return modeTransitionSetting;
    }

    public void setSetting(ModeTransitionSetting<A, ?> modeTransitionSetting) {
        int n = modeTransitionSetting.size();
        for (int i = 0; i < n; ++i) {
            String string = modeTransitionSetting.getId(i);
            Entry entry = this.entries.get(string);
            if (entry == null && this.createEntryDuringRead(string)) {
                this.addEmpty(string);
                entry = this.entries.get(string);
            }
            if (entry == null) continue;
            String string2 = modeTransitionSetting.getCurrent(i);
            String string3 = null;
            if (entry.dockable != null) {
                string3 = this.currentMode(entry.dockable);
            }
            if (string2 == null) {
                string2 = string3;
            }
            entry.history.clear();
            for (String string4 : modeTransitionSetting.getHistory(i)) {
                entry.history.add(string4);
            }
            entry.properties = modeTransitionSetting.getProperties(i);
            if ((string3 != null || string2 == null) && (string3 == null || string3.equals(string2))) continue;
            this.transitionDuringRead(string, string3, string2, entry.dockable);
        }
    }

    protected boolean createEntryDuringRead(String string) {
        return false;
    }

    protected <B> ModeTransitionSetting<A, B> createSetting(ModeTransitionConverter<A, B> modeTransitionConverter) {
        return new ModeTransitionSetting<A, B>(modeTransitionConverter);
    }

    public <B> void write(ModeTransitionConverter<A, B> modeTransitionConverter, DataOutputStream dataOutputStream) throws IOException {
        this.getSetting(modeTransitionConverter).write(dataOutputStream);
    }

    public <B> void read(ModeTransitionConverter<A, B> modeTransitionConverter, DataInputStream dataInputStream) throws IOException {
        ModeTransitionSetting<A, B> modeTransitionSetting = this.createSetting(modeTransitionConverter);
        modeTransitionSetting.read(dataInputStream);
        this.setSetting(modeTransitionSetting);
    }

    private class Entry {
        public Dockable dockable;
        public String id;
        public DefaultDockActionSource source;
        public Map<String, A> properties;
        private List<String> history;

        public Entry(Dockable dockable, String string) {
            this.dockable = dockable;
            this.id = string;
            this.source = new DefaultDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT), new DockAction[0]);
            this.properties = new HashMap();
            this.history = new LinkedList<String>();
        }

        public void putMode(String string) {
            String string2 = this.peekMode();
            this.history.remove(string);
            this.history.add(string);
            ModeTransitionManager.this.rebuild(this.dockable);
            ModeTransitionManager.this.modeChanged(this.dockable, string2, string);
        }

        public String previousMode() {
            if (this.history.size() < 2) {
                return ModeTransitionManager.this.getDefaultMode(this.dockable);
            }
            return this.history.get(this.history.size() - 2);
        }

        public String peekMode() {
            if (this.history.isEmpty()) {
                return null;
            }
            return this.history.get(this.history.size() - 1);
        }
    }

    private class Mode {
        public String name;
        private SimpleButtonAction ingoing;
        private SimpleButtonAction outgoing;

        public Mode(String string) {
            this.name = string;
        }

        public SimpleButtonAction ingoing() {
            if (this.ingoing == null) {
                this.ingoing = new SimpleButtonAction(){

                    public void action(Dockable dockable) {
                        super.action(dockable);
                        ModeTransitionManager.this.goIn(Mode.this.name, dockable);
                    }
                };
            }
            return this.ingoing;
        }

        public SimpleButtonAction outgoing() {
            if (this.outgoing == null) {
                this.outgoing = new SimpleButtonAction(){

                    public void action(Dockable dockable) {
                        super.action(dockable);
                        ModeTransitionManager.this.goOut(Mode.this.name, dockable);
                    }
                };
            }
            return this.outgoing;
        }
    }
}

