/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.state;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.facile.state.MaximizeArea;
import bibliothek.gui.dock.facile.state.MaximizeAreaListener;
import bibliothek.gui.dock.facile.state.MaximizeSplitDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.support.action.ModeTransitionConverter;
import bibliothek.gui.dock.support.action.ModeTransitionManager;
import bibliothek.gui.dock.support.action.ModeTransitionSetting;
import bibliothek.gui.dock.support.util.Resources;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.awt.Component;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManager
extends ModeTransitionManager<Location> {
    public static final String ICON_MANAGER_KEY_MINIMIZE = "statemanager.minimize";
    public static final String ICON_MANAGER_KEY_MAXIMIZE = "statemanager.maximize";
    public static final String ICON_MANAGER_KEY_NORMALIZE = "statemanager.normalize";
    public static final String ICON_MANAGER_KEY_EXTERNALIZE = "statemanager.externalize";
    private Set<SplitDockStation> normal = new HashSet<SplitDockStation>();
    private SplitDockStation defaultNormal;
    private Set<FlapDockStation> mini = new HashSet<FlapDockStation>();
    private FlapDockStation defaultMini;
    private Set<MaximizeArea> maxi = new HashSet<MaximizeArea>();
    private MaximizeArea defaultMaxi;
    private Set<ScreenDockStation> external = new HashSet<ScreenDockStation>();
    private ScreenDockStation defaultExternal;
    private Map<String, DockStation> stations = new HashMap<String, DockStation>();
    public static final String MINIMIZED = "mini";
    public static final String MAXIMIZED = "maxi";
    public static final String NORMALIZED = "normal";
    public static final String EXTERNALIZED = "extern";
    private Listener listener = new Listener();
    private DockController controller;
    private Map<String, Location> lastMaximizedLocation = new HashMap<String, Location>();
    private Map<String, String> lastMaximizedMode = new HashMap<String, String>();
    private boolean onTransition = false;

    public StateManager(DockController dockController) {
        this(dockController, true);
    }

    protected StateManager(DockController dockController, boolean bl) {
        super(MINIMIZED, NORMALIZED, MAXIMIZED, EXTERNALIZED);
        this.controller = dockController;
        if (bl) {
            this.init();
        }
    }

    protected void init() {
        this.controller.addActionGuard((ActionGuard)this);
        this.controller.getRelocator().addDockRelocatorListener((DockRelocatorListener)this.listener);
        this.controller.getRegister().addDockRegisterListener((DockRegisterListener)this.listener);
        ResourceBundle resourceBundle = Resources.getBundle();
        this.getIngoingAction(MINIMIZED).setText(resourceBundle.getString("minimize.in"));
        this.getIngoingAction(MINIMIZED).setTooltip(resourceBundle.getString("minimize.in.tooltip"));
        this.getIngoingAction(NORMALIZED).setText(resourceBundle.getString("normalize.in"));
        this.getIngoingAction(NORMALIZED).setTooltip(resourceBundle.getString("normalize.in.tooltip"));
        this.getIngoingAction(MAXIMIZED).setText(resourceBundle.getString("maximize.in"));
        this.getIngoingAction(MAXIMIZED).setTooltip(resourceBundle.getString("maximize.in.tooltip"));
        this.getIngoingAction(EXTERNALIZED).setText(resourceBundle.getString("externalize.in"));
        this.getIngoingAction(EXTERNALIZED).setTooltip(resourceBundle.getString("externalize.in.tooltip"));
        IconManager iconManager = this.controller.getIcons();
        iconManager.setIconDefault(ICON_MANAGER_KEY_MAXIMIZE, Resources.getIcon("maximize"));
        iconManager.setIconDefault(ICON_MANAGER_KEY_MINIMIZE, Resources.getIcon("minimize"));
        iconManager.setIconDefault(ICON_MANAGER_KEY_NORMALIZE, Resources.getIcon("normalize"));
        iconManager.setIconDefault(ICON_MANAGER_KEY_EXTERNALIZE, Resources.getIcon("externalize"));
        this.wire(iconManager, ICON_MANAGER_KEY_MAXIMIZE, this.getIngoingAction(MAXIMIZED));
        this.wire(iconManager, ICON_MANAGER_KEY_MINIMIZE, this.getIngoingAction(MINIMIZED));
        this.wire(iconManager, ICON_MANAGER_KEY_NORMALIZE, this.getIngoingAction(NORMALIZED));
        this.wire(iconManager, ICON_MANAGER_KEY_EXTERNALIZE, this.getIngoingAction(EXTERNALIZED));
    }

    private void wire(IconManager iconManager, String string, final SimpleButtonAction simpleButtonAction) {
        iconManager.add(string, new IconManagerListener(){

            public void iconChanged(String string, Icon icon) {
                simpleButtonAction.setIcon(icon);
            }
        });
        simpleButtonAction.setIcon(iconManager.getIcon(string));
    }

    @Override
    public <B> ModeTransitionSetting<Location, B> getSetting(ModeTransitionConverter<Location, B> modeTransitionConverter) {
        StateManagerSetting stateManagerSetting = (StateManagerSetting)super.getSetting(modeTransitionConverter);
        stateManagerSetting.setLastMaximizedLocation(this.lastMaximizedLocation);
        stateManagerSetting.setLastMaximizedMode(this.lastMaximizedMode);
        return stateManagerSetting;
    }

    @Override
    public void setSetting(ModeTransitionSetting<Location, ?> modeTransitionSetting) {
        if (modeTransitionSetting instanceof StateManagerSetting) {
            StateManagerSetting stateManagerSetting = (StateManagerSetting)modeTransitionSetting;
            this.lastMaximizedLocation = stateManagerSetting.getLastMaximizedLocation();
            this.lastMaximizedMode = stateManagerSetting.getLastMaximizedMode();
        } else {
            this.lastMaximizedLocation = null;
            this.lastMaximizedMode = null;
        }
        super.setSetting(modeTransitionSetting);
        this.rebuildAll();
    }

    protected <B> StateManagerSetting<B> createSetting(ModeTransitionConverter<Location, B> modeTransitionConverter) {
        return new StateManagerSetting<B>(modeTransitionConverter);
    }

    public void add(String string, SplitDockStation splitDockStation) {
        this.add(string, splitDockStation, true);
    }

    public void add(String string, SplitDockStation splitDockStation, boolean bl) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (this.stations.containsKey(string)) {
            throw new IllegalArgumentException("There is already a station registered with that name");
        }
        if (splitDockStation == null) {
            throw new NullPointerException("station must not be null");
        }
        this.stations.put(string, (DockStation)splitDockStation);
        this.normal.add(splitDockStation);
        if (bl) {
            if (this.defaultNormal == null) {
                this.defaultNormal = splitDockStation;
            }
            if (this.defaultMaxi == null) {
                this.setMaximizingArea(new MaximizeSplitDockStation("dock.default", splitDockStation));
            }
        }
    }

    public void addMaximizingArea(MaximizeArea maximizeArea) {
        if (maximizeArea == null) {
            throw new IllegalArgumentException("area must not be null");
        }
        for (MaximizeArea maximizeArea2 : this.maxi) {
            if (!maximizeArea2.getUniqueId().equals(maximizeArea.getUniqueId())) continue;
            throw new IllegalArgumentException("the unique identifier '" + maximizeArea.getUniqueId() + "' is already in use");
        }
        this.ensureNothingMaximized();
        this.maxi.add(maximizeArea);
        maximizeArea.addMaximizeAreaListener(this.listener);
        if (this.defaultMaxi == null) {
            this.defaultMaxi = maximizeArea;
        }
    }

    public MaximizeArea[] getMaximizingAreas() {
        return this.maxi.toArray(new MaximizeArea[this.maxi.size()]);
    }

    public void removeMaximizingArea(MaximizeArea maximizeArea) {
        if (maximizeArea == null) {
            throw new IllegalArgumentException("area must not be null");
        }
        this.ensureNothingMaximized();
        this.maxi.remove(maximizeArea);
        maximizeArea.removeMaximizeAreaListener(this.listener);
        this.lastMaximizedLocation.remove(maximizeArea.getUniqueId());
        this.lastMaximizedMode.remove(maximizeArea.getUniqueId());
        if (this.defaultMaxi == maximizeArea) {
            this.defaultMaxi = null;
            if (!this.maxi.isEmpty()) {
                this.defaultMaxi = this.maxi.iterator().next();
            }
        }
    }

    public void setMaximizingArea(MaximizeArea maximizeArea) {
        this.ensureNothingMaximized();
        if (!this.maxi.contains(maximizeArea)) {
            this.addMaximizingArea(maximizeArea);
        }
        this.defaultMaxi = maximizeArea;
    }

    public MaximizeArea getMaximizingArea() {
        return this.defaultMaxi;
    }

    @Deprecated
    public void setMaximizingStation(String string) {
        DockStation dockStation = this.stations.get(string);
        if (dockStation == null) {
            throw new IllegalArgumentException("No station registered with name " + string);
        }
        if (!(dockStation instanceof SplitDockStation)) {
            throw new IllegalArgumentException("Station is not a SplidDockStation " + string);
        }
        this.setMaximizingArea(new MaximizeSplitDockStation("dock.default", (SplitDockStation)dockStation));
    }

    public void add(String string, FlapDockStation flapDockStation) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (this.stations.containsKey(string)) {
            throw new IllegalArgumentException("There is already a station registered with that name");
        }
        if (flapDockStation == null) {
            throw new NullPointerException("station must not be null");
        }
        this.stations.put(string, (DockStation)flapDockStation);
        this.mini.add(flapDockStation);
        if (this.defaultMini == null) {
            this.defaultMini = flapDockStation;
        }
    }

    public void add(String string, ScreenDockStation screenDockStation) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (this.stations.containsKey(string)) {
            throw new IllegalArgumentException("There is already a station registered with that name");
        }
        if (screenDockStation == null) {
            throw new NullPointerException("station must not be null");
        }
        this.stations.put(string, (DockStation)screenDockStation);
        this.external.add(screenDockStation);
        if (this.defaultExternal == null) {
            this.defaultExternal = screenDockStation;
        }
    }

    public void remove(String string) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        DockStation dockStation = this.stations.remove(string);
        this.normal.remove(string);
        this.mini.remove(string);
        this.external.remove(string);
        if (dockStation == this.defaultExternal) {
            this.defaultExternal = null;
        }
        if (dockStation == this.defaultMini) {
            this.defaultMini = null;
        }
        if (dockStation == this.defaultNormal) {
            this.defaultNormal = null;
        }
        if (dockStation == this.maxi) {
            this.maxi = null;
        }
    }

    public void ensureNotHidden(Dockable dockable) {
        AffectedSet affectedSet = new AffectedSet();
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            MaximizeArea maximizeArea = this.getMaximizeArea(dockStation);
            if (maximizeArea != null && maximizeArea.getMaximizedDockable() != null && maximizeArea.getMaximizedDockable() != dockable) {
                this.unmaximize(maximizeArea.getMaximizedDockable(), affectedSet);
            }
            dockStation = (dockable = dockStation.asDockable()) == null ? null : dockable.getDockParent();
        }
        affectedSet.finish();
    }

    public boolean ensureNothingMaximized() {
        if (this.maxi == null) {
            return false;
        }
        AffectedSet affectedSet = new AffectedSet();
        for (MaximizeArea maximizeArea : this.maxi) {
            if (maximizeArea.getMaximizedDockable() == null) continue;
            this.unmaximize(maximizeArea.getMaximizedDockable(), affectedSet);
        }
        affectedSet.finish();
        return !affectedSet.isEmpty();
    }

    public Dockable getMaximized() {
        if (this.defaultMaxi == null) {
            return null;
        }
        return this.defaultMaxi.getMaximizedDockable();
    }

    protected MaximizeArea getMaximizeArea(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            MaximizeArea maximizeArea = this.getMaximizeArea(dockStation);
            if (maximizeArea != null) {
                return maximizeArea;
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    protected MaximizeArea getMaximizeArea(DockStation dockStation) {
        for (MaximizeArea maximizeArea : this.maxi) {
            if (maximizeArea.getStation() != dockStation) continue;
            return maximizeArea;
        }
        return null;
    }

    @Override
    protected String[] availableModes(String string, Dockable dockable) {
        if (MINIMIZED.equals(string)) {
            return new String[]{NORMALIZED, MAXIMIZED, EXTERNALIZED};
        }
        if (NORMALIZED.equals(string)) {
            return new String[]{MINIMIZED, MAXIMIZED, EXTERNALIZED};
        }
        if (MAXIMIZED.equals(string)) {
            return new String[]{NORMALIZED, MINIMIZED, EXTERNALIZED};
        }
        if (EXTERNALIZED.equals(string)) {
            return new String[]{NORMALIZED, MAXIMIZED, MINIMIZED};
        }
        return new String[]{MINIMIZED, NORMALIZED, MAXIMIZED, EXTERNALIZED};
    }

    @Override
    protected String currentMode(Dockable dockable) {
        if (this.normal.contains(dockable) || this.mini.contains(dockable)) {
            return NORMALIZED;
        }
        String string = this.currentModeSharp(dockable);
        if (string != null) {
            return string;
        }
        return NORMALIZED;
    }

    protected String currentModeSharp(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            if (this.mini.contains(dockStation)) {
                return MINIMIZED;
            }
            if (this.external.contains(dockStation)) {
                return EXTERNALIZED;
            }
            for (MaximizeArea maximizeArea : this.maxi) {
                if (maximizeArea.getStation() != dockStation) continue;
                if (maximizeArea.getMaximizedDockable() == dockable) {
                    return MAXIMIZED;
                }
                return NORMALIZED;
            }
            if (this.normal.contains(dockStation)) {
                return NORMALIZED;
            }
            dockable = dockStation.asDockable();
            dockStation = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    protected String childsMode(DockStation dockStation) {
        while (dockStation != null) {
            if (this.normal.contains(dockStation)) {
                return NORMALIZED;
            }
            if (this.mini.contains(dockStation)) {
                return MINIMIZED;
            }
            if (this.external.contains(dockStation)) {
                return EXTERNALIZED;
            }
            Dockable dockable = dockStation.asDockable();
            dockStation = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    @Override
    protected String getDefaultMode(Dockable dockable) {
        return NORMALIZED;
    }

    public boolean isOnTransition() {
        return this.onTransition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transition(String string, String string2, Dockable dockable) {
        AffectedSet affectedSet = new AffectedSet();
        this.onTransition = true;
        try {
            try {
                this.controller.getRegister().setStalled(true);
                if (string != null) {
                    this.store(dockable);
                }
                this.change(string, string2, dockable, affectedSet);
                if (!MINIMIZED.equals(string2)) {
                    this.controller.setFocusedDockable(dockable, true);
                }
            }
            finally {
                this.controller.getRegister().setStalled(false);
                this.onTransition = false;
                affectedSet.finish();
            }
        }
        finally {
            this.onTransition = false;
        }
    }

    @Override
    protected void transitionDuringRead(String string, String string2, String string3, Dockable dockable) {
    }

    protected Dockable getMaximizingElement(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return dockable;
        }
        if (!(dockStation instanceof StackDockStation)) {
            return dockable;
        }
        return dockStation.asDockable();
    }

    protected Dockable getMaximizingElement(Dockable dockable, Dockable dockable2) {
        if (dockable == dockable2) {
            return null;
        }
        if (dockable instanceof DockStation) {
            DockStation dockStation = (DockStation)dockable;
            if (dockStation.getDockableCount() == 2) {
                if (dockStation.getDockable(0) == dockable2) {
                    return dockStation.getDockable(1);
                }
                if (dockStation.getDockable(1) == dockable2) {
                    return dockStation.getDockable(0);
                }
            }
            if (dockStation.getDockableCount() < 2) {
                return null;
            }
        }
        return dockable;
    }

    private void change(String string, String string2, Dockable dockable, AffectedSet affectedSet) {
        this.change(string, string2, dockable, (Location)this.getProperties(string2, dockable), affectedSet);
    }

    private void change(String string, String string2, Dockable dockable, Location location, AffectedSet affectedSet) {
        if (MAXIMIZED.equals(string2)) {
            this.maximize(string, dockable, affectedSet);
        }
        if (MINIMIZED.equals(string2)) {
            this.minimize(dockable, location, affectedSet);
        }
        if (NORMALIZED.equals(string2)) {
            this.normalize(dockable, location, affectedSet);
        }
        if (EXTERNALIZED.equals(string2)) {
            this.externalize(dockable, location, affectedSet);
        }
    }

    private void maximize(String string, Dockable dockable, AffectedSet affectedSet) {
        this.maximize(string, null, dockable, affectedSet);
    }

    private void maximize(String string, MaximizeArea maximizeArea, Dockable dockable, AffectedSet affectedSet) {
        Dockable dockable2;
        if (string == null || !NORMALIZED.equals(string)) {
            this.change(string, NORMALIZED, dockable, affectedSet);
            string = NORMALIZED;
        }
        if ((dockable2 = this.getMaximizingElement(dockable)) != dockable) {
            this.store(dockable2);
        }
        if (maximizeArea == null) {
            maximizeArea = this.getMaximizeArea(dockable2);
        }
        if (maximizeArea == null) {
            maximizeArea = this.defaultMaxi;
        }
        if (this.getName(dockable2) == null) {
            this.lastMaximizedLocation.put(maximizeArea.getUniqueId(), this.currentLocation(string, dockable));
            this.lastMaximizedMode.put(maximizeArea.getUniqueId(), string);
        } else {
            this.lastMaximizedLocation.remove(maximizeArea.getUniqueId());
            this.lastMaximizedMode.remove(maximizeArea.getUniqueId());
        }
        if (dockable2.getDockParent() == maximizeArea.getStation()) {
            maximizeArea.setMaximizedDockable(dockable2);
        } else {
            if (dockable2.getDockParent() != null) {
                dockable2.getDockParent().drag(dockable2);
            }
            maximizeArea.dropAside(dockable2);
            maximizeArea.setMaximizedDockable(dockable2);
        }
        affectedSet.add(dockable2);
    }

    private void unmaximize(Dockable dockable, AffectedSet affectedSet) {
        MaximizeArea maximizeArea = this.getMaximizeArea(dockable);
        if (maximizeArea != null && maximizeArea.getMaximizedDockable() != null) {
            affectedSet.add(dockable);
            dockable = maximizeArea.getMaximizedDockable();
            maximizeArea.setMaximizedDockable(null);
            String string = maximizeArea.getUniqueId();
            if (this.lastMaximizedLocation.get(string) != null) {
                this.change(MAXIMIZED, this.lastMaximizedMode.remove(string), dockable, this.lastMaximizedLocation.remove(string), affectedSet);
            } else {
                String string2 = this.previousMode(dockable);
                if (string2 == null) {
                    string2 = this.getDefaultMode(dockable);
                }
                if (MAXIMIZED.equals(string2)) {
                    string2 = NORMALIZED;
                }
                this.change(MAXIMIZED, string2, dockable, affectedSet);
            }
        }
    }

    private void unmaximize(DockStation dockStation, AffectedSet affectedSet) {
        while (dockStation != null) {
            Dockable dockable;
            MaximizeArea maximizeArea = this.getMaximizeArea(dockStation);
            if (maximizeArea != null && (dockable = maximizeArea.getMaximizedDockable()) != null) {
                this.unmaximize(dockable, affectedSet);
                return;
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                return;
            }
            dockStation = dockable.getDockParent();
        }
    }

    private void normalize(Dockable dockable, Location location, AffectedSet affectedSet) {
        DockStation dockStation;
        boolean bl = false;
        affectedSet.add(dockable);
        if (location != null && location.location.getSuccessor() == null && (dockStation = this.history(dockable)) != null && ((String[])dockStation).length >= 2) {
            DockStation dockStation2;
            MaximizeArea maximizeArea;
            DockStation dockStation3 = dockStation[((DockStation)dockStation).length - 1];
            DockStation dockStation4 = dockStation[((DockStation)dockStation).length - 2];
            if (NORMALIZED.equals(dockStation4) && MAXIMIZED.equals(dockStation3) && (maximizeArea = this.getMaximizeArea(dockStation2 = this.stations.get(location.root))) != null) {
                maximizeArea.setMaximizedDockable(null);
                bl = true;
            }
        }
        if (!bl) {
            this.unmaximize(dockable, affectedSet);
            if (location != null && (dockStation = this.stations.get(location.root)) != null) {
                this.unmaximize(dockStation, affectedSet);
            }
            if (!this.drop(location, dockable) && !this.isValidNormalized(dockable)) {
                dockStation = this.getDefaultNormal(dockable);
                if (dockStation != null) {
                    this.unmaximize(dockStation, affectedSet);
                }
                this.checkedDrop(dockStation, dockable, null);
            }
        }
    }

    protected boolean isValidNormalized(Dockable dockable) {
        DockStation dockStation = this.getDefaultNormal(dockable);
        if (dockStation == null) {
            return false;
        }
        return DockUtilities.isAncestor((DockElement)dockStation, (DockElement)dockable);
    }

    protected DockStation getDefaultNormal(Dockable dockable) {
        return this.defaultNormal;
    }

    private void minimize(Dockable dockable, Location location, AffectedSet affectedSet) {
        Dockable dockable2 = null;
        MaximizeArea maximizeArea = null;
        affectedSet.add(dockable);
        if (MAXIMIZED.equals(this.currentMode(dockable))) {
            maximizeArea = this.getMaximizeArea(dockable);
            Dockable dockable3 = maximizeArea.getMaximizedDockable();
            if (dockable3 != null) {
                dockable2 = this.getMaximizingElement(dockable3, dockable);
            }
            this.unmaximize(dockable3, affectedSet);
        }
        if (!this.drop(location, dockable)) {
            this.checkedDrop((DockStation)this.defaultMini, dockable, null);
        }
        if (dockable2 != null && dockable2.getDockParent() != null) {
            this.maximize(this.currentMode(dockable2), maximizeArea, dockable2, affectedSet);
        }
    }

    private void externalize(Dockable dockable, Location location, AffectedSet affectedSet) {
        Object object;
        Dockable dockable2 = null;
        MaximizeArea maximizeArea = null;
        if (MAXIMIZED.equals(this.currentMode(dockable))) {
            maximizeArea = this.getMaximizeArea(dockable);
            object = maximizeArea.getMaximizedDockable();
            if (object != null) {
                dockable2 = this.getMaximizingElement((Dockable)object, dockable);
            }
            this.unmaximize((Dockable)object, affectedSet);
        }
        affectedSet.add(dockable);
        if (!this.drop(location, dockable) && dockable.getDockParent() != this.defaultExternal) {
            object = dockable.getComponent();
            ((Component)object).invalidate();
            Object object2 = object;
            while (((Component)object2).getParent() != null) {
                object2 = ((Component)object2).getParent();
            }
            ((Component)object2).validate();
            Point point = new Point();
            SwingUtilities.convertPointToScreen(point, dockable.getComponent());
            ScreenDockProperty screenDockProperty = new ScreenDockProperty(point.x, point.y, ((Component)object).getWidth(), ((Component)object).getHeight());
            boolean bl = this.defaultExternal.drop(dockable, screenDockProperty, false);
            if (!bl) {
                this.defaultExternal.drop(dockable);
            }
        }
        if (dockable2 != null && dockable2.getDockParent() != null) {
            this.maximize(this.currentMode(dockable2), maximizeArea, dockable2, affectedSet);
        }
    }

    private boolean drop(Location location, Dockable dockable) {
        if (location == null) {
            return false;
        }
        DockStation dockStation = this.stations.get(location.root);
        if (dockStation == null) {
            return false;
        }
        return dockStation.drop(dockable, location.getLocation());
    }

    private void checkedDrop(DockStation dockStation, Dockable dockable, DockableProperty dockableProperty) {
        if (dockStation != null && dockStation != dockable.getDockParent()) {
            if (dockStation == dockable) {
                throw new IllegalStateException("Trying to drop a DockStation on itself. If you are using a CControl: make sure that the CControl has a root station for all ExtendedModes. Do not use CDockables as root station or do not call CDockable.setVisible if you use them as root station.");
            }
            boolean bl = false;
            if (dockableProperty != null) {
                bl = dockStation.drop(dockable, dockableProperty);
            }
            if (!bl) {
                dockStation.drop(dockable);
            }
        }
    }

    protected void store(Dockable dockable) {
        DockUtilities.visit((Dockable)dockable, (DockUtilities.DockVisitor)new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                String string = StateManager.this.currentMode(dockable);
                if (string != null) {
                    StateManager.this.store(string, dockable);
                }
            }
        });
    }

    protected void store(String string, Dockable dockable) {
        if (!MAXIMIZED.equals(string)) {
            this.setProperties(string, dockable, this.currentLocation(string, dockable));
        }
    }

    protected void putMode(Dockable dockable) {
        DockUtilities.visit((Dockable)dockable, (DockUtilities.DockVisitor)new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                String string = StateManager.this.currentMode(dockable);
                if (string != null) {
                    StateManager.this.putMode(dockable, string);
                }
            }
        });
    }

    protected Location currentLocation(String string, Dockable dockable) {
        DockableProperty dockableProperty;
        String string2 = null;
        DockStation dockStation = null;
        dockStation = dockable.getDockParent();
        while (dockStation != null && string2 == null) {
            for (Map.Entry entry : this.stations.entrySet()) {
                if (entry.getValue() != dockStation) continue;
                string2 = (String)entry.getKey();
                break;
            }
            if (string2 != null) continue;
            dockableProperty = dockStation.asDockable();
            dockStation = dockableProperty == null ? null : dockableProperty.getDockParent();
        }
        if (string2 == null || dockStation == dockable) {
            return null;
        }
        dockableProperty = DockUtilities.getPropertyChain((DockStation)dockStation, (Dockable)dockable);
        return new Location(string2, dockableProperty);
    }

    protected String getRootName(Dockable dockable) {
        for (Map.Entry<String, DockStation> entry : this.stations.entrySet()) {
            if (!DockUtilities.isAncestor((DockElement)((DockElement)entry.getValue()), (DockElement)dockable)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected DockStation getStation(String string) {
        return this.stations.get(string);
    }

    private class Listener
    implements MaximizeAreaListener,
    DockRelocatorListener,
    DockRegisterListener,
    DockHierarchyListener {
        private Listener() {
        }

        public void maximizedChanged(MaximizeArea maximizeArea, Dockable dockable, Dockable dockable2) {
            if (!StateManager.this.onTransition) {
                if (dockable != null) {
                    StateManager.this.putMode(dockable);
                }
                if (dockable2 != null) {
                    StateManager.this.putMode(dockable2);
                }
            }
        }

        public void init(DockController dockController, Dockable dockable) {
        }

        public void cancel(DockController dockController, Dockable dockable) {
        }

        public void drag(DockController dockController, Dockable dockable, DockStation dockStation) {
            StateManager.this.store(StateManager.this.currentMode(dockable), dockable);
        }

        public void drop(DockController dockController, Dockable dockable, DockStation dockStation) {
            AffectedSet affectedSet = new AffectedSet();
            StateManager.this.unmaximize(dockStation, affectedSet);
            affectedSet.add(dockable);
            affectedSet.finish();
        }

        public void dockStationRegistered(DockController dockController, DockStation dockStation) {
        }

        public void dockStationRegistering(DockController dockController, DockStation dockStation) {
        }

        public void dockStationUnregistered(DockController dockController, DockStation dockStation) {
        }

        public void dockableRegistered(DockController dockController, Dockable dockable) {
            dockable.addDockHierarchyListener((DockHierarchyListener)this);
            StateManager.this.rebuild(dockable);
        }

        public void dockableRegistering(DockController dockController, Dockable dockable) {
        }

        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            dockable.removeDockHierarchyListener((DockHierarchyListener)this);
        }

        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        public void dockableCycledRegister(DockController dockController, Dockable dockable) {
        }

        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
            if (!StateManager.this.onTransition) {
                StateManager.this.rebuild(dockHierarchyEvent.getDockable());
            }
        }
    }

    private class AffectedSet {
        private Set<Dockable> set = new HashSet<Dockable>();

        private AffectedSet() {
        }

        public void add(Dockable dockable) {
            this.set.add(dockable);
            DockStation dockStation = dockable.asDockStation();
            if (dockStation != null) {
                int n = dockStation.getDockableCount();
                for (int i = 0; i < n; ++i) {
                    this.add(dockStation.getDockable(i));
                }
            }
        }

        public void finish() {
            for (Dockable dockable : this.set) {
                StateManager.this.putMode(dockable, StateManager.this.currentMode(dockable));
            }
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StateManagerSetting<B>
    extends ModeTransitionSetting<Location, B> {
        private Map<String, String> lastMaximizedMode;
        private Map<String, B> lastMaximizedLocation;

        public StateManagerSetting(ModeTransitionConverter<Location, B> modeTransitionConverter) {
            super(modeTransitionConverter);
        }

        public void setLastMaximizedMode(Map<String, String> map) {
            this.lastMaximizedMode = map;
        }

        public Map<String, String> getLastMaximizedMode() {
            return this.lastMaximizedMode;
        }

        public void setLastMaximizedLocation(Map<String, Location> map) {
            if (map == null) {
                this.lastMaximizedLocation = null;
            } else {
                this.lastMaximizedLocation = new HashMap<String, B>();
                for (Map.Entry<String, Location> entry : map.entrySet()) {
                    this.lastMaximizedLocation.put(entry.getKey(), this.getConverter().convertToSetting(entry.getValue()));
                }
            }
        }

        public Map<String, Location> getLastMaximizedLocation() {
            if (this.lastMaximizedLocation == null) {
                return null;
            }
            HashMap<String, Location> hashMap = new HashMap<String, Location>();
            for (Map.Entry<String, B> entry : this.lastMaximizedLocation.entrySet()) {
                hashMap.put(entry.getKey(), (Location)this.getConverter().convertToWorld(entry.getValue()));
            }
            return hashMap;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            int n;
            Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_7);
            super.write(dataOutputStream);
            if (this.lastMaximizedMode == null) {
                dataOutputStream.writeInt(0);
            } else {
                n = 0;
                for (String object : this.lastMaximizedMode.values()) {
                    if (object == null) continue;
                    ++n;
                }
                dataOutputStream.writeInt(n);
                for (Map.Entry entry : this.lastMaximizedMode.entrySet()) {
                    if (entry.getValue() == null) continue;
                    dataOutputStream.writeUTF((String)entry.getKey());
                    dataOutputStream.writeUTF((String)entry.getValue());
                }
            }
            if (this.lastMaximizedLocation == null) {
                dataOutputStream.writeInt(0);
            } else {
                n = 0;
                for (String string : this.lastMaximizedLocation.values()) {
                    if (string == null) continue;
                    ++n;
                }
                dataOutputStream.writeInt(n);
                for (Map.Entry entry : this.lastMaximizedLocation.entrySet()) {
                    if (entry.getValue() == null) continue;
                    dataOutputStream.writeUTF((String)entry.getKey());
                    this.getConverter().writeProperty(entry.getValue(), dataOutputStream);
                }
            }
        }

        @Override
        public void read(DataInputStream dataInputStream) throws IOException {
            Version version = Version.read((DataInputStream)dataInputStream);
            version.checkCurrent();
            this.lastMaximizedLocation = new HashMap<String, B>();
            this.lastMaximizedMode = new HashMap<String, String>();
            if (version.compareTo(Version.VERSION_1_0_7) < 0) {
                super.read(dataInputStream);
                if (dataInputStream.readBoolean()) {
                    dataInputStream.readUTF();
                }
                if (dataInputStream.readBoolean()) {
                    this.getConverter().readProperty(dataInputStream);
                }
            } else {
                String string;
                String string2;
                int n;
                super.read(dataInputStream);
                int n2 = dataInputStream.readInt();
                for (n = 0; n < n2; ++n) {
                    string2 = dataInputStream.readUTF();
                    string = dataInputStream.readUTF();
                    this.lastMaximizedMode.put(string2, string);
                }
                n2 = dataInputStream.readInt();
                for (n = 0; n < n2; ++n) {
                    string2 = dataInputStream.readUTF();
                    string = this.getConverter().readProperty(dataInputStream);
                    this.lastMaximizedLocation.put(string2, string);
                }
            }
        }

        @Override
        public void writeXML(XElement xElement) {
            super.writeXML(xElement.addElement("states"));
            HashSet<String> hashSet = new HashSet<String>();
            if (this.lastMaximizedLocation != null) {
                hashSet.addAll(this.lastMaximizedLocation.keySet());
            }
            if (this.lastMaximizedMode != null) {
                hashSet.addAll(this.lastMaximizedMode.keySet());
            }
            if (!hashSet.isEmpty()) {
                XElement xElement2 = xElement.addElement("maximized");
                for (String string : hashSet) {
                    String string2 = this.lastMaximizedMode.get(string);
                    B b = this.lastMaximizedLocation.get(string);
                    if (string2 == null && b == null) continue;
                    XElement xElement3 = xElement2.addElement("item");
                    xElement3.addString("id", string);
                    if (string2 != null) {
                        xElement3.addElement("mode").setString(string2);
                    }
                    if (b == null) continue;
                    this.getConverter().writePropertyXML(b, xElement3.addElement("location"));
                }
            }
        }

        @Override
        public void readXML(XElement xElement) {
            XElement xElement2 = xElement.getElement("states");
            if (xElement2 == null) {
                super.readXML(xElement);
            } else {
                super.readXML(xElement2);
                this.lastMaximizedLocation = new HashMap<String, B>();
                this.lastMaximizedMode = new HashMap<String, String>();
                XElement xElement3 = xElement.getElement("maximized");
                if (xElement3 != null) {
                    for (XElement xElement4 : xElement3.getElements("item")) {
                        XElement xElement5;
                        String string = xElement4.getString("id");
                        XElement xElement6 = xElement4.getElement("mode");
                        if (xElement6 != null) {
                            this.lastMaximizedMode.put(string, xElement6.getString());
                        }
                        if ((xElement5 = xElement4.getElement("location")) == null) continue;
                        this.lastMaximizedLocation.put(string, this.getConverter().readPropertyXML(xElement5));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocationConverter
    implements ModeTransitionConverter<Location, Location> {
        private PropertyTransformer transformer = new PropertyTransformer();

        @Override
        public Location convertToSetting(Location location) {
            return location;
        }

        @Override
        public Location convertToWorld(Location location) {
            return location;
        }

        @Override
        public void writeProperty(Location location, DataOutputStream dataOutputStream) throws IOException {
            Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_4);
            dataOutputStream.writeUTF(location.root);
            this.transformer.write(location.location, dataOutputStream);
        }

        @Override
        public Location readProperty(DataInputStream dataInputStream) throws IOException {
            Version version = Version.read((DataInputStream)dataInputStream);
            version.checkCurrent();
            String string = dataInputStream.readUTF();
            DockableProperty dockableProperty = this.transformer.read(dataInputStream);
            return new Location(string, dockableProperty);
        }

        @Override
        public void writePropertyXML(Location location, XElement xElement) {
            xElement.addElement("root").setString(location.getRoot());
            this.transformer.writeXML(location.getLocation(), xElement.addElement("location"));
        }

        @Override
        public Location readPropertyXML(XElement xElement) {
            return new Location(xElement.getElement("root").getString(), this.transformer.readXML(xElement.getElement("location")));
        }
    }

    public static class Location {
        private String root;
        private DockableProperty location;

        public Location(String string, DockableProperty dockableProperty) {
            this.root = string;
            this.location = dockableProperty;
        }

        public String getRoot() {
            return this.root;
        }

        public DockableProperty getLocation() {
            return this.location;
        }
    }
}

