/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.state;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.facile.state.MaximizeArea;
import bibliothek.gui.dock.facile.state.MaximizeAreaListener;
import bibliothek.gui.dock.station.split.SplitDockTree;
import java.util.ArrayList;
import java.util.List;

public class MaximizeSplitDockStation
implements MaximizeArea {
    private String uniqueId;
    private SplitDockStation station;
    private List<MaximizeAreaListener> listeners = new ArrayList<MaximizeAreaListener>();
    private SplitDockListener stationListener = new SplitDockListener(){

        public void fullScreenDockableChanged(SplitDockStation splitDockStation, Dockable dockable, Dockable dockable2) {
            MaximizeAreaListener[] maximizeAreaListenerArray;
            for (MaximizeAreaListener maximizeAreaListener : maximizeAreaListenerArray = MaximizeSplitDockStation.this.listeners.toArray(new MaximizeAreaListener[MaximizeSplitDockStation.this.listeners.size()])) {
                maximizeAreaListener.maximizedChanged(MaximizeSplitDockStation.this, dockable, dockable2);
            }
        }
    };

    public MaximizeSplitDockStation(String string, SplitDockStation splitDockStation) {
        if (string == null) {
            throw new IllegalArgumentException("uniqueId must not be null");
        }
        if (splitDockStation == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.uniqueId = string;
        this.station = splitDockStation;
    }

    public void addMaximizeAreaListener(MaximizeAreaListener maximizeAreaListener) {
        if (maximizeAreaListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listeners.isEmpty()) {
            this.station.addSplitDockStationListener(this.stationListener);
        }
        this.listeners.add(maximizeAreaListener);
    }

    public void removeMaximizeAreaListener(MaximizeAreaListener maximizeAreaListener) {
        this.listeners.remove(maximizeAreaListener);
        if (this.listeners.isEmpty()) {
            this.station.removeSplitDockStationListener(this.stationListener);
        }
    }

    public void dropAside(Dockable dockable) {
        SplitDockTree splitDockTree = this.station.createTree();
        if (splitDockTree.getRoot() == null) {
            splitDockTree.root(dockable);
        } else {
            splitDockTree.root(splitDockTree.horizontal(splitDockTree.put(new Dockable[]{dockable}), splitDockTree.unroot()));
        }
        this.station.dropTree(splitDockTree, false);
    }

    public Dockable getMaximizedDockable() {
        return this.station.getFullScreen();
    }

    public DockStation getStation() {
        return this.station;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setMaximizedDockable(Dockable dockable) {
        this.station.setFullScreen(dockable);
    }
}

