/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.DockUI;
import bibliothek.gui.dock.common.layout.ThemeMap;
import bibliothek.gui.dock.common.layout.ThemeMapListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import bibliothek.gui.dock.themes.ThemeFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JRadioButtonMenuItem;

public class ThemeMenuPiece
extends BaseMenuPiece {
    private DockController controller;
    private List<Item> items = new ArrayList<Item>();
    private ThemeMap themes;
    private boolean transferTheme = true;
    private ThemeMapListener listener = new ThemeMapListener(){

        public void changed(ThemeMap themeMap, int n, String string, ThemeFactory themeFactory, ThemeFactory themeFactory2) {
            if (themeFactory != null) {
                ThemeMenuPiece.this.items.remove(n);
                ThemeMenuPiece.this.remove(n);
            }
            if (themeFactory2 != null) {
                Item item = new Item(string, themeFactory2);
                ThemeMenuPiece.this.items.add(n, item);
                ThemeMenuPiece.this.insert(n, item);
            }
        }

        public void selectionChanged(ThemeMap themeMap, String string, String string2) {
            ThemeFactory themeFactory = ThemeMenuPiece.this.items.iterator();
            while (themeFactory.hasNext()) {
                Item item = (Item)themeFactory.next();
                item.setSelected(item.getKey().equals(string2));
            }
            if (ThemeMenuPiece.this.controller != null && ThemeMenuPiece.this.transferTheme && (themeFactory = ThemeMenuPiece.this.themes.getSelectedFactory()) != null) {
                ThemeMenuPiece.this.controller.setTheme(themeFactory.create());
            }
        }
    };

    public ThemeMenuPiece(DockController dockController, boolean bl) {
        this.setController(dockController);
        this.setTransferTheme(true);
        ThemeMap themeMap = new ThemeMap();
        if (bl) {
            DockUI dockUI = DockUI.getDefaultDockUI();
            int n = 0;
            for (ThemeFactory themeFactory : dockUI.getThemes()) {
                themeMap.add(String.valueOf(n++), themeFactory);
            }
            themeMap.select(dockUI.getDefaultTheme());
        }
        this.setThemes(themeMap);
    }

    public ThemeMenuPiece(DockController dockController, ThemeMap themeMap) {
        this.setTransferTheme(false);
        this.setController(dockController);
        this.setThemes(themeMap);
    }

    public void setTransferTheme(boolean bl) {
        this.transferTheme = bl;
    }

    public boolean isTransferTheme() {
        return this.transferTheme;
    }

    public void destroy() {
        this.setThemes(null);
        this.setController(null);
    }

    public void setThemes(ThemeMap themeMap) {
        if (this.themes != themeMap) {
            if (this.themes != null) {
                this.themes.removeThemeMapListener(this.listener);
                this.removeAll();
                this.items.clear();
            }
            this.themes = themeMap;
            if (themeMap != null) {
                ThemeFactory themeFactory;
                themeMap.addThemeMapListener(this.listener);
                String string = themeMap.getSelectedKey();
                int n = themeMap.size();
                for (int i = 0; i < n; ++i) {
                    Item item = new Item(themeMap.getKey(i), themeMap.getFactory(i));
                    this.items.add(item);
                    this.add(item);
                    item.setSelected(item.getKey().equals(string));
                }
                if (this.transferTheme && this.controller != null && (themeFactory = themeMap.getSelectedFactory()) != null) {
                    this.controller.setTheme(themeFactory.create());
                }
            }
        }
    }

    public ThemeMap getThemes() {
        return this.themes;
    }

    public DockController getController() {
        return this.controller;
    }

    public void setController(DockController dockController) {
        ThemeFactory themeFactory;
        this.controller = dockController;
        if (dockController != null && this.themes != null && this.transferTheme && (themeFactory = this.themes.getSelectedFactory()) != null) {
            dockController.setTheme(themeFactory.create());
        }
    }

    private class Item
    extends JRadioButtonMenuItem
    implements ActionListener {
        private String key;

        public Item(String string, ThemeFactory themeFactory) {
            this.key = string;
            this.setText(themeFactory.getName());
            this.setToolTipText(themeFactory.getDescription());
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThemeMenuPiece.this.themes.select(this.key);
        }

        public String getKey() {
            return this.key;
        }
    }
}

