/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.dock.support.lookandfeel.ComponentCollector;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelList;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JRadioButtonMenuItem;

public class LookAndFeelMenuPiece
extends BaseMenuPiece {
    private JRadioButtonMenuItem defaultButton;
    private JRadioButtonMenuItem systemButton;
    private Map<LookAndFeelList.Info, JRadioButtonMenuItem> buttons = new HashMap<LookAndFeelList.Info, JRadioButtonMenuItem>();
    private LookAndFeelList list;
    private ListListener listListener = new ListListener();
    private boolean onChange = false;

    public LookAndFeelMenuPiece() {
        this(null, null);
    }

    public LookAndFeelMenuPiece(final JFrame jFrame, LookAndFeelList lookAndFeelList) {
        if (lookAndFeelList == null) {
            lookAndFeelList = LookAndFeelList.getDefaultList();
        }
        this.list = lookAndFeelList;
        this.defaultButton = new JRadioButtonMenuItem("Default: " + lookAndFeelList.getDefault().getName());
        this.defaultButton.addItemListener(new SetListener(this.defaultButton, lookAndFeelList.getDefault()));
        this.add(this.defaultButton);
        this.systemButton = new JRadioButtonMenuItem(lookAndFeelList.getSystem().getName());
        this.systemButton.addItemListener(new SetListener(this.systemButton, lookAndFeelList.getSystem()));
        this.add(this.systemButton);
        this.addSeparator();
        int n = lookAndFeelList.size();
        for (int i = 0; i < n; ++i) {
            LookAndFeelList.Info info = lookAndFeelList.get(i);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(info.getName());
            this.buttons.put(info, jRadioButtonMenuItem);
            SetListener setListener = new SetListener(jRadioButtonMenuItem, info);
            jRadioButtonMenuItem.addItemListener(setListener);
            this.add(jRadioButtonMenuItem);
        }
        lookAndFeelList.addLookAndFeelListener(this.listListener);
        if (jFrame != null) {
            final ComponentCollector componentCollector = new ComponentCollector(){

                @Override
                public Collection<Component> listComponents() {
                    ArrayList<Component> arrayList = new ArrayList<Component>();
                    arrayList.add(jFrame);
                    return arrayList;
                }
            };
            lookAndFeelList.addComponentCollector(componentCollector);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    LookAndFeelMenuPiece.this.destroy();
                    LookAndFeelMenuPiece.this.list.removeComponentCollector(componentCollector);
                }
            });
        }
        this.changed();
    }

    public void destroy() {
        this.list.removeLookAndFeelListener(this.listListener);
    }

    public LookAndFeelList getList() {
        return this.list;
    }

    private void changed() {
        this.onChange = true;
        LookAndFeelList.Info info = this.list.getLookAndFeel();
        this.defaultButton.setSelected(this.list.getDefault() == info);
        this.systemButton.setSelected(this.list.getSystem() == info);
        for (Map.Entry<LookAndFeelList.Info, JRadioButtonMenuItem> entry : this.buttons.entrySet()) {
            entry.getValue().setSelected(info == entry.getKey());
        }
        this.onChange = false;
    }

    private class SetListener
    implements ItemListener {
        private JRadioButtonMenuItem item;
        private LookAndFeelList.Info info;

        public SetListener(JRadioButtonMenuItem jRadioButtonMenuItem, LookAndFeelList.Info info) {
            this.info = info;
            this.item = jRadioButtonMenuItem;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (!LookAndFeelMenuPiece.this.onChange) {
                if (this.item.isSelected()) {
                    LookAndFeelMenuPiece.this.list.setLookAndFeel(this.info);
                } else {
                    this.item.setSelected(true);
                }
            }
        }
    }

    private class ListListener
    implements LookAndFeelListener {
        private ListListener() {
        }

        public void lookAndFeelChanged(LookAndFeelList lookAndFeelList, LookAndFeelList.Info info) {
            LookAndFeelMenuPiece.this.changed();
        }

        public void defaultLookAndFeelChanged(LookAndFeelList lookAndFeelList, LookAndFeelList.Info info) {
            LookAndFeelMenuPiece.this.defaultButton.setText(info.getName());
        }

        public void systemLookAndFeelChanged(LookAndFeelList lookAndFeelList, LookAndFeelList.Info info) {
            LookAndFeelMenuPiece.this.systemButton.setText(info.getName());
        }

        public void lookAndFeelAdded(LookAndFeelList lookAndFeelList, LookAndFeelList.Info info) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(info.getName());
            LookAndFeelMenuPiece.this.buttons.put(info, jRadioButtonMenuItem);
            SetListener setListener = new SetListener(jRadioButtonMenuItem, info);
            jRadioButtonMenuItem.addItemListener(setListener);
            LookAndFeelMenuPiece.this.add(jRadioButtonMenuItem);
        }

        public void lookAndFeelRemoved(LookAndFeelList lookAndFeelList, LookAndFeelList.Info info) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)LookAndFeelMenuPiece.this.buttons.remove(info);
            if (jRadioButtonMenuItem != null) {
                LookAndFeelMenuPiece.this.remove(jRadioButtonMenuItem);
            }
        }
    }
}

