/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.facile.menu.FreeMenuPiece;
import bibliothek.gui.dock.facile.menu.FrontendSettingsDeleteList;
import bibliothek.gui.dock.facile.menu.FrontendSettingsLoadList;
import bibliothek.gui.dock.facile.menu.NodeMenuPiece;
import bibliothek.gui.dock.facile.menu.RootMenuPiece;
import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.SeparatingMenuPiece;
import bibliothek.gui.dock.support.util.Resources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class FrontendSettingsMenuPiece
extends NodeMenuPiece {
    private FrontendSettingsDeleteList delete;
    private FrontendSettingsLoadList load;
    private DockFrontend frontend;

    public FrontendSettingsMenuPiece(DockFrontend dockFrontend, boolean bl) {
        RootMenuPiece rootMenuPiece;
        this.delete = new FrontendSettingsDeleteList(dockFrontend);
        this.load = new FrontendSettingsLoadList(dockFrontend);
        this.frontend = dockFrontend;
        FreeMenuPiece freeMenuPiece = new FreeMenuPiece();
        JMenuItem jMenuItem = new JMenuItem(Resources.getBundle().getString("FrontendSettingsMenuPiece.save"));
        JMenuItem jMenuItem2 = new JMenuItem(Resources.getBundle().getString("FrontendSettingsMenuPiece.saveAs"));
        freeMenuPiece.add(jMenuItem);
        freeMenuPiece.add(jMenuItem2);
        if (bl) {
            rootMenuPiece = new RootMenuPiece(Resources.getBundle().getString("FrontendSettingsMenuPiece.load"), true, new MenuPiece[0]);
            freeMenuPiece.add(rootMenuPiece.getMenu());
            rootMenuPiece.add(this.load);
        }
        rootMenuPiece = new RootMenuPiece(Resources.getBundle().getString("FrontendSettingsMenuPiece.delete"), true, new MenuPiece[0]);
        rootMenuPiece.add(this.delete);
        freeMenuPiece.add(rootMenuPiece.getMenu());
        this.add(freeMenuPiece);
        if (!bl) {
            this.add(new SeparatingMenuPiece(this.load, true, false, false));
        }
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrontendSettingsMenuPiece.this.save((Component)actionEvent.getSource());
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrontendSettingsMenuPiece.this.saveAs((Component)actionEvent.getSource());
            }
        });
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public void setFrontend(DockFrontend dockFrontend) {
        this.frontend = dockFrontend;
        this.load.setFrontend(dockFrontend);
        this.delete.setFrontend(dockFrontend);
    }

    public void save(Component component) {
        if (this.frontend != null) {
            if (this.frontend.getCurrentSetting() == null) {
                this.saveAs(component);
            } else {
                this.frontend.save();
            }
        }
    }

    public void saveAs(Component component) {
        String string;
        if (this.frontend != null && (string = JOptionPane.showInputDialog(component, (Object)Resources.getBundle().getString("FrontendSettingsMenuPiece.saveAsInput"))) != null) {
            Set set = this.frontend.getSettings();
            if (set.contains(string)) {
                int n = 1;
                while (set.contains(string + " (" + n + ")")) {
                    ++n;
                }
                string = string + " (" + n + ")";
            }
            this.frontend.save(string);
        }
    }
}

