/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.support.util.Resources;
import java.util.ResourceBundle;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    public static final String KEY_ICON = "replace";
    private DockStationListener dockStationListener;
    private DockController controller;
    private Listener listener = new Listener();

    public ReplaceAction(DockController dockController) {
        super(null);
        this.dockStationListener = new DockStationAdapter(){

            public void dockableAdded(DockStation dockStation, Dockable dockable) {
                ReplaceAction.this.setGroup(ReplaceAction.this.createGroupKey(dockStation.asDockable()), dockStation.asDockable());
            }

            public void dockableRemoved(DockStation dockStation, Dockable dockable) {
                ReplaceAction.this.setGroup(ReplaceAction.this.createGroupKey(dockStation.asDockable()), dockStation.asDockable());
            }
        };
        this.setRemoveEmptyGroups(false);
        this.setEnabled(true, true);
        this.setEnabled(false, false);
        ResourceBundle resourceBundle = Resources.getBundle();
        this.setText(true, resourceBundle.getString(KEY_ICON));
        this.setText(false, resourceBundle.getString(KEY_ICON));
        this.setTooltip(true, resourceBundle.getString("replace.tooltip"));
        this.setTooltip(false, resourceBundle.getString("replace.tooltip"));
        this.setController(dockController);
    }

    protected Boolean createGroupKey(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("Only dockables which are also a DockStation can be used for a ReplaceAction");
        }
        DockStation dockStation2 = dockable.getDockParent();
        if (dockStation2 == null) {
            return false;
        }
        int n = dockStation.getDockableCount();
        if (n == 0) {
            return dockStation2.canDrag(dockable);
        }
        if (n == 1) {
            return dockStation2.canReplace(dockable, dockStation.getDockable(0)) && dockStation2.accept(dockStation.getDockable(0)) && dockStation.getDockable(0).accept(dockStation2) && dockStation.canDrag(dockStation.getDockable(0));
        }
        return false;
    }

    public void action(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        DockStation dockStation2 = dockable.getDockParent();
        if (dockStation2 != null) {
            if (dockStation.getDockableCount() == 0) {
                if (dockStation2.canDrag(dockStation.asDockable())) {
                    dockStation2.drag(dockStation.asDockable());
                }
            } else if (dockStation2.canReplace(dockStation.asDockable(), dockStation.getDockable(0)) && dockStation2.accept(dockStation.getDockable(0)) && dockStation.getDockable(0).accept(dockStation2) && dockStation.canDrag(dockStation.getDockable(0))) {
                dockable = dockStation.getDockable(0);
                dockStation.drag(dockable);
                dockStation2.replace(dockStation.asDockable(), dockable);
            }
        }
    }

    public void bound(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        dockStation.addDockStationListener(this.dockStationListener);
        super.bound(dockable);
    }

    public void unbound(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        dockStation.removeDockStationListener(this.dockStationListener);
        super.unbound(dockable);
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getIcons().remove(KEY_ICON, (IconManagerListener)this.listener);
            }
            this.controller = dockController;
            if (dockController != null) {
                dockController.getIcons().setIconDefault(KEY_ICON, Resources.getIcon(KEY_ICON));
                dockController.getIcons().add(KEY_ICON, (IconManagerListener)this.listener);
                Icon icon = dockController.getIcons().getIcon(KEY_ICON);
                this.setIcon(true, icon);
                this.setIcon(false, icon);
            }
        }
    }

    private class Listener
    implements IconManagerListener {
        private Listener() {
        }

        public void iconChanged(String string, Icon icon) {
            ReplaceAction.this.setIcon(true, icon);
            ReplaceAction.this.setIcon(false, icon);
        }
    }
}

