/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.stack.StackDockProperty;

public class CStackLocation
extends AbstractStackholdingLocation {
    private int index;
    private CLocation parent;

    public CStackLocation(CLocation cLocation) {
        this(cLocation, Integer.MAX_VALUE);
    }

    public CStackLocation(CLocation cLocation, int n) {
        if (cLocation == null) {
            throw new IllegalArgumentException("Parent must not be null");
        }
        this.parent = cLocation;
        this.index = n;
    }

    public String findRoot() {
        return this.parent.findRoot();
    }

    public CDockable.ExtendedMode findMode() {
        return this.parent.findMode();
    }

    public DockableProperty findProperty(DockableProperty dockableProperty) {
        StackDockProperty stackDockProperty = new StackDockProperty(this.index);
        stackDockProperty.setSuccessor(dockableProperty);
        return this.parent.findProperty((DockableProperty)stackDockProperty);
    }

    public CLocation aside() {
        if (this.index == Integer.MAX_VALUE) {
            return this;
        }
        return new CStackLocation(this.parent, this.index + 1);
    }

    public String toString() {
        return String.valueOf(this.parent) + " [stack " + this.index + "]";
    }
}

