/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.location.AbstractTreeLocation;
import bibliothek.gui.dock.common.location.CRectangleLocation;
import bibliothek.gui.dock.common.location.CStackLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.location.TreeLocationRoot;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;

public abstract class CSplitLocation
extends CLocation {
    public CLocation aside() {
        return this;
    }

    public CRectangleLocation rectangle(double d, double d2, double d3, double d4) {
        return new CRectangleLocation(this, d, d2, d3, d4);
    }

    public CStackLocation stack() {
        return this.rectangle(0.0, 0.0, 1.0, 1.0).stack();
    }

    public CStackLocation stack(int n) {
        return this.rectangle(0.0, 0.0, 1.0, 1.0).stack(n);
    }

    public TreeLocationRoot north(double d) {
        return new TreeLocationRoot(this, d, Side.NORTH);
    }

    public TreeLocationRoot south(double d) {
        return new TreeLocationRoot(this, d, Side.SOUTH);
    }

    public TreeLocationRoot east(double d) {
        return new TreeLocationRoot(this, d, Side.EAST);
    }

    public TreeLocationRoot west(double d) {
        return new TreeLocationRoot(this, d, Side.WEST);
    }

    public CLocation expandProperty(DockableProperty dockableProperty) {
        SplitDockProperty splitDockProperty;
        CLocation cLocation = null;
        if (dockableProperty instanceof SplitDockProperty) {
            splitDockProperty = (SplitDockProperty)dockableProperty;
            cLocation = this.rectangle(splitDockProperty.getX(), splitDockProperty.getY(), splitDockProperty.getWidth(), splitDockProperty.getHeight());
        } else if (dockableProperty instanceof SplitDockPathProperty) {
            splitDockProperty = (SplitDockPathProperty)dockableProperty;
            if (splitDockProperty.size() > 0) {
                AbstractTreeLocation abstractTreeLocation = null;
                SplitDockPathProperty.Node node = splitDockProperty.getNode(0);
                switch (node.getLocation()) {
                    case BOTTOM: {
                        abstractTreeLocation = this.south(node.getSize());
                        break;
                    }
                    case LEFT: {
                        abstractTreeLocation = this.west(node.getSize());
                        break;
                    }
                    case RIGHT: {
                        abstractTreeLocation = this.east(node.getSize());
                        break;
                    }
                    case TOP: {
                        abstractTreeLocation = this.north(node.getSize());
                    }
                }
                int n = splitDockProperty.size();
                block12: for (int i = 1; i < n; ++i) {
                    node = splitDockProperty.getNode(i);
                    switch (node.getLocation()) {
                        case BOTTOM: {
                            abstractTreeLocation = abstractTreeLocation.south(node.getSize());
                            continue block12;
                        }
                        case LEFT: {
                            abstractTreeLocation = abstractTreeLocation.west(node.getSize());
                            continue block12;
                        }
                        case RIGHT: {
                            abstractTreeLocation = abstractTreeLocation.east(node.getSize());
                            continue block12;
                        }
                        case TOP: {
                            abstractTreeLocation = abstractTreeLocation.north(node.getSize());
                        }
                    }
                }
                cLocation = abstractTreeLocation;
            } else {
                cLocation = this.rectangle(0.0, 0.0, 1.0, 1.0);
            }
        }
        splitDockProperty = dockableProperty.getSuccessor();
        if (splitDockProperty == null) {
            return cLocation;
        }
        return cLocation.expandProperty((DockableProperty)splitDockProperty);
    }

    public CDockable.ExtendedMode findMode() {
        return CDockable.ExtendedMode.NORMALIZED;
    }

    public DockableProperty findProperty(DockableProperty dockableProperty) {
        SplitDockProperty splitDockProperty = new SplitDockProperty(0.0, 0.0, 1.0, 1.0);
        splitDockProperty.setSuccessor(dockableProperty);
        return splitDockProperty;
    }
}

