/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.location.TreeLocationNode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;

public abstract class AbstractTreeLocation
extends AbstractStackholdingLocation {
    private double size;
    private Side side;

    public AbstractTreeLocation(double d, Side side) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Size must be at least 0");
        }
        if (d > 1.0) {
            throw new IllegalArgumentException("Size must be no more than 1");
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Size must not be NaN");
        }
        if (side == null) {
            throw new NullPointerException("side must not be null");
        }
        this.size = d;
        this.side = side;
    }

    public Side getSide() {
        return this.side;
    }

    public double getSize() {
        return this.size;
    }

    public TreeLocationNode north(double d) {
        return new TreeLocationNode(this, d, Side.NORTH);
    }

    public TreeLocationNode south(double d) {
        return new TreeLocationNode(this, d, Side.SOUTH);
    }

    public TreeLocationNode east(double d) {
        return new TreeLocationNode(this, d, Side.EAST);
    }

    public TreeLocationNode west(double d) {
        return new TreeLocationNode(this, d, Side.WEST);
    }

    public CDockable.ExtendedMode findMode() {
        return CDockable.ExtendedMode.NORMALIZED;
    }

    protected abstract SplitDockPathProperty findParentProperty();

    public SplitDockPathProperty findProperty(DockableProperty dockableProperty) {
        SplitDockPathProperty splitDockPathProperty = this.findParentProperty();
        splitDockPathProperty.setSuccessor(dockableProperty);
        switch (this.side) {
            case NORTH: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.TOP, this.size);
                break;
            }
            case SOUTH: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.BOTTOM, this.size);
                break;
            }
            case EAST: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.RIGHT, this.size);
                break;
            }
            case WEST: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.LEFT, this.size);
            }
        }
        return splitDockPathProperty;
    }

    public CLocation aside() {
        return this.stack(1);
    }

    public String toString() {
        return "[normal " + (Object)((Object)this.side) + " " + this.size + "]";
    }
}

