/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UITransmitter<V, U extends UIValue<V>>
implements UIBridge<V, U> {
    private CControl control;
    private Set<String> keys = new HashSet<String>();
    private Map<String, List<U>> values = new HashMap<String, List<U>>();
    private Listener listener = new Listener();

    public UITransmitter(String ... stringArray) {
        for (String string : stringArray) {
            this.keys.add(string);
        }
    }

    public void add(String string, U u) {
        if (this.keys.contains(string)) {
            boolean bl = this.values.isEmpty();
            List<U> list = this.values.get(string);
            if (list == null) {
                list = new LinkedList<U>();
                this.values.put(string, list);
            }
            list.add(u);
            if (bl) {
                this.setListening(true);
            }
        }
    }

    public void remove(String string, U u) {
        if (this.keys.contains(string)) {
            boolean bl = this.values.isEmpty();
            List<U> list = this.values.get(string);
            list.remove(u);
            if (list.isEmpty()) {
                this.values.remove(string);
            }
            if (!bl && this.values.isEmpty()) {
                this.setListening(false);
            }
        }
    }

    public void setControl(CControl cControl) {
        if (!this.values.isEmpty()) {
            this.setListening(false);
        }
        this.control = cControl;
        if (!this.values.isEmpty()) {
            this.setListening(true);
        }
    }

    private void setListening(boolean bl) {
        block4: {
            if (this.control == null) break block4;
            if (bl) {
                this.control.addControlListener(this.listener);
                int n = this.control.getCDockableCount();
                for (int i = 0; i < n; ++i) {
                    this.connect(this.control.getCDockable(i));
                }
            } else {
                this.control.removeControlListener(this.listener);
                int n = this.control.getCDockableCount();
                for (int i = 0; i < n; ++i) {
                    this.disconnect(this.control.getCDockable(i));
                }
            }
        }
    }

    public void set(String string, V v, U u) {
        if (this.keys.contains(string)) {
            v = this.get(v, string, u);
        }
        u.set(v);
    }

    protected abstract V get(V var1, String var2, U var3);

    protected abstract void update(CDockable var1, String var2, V var3);

    protected abstract CDockable getDockable(U var1);

    protected void set(String string, V v, CDockable cDockable) {
        List<U> list = this.values.get(string);
        if (list != null) {
            for (UIValue uIValue : list) {
                if (cDockable != this.getDockable(uIValue)) continue;
                uIValue.set(v);
            }
        }
    }

    protected abstract void connect(CDockable var1);

    protected abstract void disconnect(CDockable var1);

    private class Listener
    implements CControlListener {
        private Listener() {
        }

        public void added(CControl cControl, CDockable cDockable) {
        }

        public void removed(CControl cControl, CDockable cDockable) {
        }

        public void closed(CControl cControl, CDockable cDockable) {
            UITransmitter.this.disconnect(cDockable);
        }

        public void opened(CControl cControl, CDockable cDockable) {
            UITransmitter.this.connect(cDockable);
        }
    }
}

